/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.GlSampler;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.opengl.Uniform;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.DynamicUniformsExtension;
import net.diebuddies.minecraft.LightUniform;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.render.DynamicUniformStorageExtension;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.PBRDrawCall;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL33C;

public class ClothRenderer {
    private MainRenderer mainRenderer;
    private List<ClothDrawCall> drawCalls = new ObjectArrayList();
    private double lastRenderPercent;
    private PoseStack tmpStack = new PoseStack();

    public ClothRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void renderDynamicCloth(ClientLevel level, Matrix4f viewMatrix, Matrix4f projectionMatrix) {
        if (level == null) {
            return;
        }
        List<VerletSimulation> dynamicCloth = PhysicsMod.dynamicCloth.get((Object)PhysicsMod.getRenderPass());
        if (dynamicCloth != null && dynamicCloth.size() > 0) {
            for (int i = 0; i < dynamicCloth.size(); ++i) {
                dynamicCloth.get(i).renderSlow((Level)level);
            }
            dynamicCloth.clear();
        }
    }

    public void renderStaticCloth(ClientLevel level, Matrix4f viewMatrix, Matrix4f projectionMatrix) {
        if (level == null || PhysicsMod.clothRenderFast.size() == 0) {
            return;
        }
        VAO.storePreviouslyBoundState();
        PhysicsMod.storeShaderLightDirections();
        PerformanceTracker.startNoFlush("cloth_rendering");
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)MainRenderer.levelProjectionMatrixBuffer.getBuffer(projectionMatrix), (ProjectionType)ProjectionType.PERSPECTIVE);
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.LEVEL);
        for (int i = 0; i < PhysicsMod.clothRenderFast.size(); ++i) {
            ClothRenderCommand renderCommand = PhysicsMod.clothRenderFast.get(i);
            this.queueDrawCall(level, renderCommand);
        }
        PhysicsMod.clothRenderFast.clear();
        this.uploadDrawCallTransforms();
        RenderPass renderPass = this.mainRenderer.bindProperShader(() -> "Physics Mod Static Cloth", this.mainRenderer.getProperSolidRenderPipeline());
        this.mainRenderer.setupShader(renderPass);
        this.executeDrawCalls(renderPass);
        renderPass.close();
        VAO.restorePreviouslyBoundState();
        GlStateManager._activeTexture((int)33984);
        GlStateManager._enableCull();
        PhysicsMod.restoreShaderLightDirections();
        RenderSystem.restoreProjectionMatrix();
        PerformanceTracker.end("cloth_rendering");
    }

    private void queueDrawCall(ClientLevel level, ClothRenderCommand renderCommand) {
        Vec3 view = Minecraft.getInstance().gameRenderer.getMainCamera().position();
        double renderPercent = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true);
        if (Minecraft.getInstance().isPaused()) {
            renderPercent = this.lastRenderPercent;
        } else {
            this.lastRenderPercent = renderPercent;
        }
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.pushMatrix();
        LivingEntity entity = renderCommand.entity;
        double px = Mth.lerp((double)renderPercent, (double)entity.xOld, (double)entity.getX());
        double py = Mth.lerp((double)renderPercent, (double)entity.yOld, (double)entity.getY());
        double pz = Mth.lerp((double)renderPercent, (double)entity.zOld, (double)entity.getZ());
        matrixStack.translation((float)(-view.x + px), (float)(-view.y + py), (float)(-view.z + pz));
        renderCommand.modelPart.loadPose(renderCommand.modelPose);
        this.tmpStack.last().pose().set((Matrix4fc)matrixStack);
        ModelPartConstraint.entityTransformation(this.tmpStack, entity, (float)renderPercent);
        ModelPartConstraint.modelPartTransformation(renderCommand.modelPart, this.tmpStack);
        Matrix4f transformation = this.tmpStack.last().pose();
        ClothDrawCall drawCall = new ClothDrawCall();
        drawCall.light = this.mainRenderer.setupLighting(transformation, level, true);
        drawCall.brightness = renderCommand.brightness;
        drawCall.player = renderCommand.cloth.playerVAO;
        PhysicsMod.viewMatrix.mul((Matrix4fc)transformation, transformation);
        drawCall.transform = MainRenderer.createTransformUniform(transformation);
        if (!renderCommand.onlyRenderPlayer) {
            drawCall.texture = renderCommand.textureID;
            drawCall.fetchPBRTextures(drawCall.texture);
            drawCall.cloth = ConfigClient.clothSmoothShading ? renderCommand.cloth.vao : renderCommand.cloth.vaoFlatShaded;
        }
        if (renderCommand.cloth.playerVAO != null && entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            drawCall.playerTexture = Minecraft.getInstance().getTextureManager().getTexture(player.getSkin().body().texturePath()).getTextureView();
            drawCall.fetchPBRTextures(drawCall.playerTexture);
        }
        this.drawCalls.add(drawCall);
        matrixStack.popMatrix();
    }

    public void uploadDrawCallTransforms() {
        DynamicUniformsExtension dynamicUniforms = (DynamicUniformsExtension)RenderSystem.getDynamicUniforms();
        ((DynamicUniformStorageExtension)dynamicUniforms.physicsmod$getDynamicUniformStorage()).physicsmod$writeUniforms(this.drawCalls, drawCall -> drawCall.transform, (drawCall, gpuSlice) -> {
            drawCall.transformBuffer = gpuSlice;
        });
        ((DynamicUniformStorageExtension)dynamicUniforms.physicsmod$getLightUniformStorage()).physicsmod$writeUniforms(this.drawCalls, drawCall -> drawCall.light, (drawCall, gpuSlice) -> {
            drawCall.lightBuffer = gpuSlice;
        });
    }

    private void executeDrawCalls(RenderPass renderPass) {
        int size = this.drawCalls.size();
        GlRenderPass glRenderPass = (GlRenderPass)renderPass;
        GlProgram program = glRenderPass.pipeline.program();
        Uniform.Ubo dynamicTransforms = (Uniform.Ubo)program.getUniform("DynamicTransforms");
        Uniform.Ubo lighting = (Uniform.Ubo)program.getUniform("Lighting");
        GlStateManager._activeTexture((int)33984);
        GlStateManager._disableCull();
        GL32C.glVertexAttribI2ui((int)Data.OVERLAY.getAttribute(), (int)0, (int)10);
        GL32C.glVertexAttrib4f((int)Data.COLOR.getAttribute(), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f);
        } else {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_SHADER.getAttribute(), (float)0.0f, (float)0.0f);
        }
        for (int i = 0; i < size; ++i) {
            GpuBufferSlice slice;
            ClothDrawCall drawCall = this.drawCalls.get(i);
            GL32C.glVertexAttribI2ui((int)Data.LIGHT.getAttribute(), (int)(drawCall.brightness & 0xF0), (int)(drawCall.brightness >> 16 & 0xF0));
            if (dynamicTransforms != null) {
                slice = drawCall.transformBuffer;
                GL32C.glBindBufferRange((int)35345, (int)dynamicTransforms.blockBinding(), (int)((GlBuffer)slice.buffer()).handle, (long)slice.offset(), (long)slice.length());
            }
            if (lighting != null) {
                slice = drawCall.lightBuffer;
                GL32C.glBindBufferRange((int)35345, (int)lighting.blockBinding(), (int)((GlBuffer)slice.buffer()).handle, (long)slice.offset(), (long)slice.length());
            }
            if (drawCall.cloth != null) {
                GpuTextureView glID = drawCall.texture;
                GlStateManager._activeTexture((int)33984);
                GlStateManager._bindTexture((int)((GlTexture)glID.texture()).glId());
                GL33C.glBindSampler((int)0, (int)((GlSampler)MainRenderer.NEAREST_SAMPLER).getId());
                drawCall.bindPBRTextures();
                drawCall.cloth.render();
            }
            if (drawCall.player == null) continue;
            GlStateManager._activeTexture((int)33984);
            GlStateManager._bindTexture((int)((GlTexture)drawCall.playerTexture.texture()).glId());
            GL33C.glBindSampler((int)0, (int)((GlSampler)MainRenderer.NEAREST_SAMPLER).getId());
            drawCall.bindPBRTextures();
            drawCall.player.render();
        }
        this.drawCalls.clear();
    }

    private static class ClothDrawCall
    extends PBRDrawCall {
        public DynamicUniforms.Transform transform;
        public GpuBufferSlice transformBuffer;
        public LightUniform light;
        public GpuBufferSlice lightBuffer;
        @Nullable
        public VAO cloth;
        @Nullable
        public VAO player;
        @Nullable
        public GpuTextureView playerTexture;
        public int brightness;

        private ClothDrawCall() {
        }
    }
}

