/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.opengl.StateTracker;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.shader.PhysicsShaders;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fStack;

public class TransparencyRenderer {
    private MainRenderer mainRenderer;
    public List<MainRenderer.PhysicsDrawCall> drawCalls;

    public TransparencyRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
        this.drawCalls = new ObjectArrayList();
    }

    public void render(PhysicsWorld physics, ClientLevel level, Matrix4fStack viewMatrixStack, Vec3 view) {
        if (this.drawCalls.size() > 0) {
            PerformanceTracker.startNoFlush("transparent_blocks_mobs_particles_rendering");
            boolean useCustomShader = true;
            if (StarterClient.iris && Iris.isExtending()) {
                useCustomShader = false;
            }
            if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
                useCustomShader = false;
            }
            RenderPipeline pipeline = null;
            if (useCustomShader) {
                pipeline = PhysicsShaders.PHYSICS_ENTITY_TRANSPARENT_PIPELINE;
            } else {
                if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
                    Optifine.useEntityShader();
                }
                pipeline = RenderPipelines.ENTITY_TRANSLUCENT;
            }
            this.drawCalls.sort((a, b) -> -Double.compare(((TranslucentPhysicsDrawCall)a).distanceToCamera, ((TranslucentPhysicsDrawCall)b).distanceToCamera));
            this.mainRenderer.uploadDrawCallTransforms(this.drawCalls);
            RenderPass renderPass = this.mainRenderer.bindProperShader(() -> "Physics Mod Translucent", pipeline);
            this.mainRenderer.setupShader(renderPass);
            physics.bindForRendering();
            this.mainRenderer.executeDrawCalls(renderPass, this.drawCalls, this.mainRenderer.viewMatrix, physics.format);
            renderPass.close();
            StateTracker.unbindVertexArray();
            PerformanceTracker.end("transparent_blocks_mobs_particles_rendering");
        }
        this.drawCalls.clear();
    }

    public static void destroy() {
    }

    public static class TranslucentPhysicsDrawCall
    extends MainRenderer.PhysicsDrawCall {
        public double distanceToCamera;

        public TranslucentPhysicsDrawCall(double distanceToCamera) {
            this.distanceToCamera = distanceToCamera;
        }
    }
}

