/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.BlockUpdate;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ocean.BlockToByte;
import net.diebuddies.physics.ocean.OceanBlockUpdate;
import net.diebuddies.physics.snow.SnowSearcher;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunk.class})
public class MixinLevelChunk {
    @Shadow
    private Level level;

    @Inject(at={@At(value="HEAD")}, method={"setBlockState"})
    private void setBlockState(BlockPos pos, BlockState state, int type, CallbackInfoReturnable<BlockState> ci) {
        if (RenderSystem.isOnRenderThread() && this.level instanceof ClientLevel) {
            BlockState before = this.level.getBlockState(pos);
            PhysicsMod mod = PhysicsMod.getInstance(this.level);
            if ((type & 0x40) == 0) {
                mod.blockUpdates.add(pos.immutable());
                if (before != null && state != null && (before.isAir() && !state.isAir() || state.isAir() && !before.isAir() || !before.isAir() && state.getBlock() == Blocks.WATER)) {
                    BlockUpdate update = new BlockUpdate(this.level, pos.immutable(), before);
                    if (before.hasBlockEntity()) {
                        update.blockEntity = this.level.getBlockEntity(pos);
                    }
                    mod.updateQueue.add(update);
                }
            }
            if (ConfigClient.areSnowPhysicsEnabled() && before != null && state != null && (SnowSearcher.getSnowProperty(state) != null || SnowSearcher.getSnowProperty(before) != null)) {
                mod.physicsWorld.getSnowWorld().getBlockUpdates().addOrReplace(new BlockUpdate(this.level, pos.immutable(), state));
            }
            if (ConfigClient.areOceanPhysicsEnabled() && before != null && state != null) {
                mod.physicsWorld.getOceanWorld().getBlockUpdates().addOrReplace(new OceanBlockUpdate(this.level, pos.immutable(), BlockToByte.convert(state)));
            }
        }
    }
}

