/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.FishingHookConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.entity.state.FishingHookRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FishingHookRenderer.class})
public abstract class MixinFishingHookRenderer {
    @Unique
    private Map<FishingHook, VerletSimulation> simulations = new Object2ObjectOpenHashMap();

    @Inject(at={@At(value="RETURN")}, method={"extractRenderState"}, cancellable=true)
    private void physicsmod$clothSimulations(FishingHook fishingHook, FishingHookRenderState fishingHookRenderState, float tickDelta, CallbackInfo info) {
        Player player;
        if (ConfigClient.areOceanPhysicsEnabled() && (player = fishingHook.getPlayerOwner()) != null) {
            double offset = ((EntityOcean)player).getPhysicsYOffset(tickDelta) - ((EntityOcean)fishingHook).getPhysicsYOffset(tickDelta);
            fishingHookRenderState.lineOriginOffset = fishingHookRenderState.lineOriginOffset.add(0.0, offset, 0.0);
        }
        if (ConfigClient.fishingRodPhysics) {
            Level level;
            Iterator<Map.Entry<FishingHook, VerletSimulation>> it = this.simulations.entrySet().iterator();
            while (it.hasNext()) {
                if (!it.next().getValue().destroyed) continue;
                it.remove();
            }
            VerletSimulation simulation = this.simulations.get(fishingHook);
            Player player2 = fishingHook.getPlayerOwner();
            if (player2 != null && (level = player2.level()) instanceof ClientLevel) {
                ClientLevel level2 = (ClientLevel)level;
                int light = Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords((Entity)fishingHook, tickDelta);
                if (simulation == null) {
                    simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(fishingHook.level().dimension().location())), 20, 0.855);
                    simulation.addConstraint(new WorldConstraint((Entity)fishingHook, 0.0f));
                    simulation.addConstraint(new FishingHookConstraint(simulation, (FishingHookRenderer)this, fishingHook, player2, tickDelta));
                    simulation.brightness = light;
                    simulation.textureID = PhysicsMod.whiteTexture;
                    simulation.alwaysFetchInstantly = false;
                    this.simulations.put(fishingHook, simulation);
                    PhysicsMod.getInstance((Level)level2).physicsWorld.addVerletSimulation(simulation);
                } else if (!simulation.destroyed) {
                    simulation.active = true;
                    simulation.brightness = light;
                    simulation.getConstraint(FishingHookConstraint.class).calculatePlayerAndHookPos((FishingHookRenderer)this, fishingHook, player2, tickDelta);
                }
                PhysicsMod.dynamicCloth.computeIfAbsent(PhysicsMod.getRenderPass(), key -> new ObjectArrayList()).add(simulation);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"stringVertex"}, cancellable=true)
    private static void physicsmod$cancelLineRender(float x, float y, float z, VertexConsumer vertexConsumer, PoseStack.Pose pose, float startPerc, float endPerc, CallbackInfo info) {
        if (ConfigClient.fishingRodPhysics) {
            info.cancel();
        }
    }
}

