/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.LeashConstraint;
import net.diebuddies.physics.verlet.constraints.RenderConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.diebuddies.util.ObjectPacked;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class}, priority=900)
public abstract class MixinMobRenderer<T extends Entity, S extends EntityRenderState> {
    @Unique
    private Map<ObjectPacked, List<VerletSimulation>> storedSimulations = new Object2ObjectOpenHashMap();
    @Unique
    private ObjectPacked tmp = new ObjectPacked(null, null);

    @Inject(at={@At(value="RETURN")}, method={"extractRenderState"}, cancellable=true)
    private void physicsmod$clothSimulations(T entity, S entityRenderState, float tickDelta, CallbackInfo info) {
        List leashStates = ((EntityRenderState)entityRenderState).leashStates;
        if (leashStates != null) {
            EntityRenderState.LeashState leashState2;
            Entity entity2;
            if (entity instanceof Leashable) {
                Leashable leashable = (Leashable)entity;
                entity2 = leashable.getLeashHolder();
            } else {
                entity2 = null;
            }
            Entity leashHolder = entity2;
            for (EntityRenderState.LeashState leashState2 : leashStates) {
                if (!ConfigClient.areOceanPhysicsEnabled()) continue;
                leashState2.start = leashState2.start.add(0.0, ((EntityOcean)entity).getPhysicsYOffset(tickDelta), 0.0);
                if (leashHolder == null) continue;
                leashState2.end = leashState2.end.add(0.0, ((EntityOcean)leashHolder).getPhysicsYOffset(tickDelta), 0.0);
            }
            if (ConfigClient.leashPhysics && (leashState2 = entity.level()) instanceof ClientLevel) {
                int i;
                ObjectArrayList simulations;
                ClientLevel level = (ClientLevel)leashState2;
                Iterator<Map.Entry<ObjectPacked, List<VerletSimulation>>> it = this.storedSimulations.entrySet().iterator();
                while (it.hasNext()) {
                    simulations = it.next().getValue();
                    for (i = 0; i < simulations.size(); ++i) {
                        if (!simulations.get((int)i).destroyed) continue;
                        simulations.remove(i--);
                    }
                    if (simulations.size() != 0) continue;
                    it.remove();
                }
                this.tmp.e1 = entity;
                this.tmp.e2 = leashHolder;
                simulations = this.storedSimulations.get(this.tmp);
                for (i = 0; i < leashStates.size(); ++i) {
                    EntityRenderState.LeashState leashState3 = (EntityRenderState.LeashState)leashStates.get(i);
                    if (simulations == null) {
                        simulations = new ObjectArrayList();
                        this.storedSimulations.put(new ObjectPacked(entity, leashHolder), (List<VerletSimulation>)simulations);
                    }
                    VerletSimulation simulation = i < simulations.size() ? (VerletSimulation)simulations.get(i) : null;
                    int brightness = LightTexture.pack((int)leashState3.startBlockLight, (int)leashState3.startSkyLight);
                    if (simulation == null) {
                        simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(level.dimension().location())), 20, 0.855);
                        simulation.addConstraint(new WorldConstraint((Entity)entity, 0.25f));
                        simulation.addConstraint(new LeashConstraint(simulation, leashState3));
                        simulation.getConstraint(RenderConstraint.class).lineThickness = 0.035;
                        simulation.brightness = brightness;
                        simulation.textureID = PhysicsMod.whiteTexture;
                        simulation.alwaysFetchInstantly = false;
                        simulations.add(simulation);
                        PhysicsMod.getInstance((Level)level).physicsWorld.addVerletSimulation(simulation);
                    } else if (!simulation.destroyed) {
                        simulation.active = true;
                        simulation.brightness = brightness;
                        simulation.getConstraint(LeashConstraint.class).setLeashState(leashState3);
                    }
                    PhysicsMod.dynamicCloth.computeIfAbsent(PhysicsMod.getRenderPass(), key -> new ObjectArrayList()).add(simulation);
                }
            }
        }
    }

    @Redirect(method={"submit"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/SubmitNodeCollector;submitLeash(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/entity/state/EntityRenderState$LeashState;)V"))
    private void physicsmod$maybeSkipSubmitLeash(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, EntityRenderState.LeashState leashState) {
        if (ConfigClient.leashPhysics) {
            return;
        }
        submitNodeCollector.submitLeash(poseStack, leashState);
    }
}

