/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ocean.EntityRenderStateExtended;
import net.diebuddies.physics.ocean.OceanRenderState;
import net.diebuddies.physics.ocean.OceanWorld;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderDispatcher.class})
public class MixinEntityRenderDispatcher {
    @Inject(method={"submit"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", shift=At.Shift.AFTER, ordinal=0)})
    private <S extends EntityRenderState> void physicsmod$applyOceanOffset(S entityRenderState, CameraRenderState cameraRenderState, double x, double y, double z, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CallbackInfo info) {
        OceanRenderState oceanState;
        if (ConfigClient.areOceanPhysicsEnabled() && (oceanState = ((EntityRenderStateExtended)entityRenderState).physicsmod$getOceanRenderState()) != null) {
            oceanState.ox = (float)((double)oceanState.ox + x);
            oceanState.oy = (float)((double)oceanState.oy + y);
            oceanState.oz = (float)((double)oceanState.oz + z);
            oceanState.apply(poseStack);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"extractEntity"})
    private <T extends Entity, S extends EntityRenderState> void physicsmod$extractEntity(T entity, float renderPercent, CallbackInfoReturnable<EntityRenderState> info) {
        Level level;
        if (ConfigClient.areOceanPhysicsEnabled() && (level = entity.level()) instanceof ClientLevel) {
            ClientLevel level2 = (ClientLevel)level;
            EntityRenderState entityRenderState = (EntityRenderState)info.getReturnValue();
            if (entityRenderState == null) {
                return;
            }
            OceanRenderState state = new OceanRenderState();
            ((EntityRenderStateExtended)entityRenderState).physicsmod$setOceanRenderState(state);
            OceanWorld oceanWorld = PhysicsMod.getInstance((Level)level2).getPhysicsWorld().getOceanWorld();
            oceanWorld.extractEntityOffset(state, (Level)level2, entity, renderPercent);
        }
    }
}

