/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.sodium;

import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.diebuddies.compat.Iris;
import net.diebuddies.minecraft.ChunkSectionsToRenderExtension;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.render.MainRenderer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayerGroup;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={SodiumWorldRenderer.class})
public class MixinSodiumWorldRenderer
implements ChunkSectionsToRenderExtension {
    @Unique
    private MainRenderer physicsmod$renderer;
    @Unique
    private ClientLevel physicsmod$level;

    @Inject(at={@At(value="HEAD")}, method={"drawChunkLayer"}, remap=false)
    private void physicsmod$renderLiquids(ChunkSectionLayerGroup layerGroup, @Coerce Object matrices, double x, double y, double z, CallbackInfo info) {
        if (this.physicsmod$renderer == null) {
            return;
        }
        if (layerGroup == ChunkSectionLayerGroup.TRANSLUCENT) {
            this.physicsmod$renderer.renderLiquid(this.physicsmod$level, ChunkSectionLayer.TRANSLUCENT);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"drawChunkLayer"}, remap=false)
    private void physicsmod$renderSolids(ChunkSectionLayerGroup layerGroup, @Coerce Object matrices, double x, double y, double z, CallbackInfo info) {
        if (this.physicsmod$renderer == null) {
            return;
        }
        if (layerGroup == ChunkSectionLayerGroup.OPAQUE) {
            if (StarterClient.iris && Iris.isShadowPass()) {
                Iris.setShadowMatrices(this.physicsmod$renderer);
                Iris.setRenderingPipelineToEntities(this.physicsmod$renderer);
            }
            this.physicsmod$renderer.renderAll(this.physicsmod$level, ChunkSectionLayer.CUTOUT);
        }
    }

    @Override
    public void physicsmod$setRenderer(MainRenderer renderer, ClientLevel level) {
        this.physicsmod$renderer = renderer;
        this.physicsmod$level = level;
    }
}

