/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.ocean;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class ExplosionOceanSplashParticle
extends SingleQuadParticle {
    private float baseAlpha;
    private static BlockPos.MutableBlockPos tmp = new BlockPos.MutableBlockPos();

    public ExplosionOceanSplashParticle(ClientLevel clientLevel, double x, double y, double z, double vx, double vy, double vz, TextureAtlasSprite sprite) {
        super(clientLevel, x, y, z, 0.0, 0.0, 0.0, sprite);
        float size = Math.random() * 0.9f + 0.3f;
        this.setSize(size, size);
        this.setLifetime(Math.randomInt(17) + 25);
        this.quadSize = size;
        this.gravity = 0.981f;
        this.oRoll = this.roll = Math.random() * (float)java.lang.Math.PI * 2.0f;
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        float modifier = ConfigClient.oceanParticleAlpha * 0.5f;
        this.baseAlpha = Math.random() * modifier + modifier;
        this.setPos(x + this.xd, y + this.yd, z + this.zd);
    }

    public void tick() {
        super.tick();
        if (!this.level.getBlockState((BlockPos)tmp.set(this.x, this.y, this.z)).isAir()) {
            this.remove();
        }
    }

    public void extract(QuadParticleRenderState quadParticleRenderState, Camera camera, float renderPercent) {
        this.setAlpha((1.0f - org.joml.Math.min((float)1.0f, (float)(((float)this.age + renderPercent) / (float)this.lifetime))) * this.baseAlpha);
        super.extract(quadParticleRenderState, camera, renderPercent);
    }

    public double getX(float renderPercent) {
        return Mth.lerp((double)renderPercent, (double)this.xo, (double)this.x);
    }

    public double getY(float renderPercent) {
        return Mth.lerp((double)renderPercent, (double)this.yo, (double)this.y);
    }

    public double getZ(float renderPercent) {
        return Mth.lerp((double)renderPercent, (double)this.zo, (double)this.z);
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double x, double y, double z, double vx, double vy, double vz, RandomSource random) {
            return new ExplosionOceanSplashParticle(clientLevel, x, y, z, vx, vy, vz, this.sprite.get((RandomSource)Math.fastRandomSource));
        }
    }
}

