/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.GlRenderPipeline;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.opengl.Uniform;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.List;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.mixins.ocean.MixinLightTextureAccessor;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.FBO;
import net.diebuddies.opengl.Pack;
import net.diebuddies.opengl.SaveTexture;
import net.diebuddies.opengl.Texture;
import net.diebuddies.opengl.Usage;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.shader.EmptyTextureShader;
import net.diebuddies.render.shader.GaussianDepthBlurEffect;
import net.diebuddies.render.shader.LiquidShader;
import net.diebuddies.render.shader.PhysicsShaderExtension;
import net.diebuddies.render.shader.PhysicsShaders;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;

public class LiquidDeferredRenderer {
    private MainRenderer mainRenderer;
    private static FBO depthFBO;
    private static LiquidShader liquidShader;
    private static EmptyTextureShader emptyTextureShader;
    private static VAO liquidVAO;
    private static VAO emptyVAO;
    private static Texture liquidDepthCopy;
    private static Texture depth;
    private static Texture light;
    private static GaussianDepthBlurEffect blurEffect;
    private static byte[] liquidlight;
    private static float[] liquidpos;
    private static float[] liquidposnew;
    private int liquidCount;
    private int depthActiveTexture;
    private int lightmapActiveTexture;
    private int lightcoordsActiveTexture;
    private Vector4f waterBounds = new Vector4f();
    private Vector2f waterMidCoord = new Vector2f();
    private GpuTextureView waterID;
    private boolean needsInstanceUpdate = false;
    private Vector3d offsetCamera = new Vector3d(0.0, 0.0, 0.0);
    private Matrix4f tmpMatrix = new Matrix4f();

    public LiquidDeferredRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(PhysicsWorld physics, ChunkSectionLayer sectionLayer, ClientLevel level, Matrix4fStack matrixStackIn, Vec3 cameraPos) {
    }

    private void renderInstancedLiquidSpheres(PhysicsWorld physics, ClientLevel level, Matrix4fStack modelView, Vec3 cameraPos) {
        DynamicUniforms.Transform transform = MainRenderer.createTransformUniform((Matrix4f)modelView);
        GpuBufferSlice[] gpuBuffer = RenderSystem.getDynamicUniforms().writeTransforms(new DynamicUniforms.Transform[]{transform});
        RenderPass renderPass = this.bindLiquidsShader();
        GlProgram program = ((GlRenderPass)renderPass).pipeline.program();
        Uniform.Ubo dynamicTransforms = (Uniform.Ubo)program.getUniform("DynamicTransforms");
        this.initRenderingStates(level, renderPass, true);
        this.setupLiquidsRendering(physics, level, renderPass, this.waterID, cameraPos);
        GlStateManager._enableCull();
        if (dynamicTransforms != null) {
            GpuBufferSlice slice = gpuBuffer[0];
            GL32C.glBindBufferRange((int)35345, (int)dynamicTransforms.blockBinding(), (int)((GlBuffer)slice.buffer()).handle, (long)slice.offset(), (long)slice.length());
        }
        if (StarterClient.iris) {
            Iris.setNormalMatrix(renderPass, (Matrix4fc)modelView);
        }
        Vector3d offset = physics.getOffset();
        this.offsetCamera.set(cameraPos.x - offset.x, cameraPos.y - offset.y, cameraPos.z - offset.z);
        PhysicsShaderExtension shaderExtension = (PhysicsShaderExtension)program;
        int cameraLocation = shaderExtension.physicsmod$getUniformLocation("physics_liquidCameraPos");
        int renderPercentLocation = shaderExtension.physicsmod$getUniformLocation("physics_renderPercent");
        if (cameraLocation != -1) {
            GL32C.glUniform3f((int)cameraLocation, (float)((float)this.offsetCamera.x), (float)((float)this.offsetCamera.y), (float)((float)this.offsetCamera.z));
        }
        if (renderPercentLocation != -1) {
            GL32C.glUniform1f((int)renderPercentLocation, (float)((float)physics.getRenderPercent()));
        }
        liquidVAO.renderInstanced(this.liquidCount);
        renderPass.close();
    }

    private void renderLiquidDataIntoTexture(PhysicsWorld physics, ChunkSectionLayer sectionLayer, ClientLevel level, Vec3 cameraPos) {
        RenderPass renderPass = this.mainRenderer.bindProperShader(() -> "Physics Mod Liquid Deferred Data", sectionLayer.pipeline());
        this.mainRenderer.setupShader(renderPass);
        RenderTarget renderTarget = Minecraft.getInstance().getMainRenderTarget();
        GpuTextureView renderTargetColor = renderTarget.getColorTextureView();
        Texture before = liquidDepthCopy;
        liquidDepthCopy = SaveTexture.copyFramebufferDepthTexture(liquidDepthCopy, renderTarget.getDepthTexture());
        if (depthFBO == null || before != liquidDepthCopy) {
            if (depthFBO != null) {
                depthFBO.destroy(false);
                blurEffect.destroy();
                depth.destroy();
                light.destroy();
            }
            blurEffect = new GaussianDepthBlurEffect();
            depthFBO = new FBO();
            depth = Texture.createTexture(renderTargetColor.getWidth(0), renderTargetColor.getHeight(0), 33326, 6403, 5126);
            light = Texture.createTexture(renderTargetColor.getWidth(0), renderTargetColor.getHeight(0), 33330, 36244, 5121);
            depthFBO.attachColorBuffer(depth);
            depthFBO.attachColorBuffer(light);
            depthFBO.attachDepthBuffer(liquidDepthCopy);
            depthFBO.checkError();
            blurEffect.setImage(depthFBO);
        }
        liquidShader.bind();
        depthFBO.bind();
        depthFBO.drawBuffers(0, 1);
        liquidVAO.bind();
        GL32C.glClearColor((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager._clear((int)16384);
        GlStateManager._disableBlend();
        Vector3d offset = physics.getOffset();
        this.offsetCamera.set(cameraPos.x - offset.x, cameraPos.y - offset.y, cameraPos.z - offset.z);
        LiquidShader shader = liquidShader;
        shader.bind();
        shader.uploadMatrix(shader.getUniformLocation("ModelViewMat"), RenderSystem.getModelViewMatrix());
        shader.uploadMatrix(shader.getUniformLocation("ProjMat"), this.mainRenderer.projectionMatrix);
        shader.setUniform3(shader.getUniformLocation("LiquidCameraPos"), (float)this.offsetCamera.x, (float)this.offsetCamera.y, (float)this.offsetCamera.z);
        double renderPercent = physics.getRenderPercent();
        shader.setUniform1(shader.getUniformLocation("RenderPercent"), (float)renderPercent);
        liquidVAO.renderInstanced(this.liquidCount);
        depthFBO.drawBuffers(0);
        blurEffect.render(this.mainRenderer.projectionMatrix, physics.fluidParticleSize * 6.0f, emptyVAO);
        renderPass.close();
        renderPass = this.bindLiquidsShader();
        this.initRenderingStates(level, renderPass, false);
        this.setupLiquidsRendering(physics, level, renderPass, this.waterID, cameraPos);
        emptyVAO.renderEmptyTriangle();
        renderPass.close();
    }

    private RenderPass bindLiquidsShader() {
        RenderPipeline renderPipeline = RenderPipelines.TRANSLUCENT;
        GlRenderPipeline customPipeline = null;
        if (StarterClient.iris && Iris.isExtending()) {
            if (Iris.isShadowPass()) {
                if (Iris.getLiquidShadowProgram() != null) {
                    customPipeline = new GlRenderPipeline(renderPipeline, Iris.getLiquidShadowProgram());
                } else {
                    renderPipeline = RenderPipelines.SOLID;
                }
            } else if (Iris.getLiquidProgram() != null) {
                customPipeline = new GlRenderPipeline(renderPipeline, Iris.getLiquidProgram());
            } else {
                renderPipeline = RenderPipelines.TRANSLUCENT;
            }
        } else if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            renderPipeline = PhysicsShaders.PHYSICS_LIQUID_PIPELINE;
        }
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.LEVEL);
        RenderPass renderPass = this.mainRenderer.bindProperShader(() -> "Physics Mod Liquid Deferred", renderPipeline, customPipeline);
        GlRenderPass glRenderPass = (GlRenderPass)renderPass;
        glRenderPass.encoder.trySetup(glRenderPass, Collections.emptyList());
        return renderPass;
    }

    private void initRenderingStates(ClientLevel level, RenderPass renderPass, boolean shadowPass) {
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib3f((int)Data.NORMAL.getAttribute(), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL32C.glVertexAttrib3f((int)Data.NORMAL_SHADER.getAttribute(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        int color = BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)Minecraft.getInstance().player.blockPosition());
        GL32C.glVertexAttrib4f((int)Data.COLOR_SHADER.getAttribute(), (float)Pack.getRed(color), (float)Pack.getGreen(color), (float)Pack.getBlue(color), (float)1.0f);
        GL32C.glVertexAttribI2i((int)Data.LIGHT_SHADER.getAttribute(), (int)240, (int)240);
        GL32C.glVertexAttrib2f((int)Data.TEX_COORD_SHADER.getAttribute(), (float)this.waterMidCoord.x, (float)this.waterMidCoord.y);
        if (StarterClient.iris && Iris.isExtending()) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_TERRAIN_SHADER.getAttribute(), (float)this.waterMidCoord.x, (float)this.waterMidCoord.y);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_TERRAIN_SHADER.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            mcEntityLocation = 5;
            GL32C.glVertexAttrib2s((int)mcEntityLocation, (short)Iris.getMaterialID(Blocks.WATER.defaultBlockState()), (short)1);
            int mcMidBlockLocation = 8;
            GL32C.glVertexAttrib4Nub((int)mcMidBlockLocation, (byte)32, (byte)32, (byte)32, (byte)-1);
        } else if (StarterClient.optifabric) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)this.waterMidCoord.x, (float)this.waterMidCoord.y);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            mcEntityLocation = Optifine.isUsingShadersNoInternal() ? 11 : -1;
            if (mcEntityLocation != -1) {
                GL32C.glVertexAttrib4f((int)mcEntityLocation, (float)Optifine.getMaterialID(Blocks.WATER.defaultBlockState()), (float)Optifine.getRenderType(Blocks.WATER.defaultBlockState()), (float)-1.0f, (float)-1.0f);
            }
        }
        if (!shadowPass) {
            GlStateManager._activeTexture((int)(33984 + this.depthActiveTexture));
            GlStateManager._bindTexture((int)depth.getID());
            GlStateManager._activeTexture((int)(33984 + this.lightcoordsActiveTexture));
            GlStateManager._bindTexture((int)light.getID());
        }
        int lightmapTextureID = ((GlTexture)((MixinLightTextureAccessor)Minecraft.getInstance().gameRenderer.lightTexture()).getTarget()).glId();
        GlStateManager._activeTexture((int)(33984 + this.lightmapActiveTexture));
        GlStateManager._bindTexture((int)lightmapTextureID);
        GlStateManager._activeTexture((int)33984);
        GlStateManager._disableCull();
    }

    private void setupLiquidsRendering(PhysicsWorld physics, ClientLevel level, RenderPass renderPass, GpuTextureView waterTexture, Vec3 cameraPos) {
        FloatBuffer matrixBuffer;
        MemoryStack stack;
        GlProgram program = ((GlRenderPass)renderPass).pipeline.program();
        Vector3d physicsOffset = physics.getOffset();
        PhysicsShaderExtension shaderExtension = (PhysicsShaderExtension)program;
        int depthLocation = shaderExtension.physicsmod$getUniformLocation("physics_depth");
        int lightmapLocation = shaderExtension.physicsmod$getUniformLocation("physics_lightmap");
        int lightcoordsLocation = shaderExtension.physicsmod$getUniformLocation("physics_lightcoords");
        int invProjLocation = shaderExtension.physicsmod$getUniformLocation("physics_invProjectionMatrix");
        int invViewLocation = shaderExtension.physicsmod$getUniformLocation("physics_invViewMatrix");
        int viewLocation = shaderExtension.physicsmod$getUniformLocation("physics_viewMatrix");
        int waterBoundsLocation = shaderExtension.physicsmod$getUniformLocation("physics_waterBounds");
        int cameraOffsetLocation = shaderExtension.physicsmod$getUniformLocation("physics_cameraOffset");
        if (depthLocation != -1) {
            GL32C.glUniform1i((int)depthLocation, (int)this.depthActiveTexture);
        }
        if (lightmapLocation != -1) {
            GL32C.glUniform1i((int)lightmapLocation, (int)this.lightmapActiveTexture);
        }
        if (lightcoordsLocation != -1) {
            GL32C.glUniform1i((int)lightcoordsLocation, (int)this.lightcoordsActiveTexture);
        }
        if (waterBoundsLocation != -1) {
            GL32C.glUniform4f((int)waterBoundsLocation, (float)this.waterBounds.x, (float)this.waterBounds.y, (float)this.waterBounds.z, (float)this.waterBounds.w);
        }
        if (cameraOffsetLocation != -1) {
            GL32C.glUniform3f((int)cameraOffsetLocation, (float)((float)(cameraPos.x - physicsOffset.x)), (float)((float)(cameraPos.y - physicsOffset.y)), (float)((float)(cameraPos.z - physicsOffset.z)));
        }
        if (invProjLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                this.mainRenderer.projectionMatrix.invert(this.tmpMatrix).get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)invProjLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        if (invViewLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                RenderSystem.getModelViewMatrix().invert(this.tmpMatrix).get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)invViewLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        if (viewLocation != -1) {
            stack = MemoryStack.stackPush();
            try {
                matrixBuffer = stack.mallocFloat(16);
                RenderSystem.getModelViewMatrix().get(matrixBuffer);
                GL32C.glUniformMatrix4fv((int)viewLocation, (boolean)false, (FloatBuffer)matrixBuffer);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
        }
        GlStateManager._activeTexture((int)33984);
        GlStateManager._bindTexture((int)((GlTexture)waterTexture.texture()).glId());
    }

    private VAO createLiquidVAO(Mesh mesh) {
        int size = mesh.indices.size();
        net.diebuddies.opengl.Mesh openglMesh = new net.diebuddies.opengl.Mesh();
        this.mainRenderer.checkArrays(size);
        for (int i = 0; i < size; ++i) {
            int index = mesh.indices.getInt(i);
            Vector3f p = mesh.positions.get(index);
            Vector3f normal = mesh.normals.get(index);
            int cp = i * 3;
            this.mainRenderer.mpos[cp] = p.x;
            this.mainRenderer.mpos[cp + 1] = p.y;
            this.mainRenderer.mpos[cp + 2] = p.z;
            this.mainRenderer.mnormals[i] = Pack.normal(normal.x, normal.y, normal.z);
        }
        openglMesh.set(this.mainRenderer.mpos, Data.POSITION);
        openglMesh.set(this.mainRenderer.mnormals, Data.NORMAL);
        openglMesh.set(liquidlight, Data.LIQUID_LIGHT);
        openglMesh.set(liquidpos, Data.LIQUID_POS);
        openglMesh.set(liquidposnew, Data.LIQUID_POS_NEW);
        openglMesh.setSize(Data.POSITION, size * 3);
        openglMesh.setSize(Data.NORMAL, size);
        openglMesh.setSize(Data.INDEX, size);
        return openglMesh.constructVAO(Usage.DYNAMIC);
    }

    private void checkLiquidArrays(int neededSize) {
        int size;
        boolean changed = false;
        for (size = liquidpos.length; neededSize > size; size *= 2) {
            changed = true;
        }
        if (changed) {
            liquidlight = new byte[size];
            liquidpos = new float[size];
            liquidposnew = new float[size];
        }
    }

    public void updateLiquidInstances(PhysicsWorld physics, Vec3 cameraPos) {
        Liquid liquid;
        int i;
        Vector3d offset = physics.getOffset();
        this.offsetCamera.set(cameraPos.x + offset.x, cameraPos.y + offset.y, cameraPos.z + offset.z);
        List<Liquid> liquids = physics.getLiquids();
        int size = 0;
        for (i = 0; i < liquids.size(); ++i) {
            liquid = liquids.get(i);
            size += liquid.particleCount();
        }
        this.checkLiquidArrays(size * 4);
        this.liquidCount = 0;
        for (i = 0; i < liquids.size(); ++i) {
            liquid = liquids.get(i);
            liquid.fillInstances(physics, liquidpos, liquidposnew, liquidlight, this.liquidCount);
            this.liquidCount += liquid.particleCount();
        }
        if (this.liquidCount == 0) {
            return;
        }
        liquidVAO.bind();
        liquidVAO.updateAttribute(Data.LIQUID_LIGHT, liquidlight, this.liquidCount * 4);
        liquidVAO.updateAttribute(Data.LIQUID_POS, liquidpos, this.liquidCount * 4);
        liquidVAO.updateAttribute(Data.LIQUID_POS_NEW, liquidposnew, this.liquidCount * 4);
    }

    public static void destroy() {
        if (depthFBO != null) {
            depthFBO.destroy(true);
        }
        if (liquidShader != null) {
            liquidShader.destroy();
        }
        if (liquidVAO != null) {
            liquidVAO.destroy();
        }
        if (liquidDepthCopy != null) {
            liquidDepthCopy.destroy();
        }
        if (emptyVAO != null) {
            emptyVAO.destroy();
        }
        if (emptyTextureShader != null) {
            emptyTextureShader.destroy();
        }
        if (blurEffect != null) {
            blurEffect.destroy();
        }
    }

    private /* synthetic */ void lambda$render$0() {
        this.needsInstanceUpdate = true;
    }

    static {
        liquidlight = new byte[400];
        liquidpos = new float[400];
        liquidposnew = new float[400];
    }
}

