/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft;

import net.diebuddies.math.Math;
import net.diebuddies.opengl.Pack;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import physx.common.PxVec3;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidDynamic;

public class ParticleSpawner {
    public static void spawnEatingPhysicsParticle(class_1799 itemStack, class_1937 level, double x, double y, double z, double vx, double vy, double vz) {
        class_10444 scratchRenderState = new class_10444();
        class_310.method_1551().method_65386().method_65598(scratchRenderState, itemStack, class_811.field_4318, level, null, 0);
        class_1058 sprite = scratchRenderState.method_65603(class_5819.method_43047());
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z).scale((double)(Math.random() * 0.06f + 0.04f));
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_71659();
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        entity.physicsGroup = (byte)16;
        entity.physicsMask = (byte)19;
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt0$temp = body.getRigidBody();
            if (patt0$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt0$temp;
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)vx, (float)vy * 1.3f + 1.0f, (float)vz);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
        float uo = Math.random() * 3.0f;
        float vo = Math.random() * 3.0f;
        Vector4f customUVs = new Vector4f(sprite.method_4580(uo / 4.0f), sprite.method_4580(uo / 4.0f), sprite.method_4570(vo / 4.0f), sprite.method_4570(vo / 4.0f));
        float xScale = customUVs.y - customUVs.x;
        float yScale = customUVs.w - customUVs.z;
        model.textureMatrix = new Matrix4f().translate(customUVs.x, customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }

    public static void spawnSprintingPhysicsParticle(class_2680 state, class_2338 pos, class_1937 level, double x, double y, double z) {
        class_1058 sprite = class_310.method_1551().method_1541().method_3351().method_3339(state);
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z).scale((double)(Math.random() * 0.06f + 0.11f));
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_71659();
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        entity.physicsGroup = (byte)16;
        entity.physicsMask = (byte)19;
        int color = class_310.method_1551().method_1505().method_1697(state, (class_1920)level, pos, 0);
        if (color == -1) {
            color = -1;
        }
        entity.setColor(color);
        if (state.method_26204() == class_2246.field_10593 || state.method_26204() == class_2246.field_10219) {
            entity.setColor(-1);
        }
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt0$temp = body.getRigidBody();
            if (patt0$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt0$temp;
                float strength = 3.0f;
                Vector3f speed = new Vector3f(0.0f, 0.3f, 0.0f);
                speed.x += (Math.random() - 0.5f) * 0.4f;
                speed.y += Math.random() * 0.4f;
                speed.z += (Math.random() - 0.5f) * 0.4f;
                speed.normalize();
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
        float uo = Math.random() * 3.0f;
        float vo = Math.random() * 3.0f;
        Vector4f customUVs = new Vector4f(sprite.method_4580(uo / 4.0f), sprite.method_4580((uo + 1.0f) / 4.0f), sprite.method_4570(vo / 4.0f), sprite.method_4570((vo + 1.0f) / 4.0f));
        float xScale = customUVs.y - customUVs.x;
        float yScale = customUVs.w - customUVs.z;
        model.textureMatrix = new Matrix4f().translate(customUVs.x, customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }

    public static void spawnBloodPhysicsParticle(class_1937 level, double x, double y, double z) {
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z).scale((double)(Math.random() * 0.03f + 0.08f));
        Model model = entity.models.get(0);
        model.textureID = PhysicsMod.whiteTexture;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        float bloodModifier = Math.random() * 0.2f + 0.8f;
        entity.setColor(Pack.color(0.1f * bloodModifier, 0.1f * bloodModifier, 0.77f * bloodModifier));
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt0$temp = body.getRigidBody();
            if (patt0$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt0$temp;
                Vector3f speed = new Vector3f();
                speed.x = Math.random() - 0.5f;
                speed.y = Math.random() - 0.5f;
                speed.z = Math.random() - 0.5f;
                float strength = Math.random() * 2.0f + 1.0f;
                if (speed.lengthSquared() > 0.0f) {
                    speed.normalize();
                }
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
    }

    public static void spawnOceanPhysicsParticle(class_1937 level, double x, double y, double z, double vx, double vz) {
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z).scale((double)(Math.random() * 0.05f + 0.11f));
        Model model = entity.models.get(0);
        model.textureID = PhysicsMod.whiteTexture;
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        entity.physicsGroup = (byte)16;
        entity.physicsMask = (byte)19;
        entity.setColor(-1);
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt0$temp = body.getRigidBody();
            if (patt0$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt0$temp;
                Vector3f speed = new Vector3f((float)vx, 0.0f, (float)vz);
                speed.x *= Math.random();
                speed.y = 0.0f;
                speed.z += Math.random();
                float strength = Math.random() * 2.0f + 1.0f;
                if (speed.lengthSquared() > 0.0f) {
                    speed.normalize();
                }
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
    }

    public static void spawnServerBlockPhysicsParticle(class_2680 state, class_1937 level, double x, double y, double z, double vx, double vy, double vz) {
        class_1058 sprite = class_310.method_1551().method_1541().method_3351().method_3339(state);
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().translation(x, y, z).scale((double)(Math.random() * 0.06f + 0.11f));
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_71659();
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        entity.physicsGroup = (byte)16;
        entity.physicsMask = (byte)19;
        int color = class_310.method_1551().method_1505().method_1697(state, (class_1920)level, class_2338.method_49637((double)x, (double)y, (double)z), 0);
        if (color == -1) {
            color = -1;
        }
        entity.setColor(color);
        if (state.method_26204() == class_2246.field_10593 || state.method_26204() == class_2246.field_10219) {
            entity.setColor(-1);
        }
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt0$temp = body.getRigidBody();
            if (patt0$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt0$temp;
                float strength = 2.0f;
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)vx * strength, (float)vy * strength, (float)vz * strength);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
        float uo = Math.random() * 3.0f;
        float vo = Math.random() * 3.0f;
        Vector4f customUVs = new Vector4f(sprite.method_4580(uo / 4.0f), sprite.method_4580((uo + 1.0f) / 4.0f), sprite.method_4570(vo / 4.0f), sprite.method_4570((vo + 1.0f) / 4.0f));
        float xScale = customUVs.y - customUVs.x;
        float yScale = customUVs.w - customUVs.z;
        model.textureMatrix = new Matrix4f().translate(customUVs.x, customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }

    public static void spawnItemPhysicsParticle(class_1058 sprite, class_1937 level, double x, double y, double z, float size, float depthScale, float uvx, float uvy, Matrix4f transformation) {
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
        entity.getTransformation().set((Matrix4fc)transformation).translate(x, y, z).scale((double)size, (double)size, (double)(depthScale * size));
        Model model = entity.models.get(0);
        model.texture = sprite;
        model.textureID = class_310.method_1551().method_1531().method_4619(sprite.method_45852()).method_71659();
        entity.backfaceCulling = true;
        model.mesh = PhysicsMod.brokenBlock.get(0);
        entity.physicsGroup = (byte)16;
        entity.physicsMask = (byte)19;
        IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
        mod.physicsWorld.queue(() -> {
            PxRigidActor patt0$temp = body.getRigidBody();
            if (patt0$temp instanceof PxRigidDynamic) {
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt0$temp;
                float strength = 2.0f;
                try (MemoryStack mem = MemoryStack.stackPush();){
                    PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, (Math.random() - 0.5f) * strength, (Math.random() - 0.5f) * strength * 1.6f, (Math.random() - 0.5f) * strength);
                    rigidBody.setLinearVelocity(velocity);
                    PxVec3 avelocity = PxVec3.createAt(mem, MemoryStack::nmalloc, Math.random() * 4.0f, Math.random() * 4.0f, Math.random() * 4.0f);
                    rigidBody.setAngularVelocity(avelocity);
                }
            }
        });
        Vector4f customUVs = new Vector4f(sprite.method_4580(uvx), sprite.method_4580(uvx), sprite.method_4570(uvy), sprite.method_4570(uvy));
        float xScale = customUVs.y - customUVs.x;
        float yScale = customUVs.w - customUVs.z;
        model.textureMatrix = new Matrix4f().translate(customUVs.x, customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
    }
}

