/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft.weather;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherParticle;
import net.minecraft.class_1058;
import net.minecraft.class_11944;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.joml.Quaternionf;
import org.joml.Vector3d;

public class RainParticle
extends WeatherParticle {
    private Quaternionf movementRotation = new Quaternionf();

    public RainParticle(class_638 clientLevel, double x, double y, double z, double vx, double vy, double vz, class_1058 sprite) {
        super(clientLevel, x, y, z, vx, vy, vz, sprite);
        this.field_17867 = 0.23f;
        this.setColor(255, 255, 255, (int)((float)(175 + (int)((double)Math.random() * 40.0)) * ConfigClient.particleRainOpacity));
        double lengthSquared = Vector3d.lengthSquared((double)vx, (double)vy, (double)vz);
        if (lengthSquared != 0.0) {
            double invLength = 1.0 / org.joml.Math.sqrt((double)lengthSquared);
            vx *= invLength;
            vy *= invLength;
            vz *= invLength;
        } else {
            vy = -1.0;
        }
        this.dampingX = 1.0;
        this.dampingY = 1.0;
        this.dampingZ = 1.0;
        this.field_3844 = 0.0f;
        this.rotationTo(this.movementRotation, (float)vx, (float)vy, (float)vz).rotateX((float)((double)Math.random() * 10.0));
    }

    public Quaternionf rotationTo(Quaternionf src, float tx, float ty, float tz) {
        float dot = -tx;
        if (dot < -0.999999f) {
            src.x = 0.0f;
            src.y = 1.0f;
            src.z = 0.0f;
            src.w = 0.0f;
        } else {
            float sd2 = org.joml.Math.sqrt((float)((1.0f + dot) * 2.0f));
            float isd2 = 1.0f / sd2;
            float cx = 0.0f;
            float cy = tz;
            float cz = -ty;
            float x = cx * isd2;
            float y = cy * isd2;
            float z = cz * isd2;
            float w = sd2 * 0.5f;
            float n2 = org.joml.Math.invsqrt((float)org.joml.Math.fma((float)x, (float)x, (float)org.joml.Math.fma((float)y, (float)y, (float)org.joml.Math.fma((float)z, (float)z, (float)(w * w)))));
            src.x = x * n2;
            src.y = y * n2;
            src.z = z * n2;
            src.w = w * n2;
        }
        return src;
    }

    public void method_3074(class_11944 quadParticleRenderState, class_4184 camera, float renderPercent) {
        class_243 cameraPos = camera.method_71156();
        double px = org.joml.Math.lerp((double)this.field_3858, (double)this.field_3874, (double)renderPercent);
        double py = org.joml.Math.lerp((double)this.field_3838, (double)this.field_3854, (double)renderPercent);
        double pz = org.joml.Math.lerp((double)this.field_3856, (double)this.field_3871, (double)renderPercent);
        float currentX = (float)(px - cameraPos.method_10216());
        float currentY = (float)(py - cameraPos.method_10214());
        float currentZ = (float)(pz - cameraPos.method_10215());
        int light = this.method_3068(renderPercent);
        quadParticleRenderState.method_74323(this.method_74255(), currentX, currentY, currentZ, this.movementRotation.x, this.movementRotation.y, this.movementRotation.z, this.movementRotation.w, this.field_17867, this.method_18133(), this.method_18134(), this.method_18135(), this.method_18136(), this.argb, light);
    }

    @Override
    public class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    public static class Provider
    implements class_707<class_2400> {
        private final class_4002 sprite;

        public Provider(class_4002 spriteSet) {
            this.sprite = spriteSet;
        }

        public class_703 createParticle(class_2400 simpleParticleType, class_638 clientLevel, double x, double y, double z, double vx, double vy, double vz, class_5819 random) {
            return new RainParticle(clientLevel, x, y, z, vx, vy, vz, this.sprite.method_18139((class_5819)Math.fastRandomSource));
        }
    }
}

