/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft.weather;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.wind.WeatherDomain;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class WindSoundInstance
extends class_1101 {
    private class_638 clientLevel;
    private float volumeTarget;
    private float pitchTarget;
    private float tmpVolume;

    public WindSoundInstance(class_638 clientLevel, class_3414 soundEvent, class_3419 soundSource) {
        super(soundEvent, soundSource, class_1113.method_43221());
        this.clientLevel = clientLevel;
        this.field_5446 = true;
        this.field_5451 = 0;
        this.field_18936 = true;
        this.field_5442 = 0.0f;
        this.volumeTarget = 0.0f;
        this.field_5441 = 1.0f;
        this.pitchTarget = 1.0f;
    }

    public void method_16896() {
        if (!RenderSystem.isOnRenderThread()) {
            return;
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_2338 camPos = camera.method_19328();
        int camX = class_3532.method_15357((double)camera.method_71156().field_1352);
        int camY = class_3532.method_15357((double)camera.method_71156().field_1351);
        int camZ = class_3532.method_15357((double)camera.method_71156().field_1350);
        double distance = this.clientLevel.method_8624(class_2902.class_2903.field_13197, camPos.method_10263(), camPos.method_10260()) - camPos.method_10264();
        if (distance > 0.0) {
            distance *= distance;
            int checkRange = 6;
            for (int zo = camZ - checkRange; zo <= camZ + checkRange; ++zo) {
                for (int xo = camX - checkRange; xo <= camX + checkRange; ++xo) {
                    int diffX = xo - camX;
                    int diffZ = zo - camZ;
                    if (diffX * diffX + diffZ * diffZ > 36) continue;
                    int rainToThisHeight = this.clientLevel.method_8624(class_2902.class_2903.field_13197, xo, zo);
                    double dsquared = 0.0;
                    dsquared = rainToThisHeight <= camPos.method_10264() ? Vector2d.distanceSquared((double)camPos.method_10263(), (double)camPos.method_10260(), (double)xo, (double)zo) : Vector3d.distanceSquared((double)camPos.method_10263(), (double)camPos.method_10264(), (double)camPos.method_10260(), (double)xo, (double)rainToThisHeight, (double)zo);
                    if (!(dsquared < distance)) continue;
                    distance = dsquared;
                }
            }
            distance = java.lang.Math.sqrt(distance);
        } else {
            distance = 0.0;
        }
        WeatherDomain weatherDomain = PhysicsMod.getInstance((class_1937)this.clientLevel).getPhysicsWorld().getWeatherDomain();
        Vector3f windDirection = weatherDomain.getWindDirection(camX, camY, camZ);
        float distanceBasedVolume = 1.0f - Math.clamp((float)distance / 6.0f, 0.0f, 1.0f);
        float strengthBasedVolume = Math.clamp(weatherDomain.getWindStrengthFast() / 0.9f, 0.0f, 1.0f);
        this.pitchTarget = strengthBasedVolume > 0.3f ? 1.0f + java.lang.Math.max(0.0f, windDirection.length() - 0.4f) : 1.0f;
        if (strengthBasedVolume < 0.12f) {
            strengthBasedVolume = Math.remapClamp(java.lang.Math.max(0.0f, windDirection.length() - 0.3f), 0.0f, 0.3f, 0.0f, 0.08f);
        }
        this.volumeTarget = distanceBasedVolume * strengthBasedVolume;
        this.tmpVolume = org.joml.Math.lerp((float)this.tmpVolume, (float)this.volumeTarget, (float)0.05f);
        this.field_5442 = this.tmpVolume * ConfigClient.windVolume;
        this.field_5441 = org.joml.Math.lerp((float)this.field_5441, (float)this.pitchTarget, (float)0.075f);
    }

    public boolean method_4785() {
        return true;
    }

    public void stopWind() {
        this.method_24876();
    }
}

