/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.textures.GpuTextureView;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.PlayerRenderStateExtended;
import net.diebuddies.physics.settings.cloth.ClothConstants;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.ClothRenderState;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.physics.verlet.constraints.OceanPhysicsDisplacementConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.diebuddies.util.EntityLevelPacked;
import net.diebuddies.util.PlayerLevelPacked;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_10192;
import net.minecraft.class_11890;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_8685;
import net.minecraft.class_922;
import net.minecraft.class_9334;
import org.joml.Matrix4d;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1007.class})
public abstract class MixinPlayerRenderer
extends class_922<class_11890, class_10055, class_591> {
    @Unique
    private Map<PlayerLevelPacked, VerletSimulation> physicsmod$elytraSimulations = new Object2ObjectOpenHashMap();
    @Unique
    private PlayerLevelPacked physicsmod$elytraTmp = new PlayerLevelPacked(null, null);
    @Unique
    private Map<EntityLevelPacked, VerletSimulation> physicsmod$clothSimulations = new Object2ObjectOpenHashMap();
    @Unique
    private EntityLevelPacked physicsmod$clothTmp = new EntityLevelPacked();
    @Unique
    private Map<PlayerLevelPacked, VerletSimulation> physicsmod$capeSimulations = new Object2ObjectOpenHashMap();
    @Unique
    private PlayerLevelPacked physicsmod$capeTmp = new PlayerLevelPacked(null, null);

    public MixinPlayerRenderer(class_5617.class_5618 context, class_591 entityModel, float f) {
        super(context, (class_583)entityModel, f);
    }

    @Inject(at={@At(value="TAIL")}, method={"method_62604(Lnet/minecraft/class_11890;Lnet/minecraft/class_10055;F)V"}, cancellable=true)
    private void physicsmod$extendRenderState(class_11890 entity, class_10055 entityRenderState, float tickDelta, CallbackInfo info) {
        this.physicsmod$extraxtClothRenderState(entity, entityRenderState, tickDelta);
    }

    @Unique
    private void physicsmod$extraxtClothRenderState(class_11890 entity, class_10055 entityRenderState, float tickDelta) {
        ClothRenderState state = new ClothRenderState();
        ((PlayerRenderStateExtended)entityRenderState).physicsmod$setClothRenderState(state);
        boolean canVersionRenderCloth = class_310.method_1551().field_1724 != entity;
        this.physicsmod$removeOldSimulations();
        if (PhysicsMod.clothSkipRenderQueue || !canVersionRenderCloth || entityRenderState.field_53333) {
            return;
        }
        if (ConfigClient.capePhysics) {
            if (!ConfigClient.clothForceArmor) {
                state.skipChestEquipment = this.physicsmod$checkSkipArmourRender(entity, entityRenderState.field_53418, class_1304.field_6174);
                state.skipLegsEquipment = this.physicsmod$checkSkipArmourRender(entity, entityRenderState.field_53419, class_1304.field_6172);
                state.skipFeetEquipment = this.physicsmod$checkSkipArmourRender(entity, entityRenderState.field_53420, class_1304.field_6166);
                state.skipHeadEquipment = this.physicsmod$checkSkipArmourRender(entity, entityRenderState.field_55309, class_1304.field_6169);
            }
            state.hiddenModelParts = ClothConstants.getHiddenParts((class_1297)entity);
            class_1799 itemStack = entityRenderState.field_53418;
            if (itemStack != null && itemStack.method_31574(class_1802.field_8833)) {
                boolean renderElytra;
                boolean bl = renderElytra = entity != null && !entity.method_5767() && !ConfigClient.clothForceArmor;
                if (renderElytra && ConfigCloth.hasCategory((class_1297)entity, "Elytra")) {
                    this.physicsmod$renderPhysicsElytra(entity, entityRenderState, tickDelta);
                    state.skipElytra = true;
                }
            } else if (entityRenderState.field_53532) {
                class_8685 playerSkin = entityRenderState.field_53520;
                if (this.physicsmod$hasPhysicsCape(entity)) {
                    state.skipCape = true;
                } else if (playerSkin.comp_1627() != null) {
                    // empty if block
                }
            }
            this.physicsmod$renderPhysicsCloth(entity, entityRenderState, tickDelta);
        }
    }

    @Unique
    private boolean physicsmod$hasPhysicsCape(class_11890 player) {
        return ConfigCloth.hasCategory((class_1297)player, "Back");
    }

    @Unique
    private void physicsmod$removeOldSimulations() {
        this.physicsmod$removeOldSimulation(this.physicsmod$elytraSimulations);
        this.physicsmod$removeOldSimulation(this.physicsmod$clothSimulations);
        this.physicsmod$removeOldSimulation(this.physicsmod$capeSimulations);
    }

    @Unique
    private <K> void physicsmod$removeOldSimulation(Map<K, VerletSimulation> simulations) {
        Iterator<Map.Entry<K, VerletSimulation>> it = simulations.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getValue().destroyed) continue;
            it.remove();
        }
    }

    @Unique
    private boolean physicsmod$checkSkipArmourRender(class_11890 entity, class_1799 itemStack, class_1304 equipmentSlot) {
        class_10192 equippable = (class_10192)itemStack.method_58694(class_9334.field_54196);
        if (equippable == null || equippable.comp_3174() != equipmentSlot) {
            return false;
        }
        Map<String, ConfigCloth.ClothList> customizationParts = ConfigCloth.getCustomizationParts((class_1297)entity);
        if (customizationParts == null || entity.method_5767()) {
            return false;
        }
        for (Map.Entry<String, ConfigCloth.ClothList> customizationPart : customizationParts.entrySet()) {
            ConfigCloth.ClothList clothList = customizationPart.getValue();
            for (String clothPiece : clothList.getClothPieces()) {
                Cloth cloth = PhysicsMod.cloth.get(clothPiece);
                if (cloth == null || !cloth.rules.getHiddenArmorPieces().contains(equipmentSlot.method_5923())) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private void physicsmod$renderPhysicsElytra(class_11890 player, class_10055 rs, float dt) {
        class_1937 level = player.method_73183();
        if (!(level instanceof class_638)) {
            return;
        }
        this.physicsmod$elytraTmp.e1 = player;
        this.physicsmod$elytraTmp.e2 = level;
        VerletSimulation sim = this.physicsmod$elytraSimulations.get(this.physicsmod$elytraTmp);
        Cloth cloth = ConfigCloth.getCategory((class_1297)player, "Elytra");
        int light = class_310.method_1551().method_1561().method_23839((class_1297)player, dt);
        class_583 model = ((class_922)class_310.method_1551().method_1561().method_3953((class_1297)player)).method_4038();
        if (this.physicsmod$shouldRenderFast((class_1309)player) || !cloth.rules.isDynamic()) {
            class_630 mp = ModelPartConstraint.getPart((class_3879)model, "body");
            if (mp != null) {
                PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, (class_1309)player, mp, light));
            }
            return;
        }
        if (sim == null) {
            if (!ModelPartConstraint.exists((class_3879)model, "body")) {
                return;
            }
            sim = this.physicsmod$buildSimulation(level, (class_1309)player, (class_10042)rs, (class_3879)model, "body", cloth, cloth.getTexture((class_1297)player), light);
            this.physicsmod$elytraSimulations.put(new PlayerLevelPacked(player, level), sim);
        } else {
            this.physicsmod$updateSimulation(sim, (class_1309)player, (class_10042)rs, (class_3879)model, light);
            if (cloth != sim.cloth) {
                sim.destroyed = true;
            }
        }
        PhysicsMod.dynamicCloth.computeIfAbsent(PhysicsMod.getRenderPass(), k -> new ObjectArrayList()).add(sim);
    }

    @Unique
    private void physicsmod$renderPhysicsCloth(class_11890 player, class_10055 renderState, float tickDelta) {
        Map<String, ConfigCloth.ClothList> parts = ConfigCloth.getCustomizationParts((class_1297)player);
        if (parts == null || player.method_5767()) {
            return;
        }
        class_1937 level = player.method_73183();
        if (!(level instanceof class_638)) {
            return;
        }
        int light = class_310.method_1551().method_1561().method_23839((class_1297)player, tickDelta);
        for (Map.Entry<String, ConfigCloth.ClothList> e : parts.entrySet()) {
            String modelPart = e.getKey();
            for (String clothId : e.getValue().getClothPieces()) {
                class_630 mp;
                Cloth cloth = PhysicsMod.cloth.get(clothId);
                if (cloth == null || ClothConstants.doesArmorHideCloth(cloth, (class_1309)player) || ClothConstants.isElytraHidingCloth(cloth, modelPart, (class_1309)player)) continue;
                if (this.physicsmod$shouldRenderFast((class_1309)player) || !cloth.rules.isDynamic()) {
                    class_630 mp2 = ModelPartConstraint.getPart((class_3879)this.method_4038(), modelPart);
                    if (mp2 == null) continue;
                    PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, (class_1309)player, mp2, light));
                    continue;
                }
                this.physicsmod$clothTmp.set((class_1297)player, modelPart, clothId, level);
                VerletSimulation sim = this.physicsmod$clothSimulations.get(this.physicsmod$clothTmp);
                if (sim == null) {
                    if (!ModelPartConstraint.exists((class_3879)this.method_4038(), modelPart)) continue;
                    sim = this.physicsmod$buildSimulation(level, (class_1309)player, (class_10042)renderState, (class_3879)this.method_4038(), modelPart, cloth, cloth.getTexture((class_1297)player), light);
                    this.physicsmod$clothSimulations.put(new EntityLevelPacked((class_1297)player, modelPart, clothId, level), sim);
                } else {
                    this.physicsmod$updateSimulation(sim, (class_1309)player, (class_10042)renderState, (class_3879)this.method_4038(), light);
                    if (cloth != sim.cloth) {
                        sim.destroyed = true;
                    }
                }
                PhysicsMod.dynamicCloth.computeIfAbsent(PhysicsMod.getRenderPass(), k -> new ObjectArrayList()).add(sim);
                if (cloth.playerMesh == null || (mp = ModelPartConstraint.getPart((class_3879)this.method_4038(), modelPart)) == null) continue;
                PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, (class_1309)player, mp, light).setOnlyRenderPlayer(true));
            }
        }
    }

    @Unique
    private void physicsmod$renderPhysicsCape(class_11890 player, class_10055 renderState, float tickDelta) {
        class_1937 level = player.method_73183();
        if (!(level instanceof class_638)) {
            return;
        }
        class_8685 skin = renderState.field_53520;
        this.physicsmod$capeTmp.e1 = player;
        this.physicsmod$capeTmp.e2 = level;
        VerletSimulation simulation = this.physicsmod$capeSimulations.get(this.physicsmod$capeTmp);
        Cloth cloth = PhysicsMod.defaultCape;
        int light = class_310.method_1551().method_1561().method_23839((class_1297)player, tickDelta);
        class_583 model = ((class_922)class_310.method_1551().method_1561().method_3953((class_1297)player)).method_4038();
        if (this.physicsmod$shouldRenderFast((class_1309)player) || !cloth.rules.isDynamic()) {
            class_630 mp = ModelPartConstraint.getPart((class_3879)model, "body");
            GpuTextureView tex = class_310.method_1551().method_1531().method_4619(skin.comp_1627().comp_3627()).method_71659();
            if (mp != null) {
                PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, tex, (class_1309)player, mp, light));
            }
            return;
        }
        if (simulation == null) {
            if (!ModelPartConstraint.exists((class_3879)model, "body")) {
                return;
            }
            class_2960 tex = skin.comp_1627().comp_3627();
            simulation = this.physicsmod$buildSimulation(level, (class_1309)player, (class_10042)renderState, (class_3879)model, "body", cloth, tex, light);
            this.physicsmod$capeSimulations.put(new PlayerLevelPacked(player, level), simulation);
        } else {
            this.physicsmod$updateSimulation(simulation, (class_1309)player, (class_10042)renderState, (class_3879)model, light);
            if (cloth != simulation.cloth) {
                simulation.destroyed = true;
            }
        }
        PhysicsMod.dynamicCloth.computeIfAbsent(PhysicsMod.getRenderPass(), key -> new ObjectArrayList()).add(simulation);
    }

    @Unique
    private boolean physicsmod$shouldRenderFast(class_1309 e) {
        class_4184 cam = class_310.method_1551().field_1773.method_19418();
        double r = ConfigClient.clothEntityRange;
        return cam.method_19328().method_10262((class_2382)e.method_24515()) > r * r;
    }

    @Unique
    private void physicsmod$updateSimulation(VerletSimulation sim, class_1309 entity, class_10042 rs, class_3879 model, int light) {
        if (sim.destroyed) {
            return;
        }
        sim.active = true;
        sim.brightness = light;
        sim.getConstraint(ModelPartConstraint.class).updateEntityTransformation(sim, entity, rs, model, 1.0f);
    }

    @Unique
    private VerletSimulation physicsmod$buildSimulation(class_1937 level, class_1309 entity, class_10042 rs, class_3879 model, String part, Cloth cloth, class_2960 tex, int light) {
        boolean instant;
        int quality = entity == class_310.method_1551().field_1724 ? 90 : 45;
        VerletSimulation sim = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(level.method_27983().method_29177())), quality, 0.855);
        ModelPartConstraint mpc = new ModelPartConstraint(sim, cloth.rules.getIgnoreParts(), entity, part, model);
        class_4587 ps = new class_4587();
        mpc.updateEntityTransformation(sim, entity, rs, model, 1.0f);
        ps.method_34425((Matrix4fc)mpc.getEntityTransformation());
        mpc.modelPartTransformation(ps.method_23760().method_23761());
        Matrix4d xf = new Matrix4d((Matrix4fc)ps.method_23760().method_23761());
        sim.getConstraints().clear();
        sim.addConstraint(new OceanPhysicsDisplacementConstraint((class_1297)entity));
        sim.addConstraint(mpc);
        sim.addConstraint(new WorldConstraint((class_1297)entity));
        sim.brightness = light;
        sim.addCloth(cloth, tex, xf, false);
        sim.setOffset(new Vector3d(entity.method_23317(), entity.method_23318(), entity.method_23321()).add((Vector3dc)sim.getOffset()), false);
        sim.setTransformation(xf);
        sim.setBufferTransformation(xf);
        sim.updateOffsets();
        PhysicsWorld world = PhysicsMod.getInstance((class_1937)level).physicsWorld;
        mpc.initAsyncData(world, sim);
        mpc.changeInstantly = true;
        mpc.updateAfter(0.0, sim);
        sim.downloadData();
        sim.alwaysFetchInstantly = instant = entity == class_310.method_1551().field_1724;
        if (instant) {
            world.addVerletSimulation(0, sim);
        } else {
            world.addVerletSimulation(sim);
        }
        return sim;
    }
}

