/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import java.util.Optional;
import net.diebuddies.compat.Iris;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.PhysicsExtendedPipeline;
import net.diebuddies.physics.ocean.ProgramSetOcean;
import net.irisshaders.iris.helpers.FakeChainedJsonException;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.pipeline.programs.ShaderSupplier;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shadows.ShadowRenderTargets;
import net.minecraft.class_5944;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IrisRenderingPipeline.class}, remap=false)
public class MixinNewWorldRenderingPipeline
implements PhysicsExtendedPipeline {
    @Unique
    private ProgramSet physicsmod$programSet;
    @Unique
    private class_5944 physicsmod$oceanShader;
    @Unique
    private class_5944 physicsmod$oceanShadowShader;
    @Unique
    private class_5944 physicsmod$liquidShader;
    @Unique
    private class_5944 physicsmod$liquidShadowShader;
    @Unique
    private class_5944 physicsmod$smokeShader;
    @Unique
    private class_5944 physicsmod$smokeShadowShader;
    @Unique
    private boolean physicsmod$renderOceanShadow;
    @Unique
    private boolean physicsmod$renderLiquidShadow;
    @Unique
    private boolean physicsmod$renderSmokeShadow;
    @Shadow
    private ShadowRenderTargets shadowRenderTargets;

    @Shadow
    public ShaderSupplier createShader(String name, Optional<ProgramSource> source, ShaderKey key) {
        return null;
    }

    @Shadow
    public ShaderSupplier createShadowShader(String name, Optional<ProgramSource> source, ShaderKey key) {
        return null;
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/irisshaders/iris/shaderpack/programs/ProgramSet;)V"})
    public void constructor(ProgramSet programSet, CallbackInfo info) {
        FakeChainedJsonException fake;
        this.physicsmod$programSet = programSet;
        try {
            this.physicsmod$oceanShader = (class_5944)this.createShader("physics_ocean", ((ProgramSetOcean)programSet).getOceanSource().requireValid(), ShaderKey.TERRAIN_TRANSLUCENT).shader().get();
            boolean bl = this.physicsmod$renderOceanShadow = this.shadowRenderTargets != null;
            if (this.physicsmod$renderOceanShadow) {
                this.physicsmod$oceanShadowShader = (class_5944)this.createShadowShader("physics_ocean_shadow", ((ProgramSetOcean)programSet).getOceanShadowSource().requireValid(), ShaderKey.SHADOW_TERRAIN_CUTOUT).shader().get();
            }
            StarterClient.logger.info("constructed ocean shader successfully");
        }
        catch (Exception e) {
            this.physicsmod$oceanShader = null;
            this.physicsmod$oceanShadowShader = null;
            StarterClient.logger.info("failed constructing ocean shader");
            Iris.oceanError = "This shader (or shaderpack settings) is not supported by ocean physics!";
            if (e instanceof FakeChainedJsonException) {
                fake = (FakeChainedJsonException)e;
                fake.getTrueException().printStackTrace();
            }
            e.printStackTrace();
        }
        try {
            this.physicsmod$liquidShader = (class_5944)this.createShader("physics_liquids", ((ProgramSetOcean)programSet).getLiquidsSource().requireValid(), ShaderKey.TERRAIN_TRANSLUCENT).shader().get();
            boolean bl = this.physicsmod$renderLiquidShadow = this.shadowRenderTargets != null;
            if (this.physicsmod$renderLiquidShadow) {
                Iris.compilingLiquidShadowShader.set(true);
                this.physicsmod$liquidShadowShader = (class_5944)this.createShadowShader("physics_liquids_shadow", ((ProgramSetOcean)programSet).getLiquidsShadowSource().requireValid(), ShaderKey.SHADOW_TERRAIN_CUTOUT).shader().get();
                Iris.compilingLiquidShadowShader.set(false);
            }
            StarterClient.logger.info("constructed liquids shader successfully");
        }
        catch (Exception e) {
            this.physicsmod$liquidShader = null;
            this.physicsmod$liquidShadowShader = null;
            Iris.compilingLiquidShadowShader.set(false);
            StarterClient.logger.info("failed constructing liquids shader");
            Iris.liquidsError = "This shader (or shaderpack settings) is not supported by liquid physics!";
            if (e instanceof FakeChainedJsonException) {
                fake = (FakeChainedJsonException)e;
                fake.getTrueException().printStackTrace();
            }
            e.printStackTrace();
        }
        try {
            Iris.compilingSmokeShader.set(true);
            this.physicsmod$smokeShader = (class_5944)this.createShader("physics_smoke", ((ProgramSetOcean)programSet).getSmokeSource().requireValid(), ShaderKey.ENTITIES_CUTOUT).shader().get();
            boolean bl = this.physicsmod$renderSmokeShadow = this.shadowRenderTargets != null;
            if (this.physicsmod$renderSmokeShadow) {
                this.physicsmod$smokeShadowShader = (class_5944)this.createShadowShader("physics_smoke_shadow", ((ProgramSetOcean)programSet).getSmokeShadowSource().requireValid(), ShaderKey.SHADOW_ENTITIES_CUTOUT).shader().get();
            }
            Iris.compilingSmokeShader.set(false);
            StarterClient.logger.info("constructed smoke shader successfully");
        }
        catch (Exception e) {
            this.physicsmod$smokeShader = null;
            this.physicsmod$smokeShadowShader = null;
            Iris.compilingSmokeShader.set(false);
            StarterClient.logger.info("failed constructing smoke shader");
            Iris.smokeError = "This shader (or shaderpack settings) is not supported by smoke physics!";
            if (e instanceof FakeChainedJsonException) {
                fake = (FakeChainedJsonException)e;
                fake.getTrueException().printStackTrace();
            }
            e.printStackTrace();
        }
    }

    @Override
    public class_5944 physicsmod$getOceanShader() {
        return this.physicsmod$oceanShader;
    }

    @Override
    public class_5944 physicsmod$getOceanShadowShader() {
        return this.physicsmod$oceanShadowShader;
    }

    @Override
    public class_5944 physicsmod$getLiquidShader() {
        return this.physicsmod$liquidShader;
    }

    @Override
    public class_5944 physicsmod$getLiquidShadowShader() {
        return this.physicsmod$liquidShadowShader;
    }

    @Override
    public class_5944 physicsmod$getSmokeShader() {
        return this.physicsmod$smokeShader;
    }

    @Override
    public class_5944 physicsmod$getSmokeShadowShader() {
        return this.physicsmod$smokeShadowShader;
    }

    @Override
    public boolean physicsmod$renderOceanShadow() {
        return this.physicsmod$renderOceanShadow;
    }

    @Override
    public boolean physicsmod$renderLiquidShadow() {
        return this.physicsmod$renderLiquidShadow;
    }

    @Override
    public boolean physicsmod$renderSmokeShadow() {
        return this.physicsmod$renderSmokeShadow;
    }
}

