/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.diebuddies.physics.StarterClient;
import org.joml.Vector3i;
import org.lwjgl.system.MemoryStack;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.geometry.PxBoxGeometry;
import physx.physics.PxFilterData;
import physx.physics.PxRigidActor;
import physx.physics.PxShape;
import physx.physics.PxShapeFlagEnum;
import physx.physics.PxShapeFlags;

public class ChunkRigidBody {
    private PxRigidActor chunk;
    private Set<Vector3i> fullBlocks;
    private List<PxShape> blocks = new ObjectArrayList();
    private PxShapeFlags shapeFlags;
    private PxFilterData filterData;
    private boolean destroyed;

    public ChunkRigidBody(double x, double y, double z) {
        this.shapeFlags = new PxShapeFlags((byte)(PxShapeFlagEnum.eSIMULATION_SHAPE.value | PxShapeFlagEnum.eSCENE_QUERY_SHAPE.value));
        this.filterData = new PxFilterData(1, 23, 0, 0);
        this.fullBlocks = new ObjectOpenHashSet();
        try (MemoryStack mem = MemoryStack.stackPush();){
            PxVec3 tmpVec = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)x, (float)y, (float)z);
            PxQuat tmpQuat = PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f);
            PxTransform tmpPose = PxTransform.createAt(mem, MemoryStack::nmalloc, tmpVec, tmpQuat);
            this.chunk = StarterClient.physics.createRigidStatic(tmpPose);
        }
    }

    public void attachFullBlock(int x, int y, int z) {
        this.fullBlocks.add(new Vector3i(x, y, z));
    }

    public void compileChunk() {
        int SIZE = 4;
        if (this.fullBlocks.isEmpty()) {
            return;
        }
        boolean[] voxels = new boolean[64];
        for (Vector3i v : this.fullBlocks) {
            if ((v.x | v.y | v.z) < 0 || v.x >= 4 || v.y >= 4 || v.z >= 4) continue;
            voxels[v.x + v.y * 4 + v.z * 4 * 4] = true;
        }
        boolean[] visited = new boolean[voxels.length];
        for (int z = 0; z < 4; ++z) {
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    int base = x + y * 4 + z * 4 * 4;
                    if (!voxels[base] || visited[base]) continue;
                    int maxX = x;
                    while (maxX + 1 < 4 && voxels[maxX + 1 + y * 4 + z * 4 * 4] && !visited[maxX + 1 + y * 4 + z * 4 * 4]) {
                        ++maxX;
                    }
                    int maxY = y;
                    block5: while (maxY + 1 < 4) {
                        for (int ix = x; ix <= maxX; ++ix) {
                            int idx = ix + (maxY + 1) * 4 + z * 4 * 4;
                            if (!voxels[idx] || visited[idx]) break block5;
                        }
                        ++maxY;
                    }
                    int maxZ = z;
                    block7: while (maxZ + 1 < 4) {
                        for (int iy = y; iy <= maxY; ++iy) {
                            for (int ix = x; ix <= maxX; ++ix) {
                                int idx = ix + iy * 4 + (maxZ + 1) * 4 * 4;
                                if (!voxels[idx] || visited[idx]) break block7;
                            }
                        }
                        ++maxZ;
                    }
                    for (int zz = z; zz <= maxZ; ++zz) {
                        for (int yy = y; yy <= maxY; ++yy) {
                            int row = yy * 4 + zz * 4 * 4;
                            for (int xx = x; xx <= maxX; ++xx) {
                                visited[xx + row] = true;
                            }
                        }
                    }
                    float w = maxX - x + 1;
                    float h = maxY - y + 1;
                    float d = maxZ - z + 1;
                    float cx = (float)x + w * 0.5f;
                    float cy = (float)y + h * 0.5f;
                    float cz = (float)z + d * 0.5f;
                    this.attachBox(cx, cy, cz, w, h, d);
                }
            }
        }
        this.fullBlocks.clear();
    }

    public void attachBox(float x, float y, float z, float width, float height, float depth) {
        try (MemoryStack mem = MemoryStack.stackPush();){
            PxBoxGeometry boxGeometry = PxBoxGeometry.createAt(mem, MemoryStack::nmalloc, width * 0.5f, height * 0.5f, depth * 0.5f);
            PxShape boxShape = StarterClient.physics.createShape(boxGeometry, StarterClient.defaultMaterial, true, this.shapeFlags);
            boxShape.setLocalPose(PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, x, y, z), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f)));
            boxShape.setSimulationFilterData(this.filterData);
            this.chunk.attachShape(boxShape);
            this.blocks.add(boxShape);
        }
    }

    public PxRigidActor getActor() {
        return this.chunk;
    }

    public List<PxShape> getBlocks() {
        return this.blocks;
    }

    public void destroy() {
        if (!this.destroyed) {
            for (PxShape shape : this.blocks) {
                shape.release();
            }
            this.chunk.release();
            this.shapeFlags.destroy();
            this.filterData.destroy();
            this.destroyed = true;
        }
    }
}

