/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsRenderable;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.lwjgl.system.MemoryStack;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxRigidBodyExt;
import physx.geometry.PxSphereGeometry;
import physx.physics.PxFilterData;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamic;
import physx.physics.PxRigidDynamicLockFlagEnum;
import physx.physics.PxShape;
import physx.physics.PxShapeFlagEnum;
import physx.physics.PxShapeFlags;

public class SmokeRigidBody
extends IRigidBody {
    public Vector3d pos = new Vector3d();
    public Vector3d vel = new Vector3d();
    public float density = 1.0f;
    public float averagedDensity = 1.0f;
    public boolean airDespawn;

    private SmokeRigidBody() {
    }

    @Override
    public void updateTransformations(PhysicsWorld physics, double diff) {
    }

    @Override
    public void updatePhysics(PhysicsWorld physics, double diff, boolean blocksChanged) {
        super.updatePhysics(physics, diff, blocksChanged);
        this.loadChunkPhysics((float)this.pos.x, (float)this.pos.y, (float)this.pos.z);
    }

    public static SmokeRigidBody createSmoke(PhysicsEntity entity, float radius) {
        SmokeRigidBody rigidBody = new SmokeRigidBody();
        Matrix4d transformation = entity.getTransformation();
        rigidBody.entity = new PhysicsRenderable(entity);
        try (MemoryStack mem = MemoryStack.stackPush();){
            PxShapeFlags shapeFlags = PxShapeFlags.createAt(mem, MemoryStack::nmalloc, (byte)(PxShapeFlagEnum.eSIMULATION_SHAPE.value | PxShapeFlagEnum.eSCENE_QUERY_SHAPE.value));
            PxVec3 tmpVec = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)transformation.m30(), (float)transformation.m31(), (float)transformation.m32());
            PxQuat tmpQuat = PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f);
            PxTransform tmpPose = PxTransform.createAt(mem, MemoryStack::nmalloc, tmpVec, tmpQuat);
            PxFilterData tmpFilterData = PxFilterData.createAt(mem, MemoryStack::nmalloc, 1, 1, 0, 0);
            PxSphereGeometry sphereGeometry = PxSphereGeometry.createAt(mem, MemoryStack::nmalloc, radius);
            PxShape boxShape = StarterClient.physics.createShape(sphereGeometry, StarterClient.smokeMaterial, true, shapeFlags);
            PxRigidDynamic sphere = null;
            PxRigidDynamic dynamicActor = sphere = StarterClient.physics.createRigidDynamic(tmpPose);
            dynamicActor.setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum.eLOCK_ANGULAR_X, true);
            dynamicActor.setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum.eLOCK_ANGULAR_Y, true);
            dynamicActor.setRigidDynamicLockFlag(PxRigidDynamicLockFlagEnum.eLOCK_ANGULAR_Z, true);
            dynamicActor.setSolverIterationCounts(1, 1);
            rigidBody.shape = boxShape;
            rigidBody.rigidBody = sphere;
            boxShape.setSimulationFilterData(tmpFilterData);
            sphere.attachShape(boxShape);
            PxRigidBodyExt.updateMassAndInertia(sphere, 0.001f);
            rigidBody.setMass(((PxRigidBody)sphere).getMass());
        }
        return rigidBody;
    }
}

