/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import javax.annotation.Nullable;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.verlet.ClothRules;
import net.minecraft.class_12137;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;

public class Cloth
implements Comparable<Cloth> {
    public final String name;
    public final ColladaMesh mesh;
    private final class_2960 texture;
    private final class_12137 sampler;
    public final ClothRules rules;
    public final VAO vao;
    public final VAO vaoFlatShaded;
    public final ColladaMesh playerMesh;
    public final VAO playerVAO;

    public Cloth(String name, ColladaMesh mesh, @Nullable ColladaMesh playerMesh, class_2960 texture, ClothRules rules) {
        this.name = name;
        this.mesh = mesh;
        this.texture = texture;
        this.sampler = RenderSystem.getSamplerCache().method_76521(FilterMode.NEAREST, false);
        this.rules = rules;
        this.vao = mesh.createVAO(false);
        this.vaoFlatShaded = mesh.createVAO(true);
        this.playerMesh = playerMesh;
        this.playerVAO = playerMesh != null ? playerMesh.createVAO(true) : null;
    }

    public class_2960 getTexture(@Nullable class_1297 entity) {
        String specialTexture = this.rules.getSpecialTexture();
        if (specialTexture != null) {
            if (specialTexture.equals("minecraft:playerskin")) {
                if (entity != null && entity instanceof class_742) {
                    class_742 player = (class_742)entity;
                    return player.method_52814().comp_1626().comp_3627();
                }
                return null;
            }
            return class_2960.method_60654((String)specialTexture);
        }
        return this.texture;
    }

    public GpuTextureView getTextureView(@Nullable class_1297 entity) {
        class_2960 identifier = this.getTexture(entity);
        if (identifier == null) {
            return null;
        }
        return class_310.method_1551().method_1531().method_4619(identifier).method_71659();
    }

    public class_12137 getSampler() {
        return this.sampler;
    }

    public void destroy() {
        if (this.vao != null) {
            this.vao.destroy();
        }
        if (this.vaoFlatShaded != null) {
            this.vaoFlatShaded.destroy();
        }
        if (this.playerVAO != null) {
            this.playerVAO.destroy();
        }
        if (this.texture != null) {
            class_310.method_1551().method_1531().method_4615(this.texture);
        }
    }

    @Override
    public int compareTo(Cloth o) {
        return this.name.compareTo(o.name);
    }
}

