/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.verlet.VerletLine;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_906;
import org.joml.Math;
import org.joml.Matrix4fStack;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class FishingHookConstraint
implements VerletConstraint {
    private Vector3d playerPosAsync = new Vector3d();
    private Vector3d hookPosAsync = new Vector3d();
    private Vector3d playerPos = new Vector3d();
    private Vector3d hookPos = new Vector3d();

    public FishingHookConstraint(VerletSimulation simulation, class_906 fishingHookRenderer, class_1536 fishingHook, class_1657 player, float tickDelta) {
        int i;
        this.calculatePlayerAndHookPos(fishingHookRenderer, fishingHook, player, tickDelta);
        int pointCount = 48;
        double totalLength = ConfigClient.fishingLineLength;
        for (i = 0; i < pointCount; ++i) {
            float perc = (float)(i - 1) / (float)pointCount;
            Vector3d position = new Vector3d(Math.lerp((double)this.playerPos.x, (double)this.hookPos.x, (double)perc), Math.lerp((double)this.playerPos.y, (double)this.hookPos.y, (double)perc), Math.lerp((double)this.playerPos.z, (double)this.hookPos.z, (double)perc));
            VerletPoint point = new VerletPoint(position);
            point.uv.set(0.01f, 0.99f);
            point.rgba.set(0.0f, 0.0f, 0.0f, 1.0f);
            point.locked = i == 0 || i == pointCount - 1;
            simulation.addPoint(point);
        }
        for (i = 0; i < pointCount - 1; ++i) {
            simulation.addStick(new VerletStick(simulation.getPoints().get(i), simulation.getPoints().get(i + 1), totalLength / (double)pointCount));
            simulation.addLine(new VerletLine(simulation.getPoints().get(i), simulation.getPoints().get(i + 1)));
        }
    }

    public void calculatePlayerAndHookPos(class_906 fishingHookRenderer, class_1536 fishingHook, class_1657 player, float tickDelta) {
        float attackAnim = player.method_6055(tickDelta);
        float attackAnim2 = class_3532.method_15374((double)(class_3532.method_15355((float)attackAnim) * (float)java.lang.Math.PI));
        class_243 handPos = fishingHookRenderer.method_59755(player, attackAnim2, tickDelta);
        double playerX = handPos.field_1352;
        double playerY = handPos.field_1351;
        double playerZ = handPos.field_1350;
        double hookX = class_3532.method_16436((double)tickDelta, (double)fishingHook.field_6014, (double)fishingHook.method_23317());
        double hookY = class_3532.method_16436((double)tickDelta, (double)fishingHook.field_6036, (double)fishingHook.method_23318()) + 0.25;
        double hookZ = class_3532.method_16436((double)tickDelta, (double)fishingHook.field_5969, (double)fishingHook.method_23321());
        this.playerPos.set(playerX, playerY, playerZ);
        this.hookPos.set(hookX, hookY, hookZ);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        this.playerPosAsync.set((Vector3dc)this.playerPos);
        this.hookPosAsync.set((Vector3dc)this.hookPos);
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.position.set((Vector3dc)this.playerPosAsync).sub((Vector3dc)simulation.getOffset());
        hookPoint.position.set((Vector3dc)this.hookPosAsync).sub((Vector3dc)simulation.getOffset());
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.bufferPosition.set((Vector3dc)this.playerPos).sub((Vector3dc)simulation.getOffset());
        armPoint.bufferPrevPosition.set((Vector3dc)armPoint.bufferPosition);
        hookPoint.bufferPosition.set((Vector3dc)this.hookPos).sub((Vector3dc)simulation.getOffset());
        hookPoint.bufferPrevPosition.set((Vector3dc)hookPoint.bufferPosition);
    }
}

