/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.MatrixUtil;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.settings.cloth.ClothConstants;
import net.diebuddies.physics.verlet.ModelPartParent;
import net.diebuddies.physics.verlet.VerletHelper;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelCube;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_5603;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_922;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelPartConstraint
implements VerletConstraint {
    private class_1309 entity;
    private class_3879 model;
    public boolean changeInstantly;
    private boolean lastCrouch;
    private VerletHelper helper = new VerletHelper();
    private List<ModelCube> modelCubes;
    private ModelCube attachedTo;
    private double initialFriction;
    private class_4587 modelMatrix = new class_4587();
    private class_4587 headMatrix = new class_4587();
    private Matrix4f entityTransformation = new Matrix4f();
    private CustomTransformation customTransformation;
    private boolean isHead;
    private Vector3d invPoint = new Vector3d();
    private Matrix4d transform = new Matrix4d();
    private Matrix4d invTransform = new Matrix4d();
    private Vector3d tmp = new Vector3d();
    private Matrix4d partTransformation = new Matrix4d();
    private Matrix4d oldPartTransformation;
    private Matrix4d currentPartTransformation = new Matrix4d();
    private Matrix4d tmpMat = new Matrix4d();
    private static Matrix4d elytraFix = new Matrix4d();
    private Quaternionf tmpQuat = new Quaternionf();

    public ModelPartConstraint(VerletSimulation simulation, Set<String> ignoreParts, @Nullable class_1309 entity, String attachedToName, class_3879 model) {
        this.entity = entity;
        this.model = model;
        this.lastCrouch = entity == null ? false : entity.method_18276();
        this.initialFriction = simulation.getFriction();
        this.modelCubes = new ObjectArrayList();
        for (class_630 part : ClothConstants.getModelParts(model)) {
            String name = ((ModelPartParent)part).physicsmod$getName();
            if (attachedToName.equals(name)) {
                this.attachedTo = new ModelCube();
                this.attachedTo.part = part;
                this.attachedTo.pose = part.method_32084();
            }
            if (ignoreParts.contains(name)) continue;
            ModelCube modelCube = new ModelCube();
            modelCube.part = part;
            this.modelCubes.add(modelCube);
        }
        this.isHead = entity == class_310.method_1551().field_1724;
    }

    private void storePoses() {
        for (int i = 0; i < this.modelCubes.size(); ++i) {
            ModelCube modelCube = this.modelCubes.get(i);
            modelCube.pose = modelCube.part.method_32084();
            modelCube.updateHitbox();
        }
        this.attachedTo.pose = this.attachedTo.part.method_32084();
        this.attachedTo.updateHitbox();
    }

    public static class_630 getPart(class_3879 model, String name) {
        for (class_630 part : ClothConstants.getModelParts(model)) {
            if (!name.equals(((ModelPartParent)part).physicsmod$getName())) continue;
            return part;
        }
        return null;
    }

    public static boolean exists(class_3879 model, String name) {
        for (class_630 part : ClothConstants.getModelParts(model)) {
            if (!name.equals(((ModelPartParent)part).physicsmod$getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        if (this.entity != null) {
            this.changeInstantly = this.lastCrouch != this.entity.method_18276();
            this.lastCrouch = this.entity.method_18276();
        }
        this.modelMatrix.method_22903();
        if (this.entity != null) {
            boolean before = PhysicsMod.clothSkipRenderQueue;
            PhysicsMod.clothSkipRenderQueue = true;
            this.updateEntityTransformation(simulation, this.entity, this.model, 1.0f);
            PhysicsMod.clothSkipRenderQueue = before;
            this.modelMatrix.method_34425((Matrix4fc)this.entityTransformation);
        } else if (this.customTransformation != null) {
            this.customTransformation.doTransformation(this.modelMatrix);
        }
        this.storePoses();
        for (int i = 0; i < this.modelCubes.size(); ++i) {
            ModelCube modelCube = this.modelCubes.get(i);
            modelCube.transform.set((Matrix4fc)this.modelMatrix.method_23760().method_23761());
            this.translateAndRotate(modelCube.transform, modelCube.pose);
        }
        this.modelPartTransformation(this.modelMatrix.method_23760().method_23761());
        if (this.oldPartTransformation != null) {
            this.oldPartTransformation.set((Matrix4dc)this.partTransformation);
        }
        this.partTransformation.set((Matrix4fc)this.modelMatrix.method_23760().method_23761());
        if (this.oldPartTransformation == null) {
            this.oldPartTransformation = new Matrix4d();
            this.oldPartTransformation.set((Matrix4dc)this.partTransformation);
        }
        simulation.setTransformation(this.partTransformation);
        this.modelMatrix.method_22909();
        if (this.entity != null) {
            if (this.entity.method_5869()) {
                OceanWorld oceanWorld = PhysicsMod.getInstance(this.entity.method_73183()).getPhysicsWorld().getOceanWorld();
                Vector3d waveForce = oceanWorld.calculateWaveForce(this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321());
                Vector3d gravity = simulation.getGravity();
                gravity.set((Vector3fc)ConfigClient.getBuoyancy(this.entity.method_73183().method_27983().method_29177()));
                if (waveForce != null) {
                    double forceStrength = 10.0;
                    gravity.add(waveForce.x * forceStrength, 0.0, waveForce.z * forceStrength);
                }
                simulation.setFriction(0.7f);
            } else {
                simulation.getGravity().set((Vector3fc)ConfigClient.getGravity(this.entity.method_73183().method_27983().method_29177()));
                simulation.setFriction(this.initialFriction);
            }
        }
        return this.changeInstantly;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        for (int i = 0; i < this.modelCubes.size(); ++i) {
            this.modelCubes.get(i).updateTransformation();
        }
    }

    private void updateFixedPoints(VerletSimulation simulation, Matrix4d currentPartTransformation) {
        List<VerletPoint> points = simulation.getPoints();
        double lengthDiff = 1000.0;
        ColladaMesh mesh = simulation.cloth.mesh;
        int size = mesh.positions.size();
        List<Vector3f> positions = mesh.positions;
        for (int i = 0; i < points.size() && i < size; ++i) {
            Vector3f pos;
            VerletPoint point = points.get(i);
            if (point.locked) {
                pos = positions.get(i);
                this.tmp.set((double)pos.x, (double)pos.y, (double)pos.z);
                currentPartTransformation.transformPosition(this.tmp);
                if (this.tmp.distanceSquared((Vector3dc)point.position) > lengthDiff) {
                    simulation.destroyed = true;
                }
                point.position.set((Vector3dc)this.tmp);
                if (!this.changeInstantly) continue;
                point.prevPosition.set((Vector3dc)point.position);
                continue;
            }
            if (point.softRestriction == null) continue;
            pos = positions.get(i);
            this.tmp.set((double)pos.x, (double)pos.y, (double)pos.z);
            currentPartTransformation.transformPosition(this.tmp);
            point.softRestriction.set((Vector3dc)this.tmp);
        }
    }

    private void updateFixedPoints(double percent, VerletSimulation simulation) {
        this.updateFixedPoints(simulation, MatrixUtil.slerp(this.oldPartTransformation, this.partTransformation, percent, this.currentPartTransformation));
    }

    @Override
    public void renderBefore(Matrix4fStack matrixStack, double delta, VerletSimulation simulation) {
        if (this.isHead) {
            this.modelMatrix.method_22903();
            if (this.entity != null) {
                this.updateEntityTransformation(simulation, this.entity, null, (float)delta);
                this.modelMatrix.method_34425((Matrix4fc)this.entityTransformation);
            } else if (this.customTransformation != null) {
                this.customTransformation.doTransformation(this.modelMatrix);
            }
            this.attachedTo.transform.set((Matrix4fc)this.modelMatrix.method_23760().method_23761());
            this.attachedTo.pose = this.attachedTo.part.method_32084();
            this.translateAndRotate(this.attachedTo.transform, this.attachedTo.pose);
            this.currentPartTransformation.set((Matrix4dc)this.attachedTo.transform);
            List<VerletPoint> points = simulation.getPoints();
            ColladaMesh mesh = simulation.cloth.mesh;
            int size = mesh.positions.size();
            List<Vector3f> positions = mesh.positions;
            for (int i = 0; i < points.size() && i < size; ++i) {
                VerletPoint point = points.get(i);
                if (!point.locked) continue;
                Vector3f pos = positions.get(i);
                this.tmp.set((double)pos.x, (double)pos.y, (double)pos.z);
                this.currentPartTransformation.transformPosition(this.tmp);
                point.bufferPosition.set((Vector3dc)this.tmp);
                point.bufferPrevPosition.set((Vector3dc)this.tmp);
            }
            this.modelMatrix.method_22909();
        }
    }

    @Override
    public void preSubStep(double percent, VerletSimulation simulation) {
        this.updateFixedPoints(percent, simulation);
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
        this.doCollisionCheck(percent, simulation);
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    public void modelPartTransformation(Matrix4f modelMatrix) {
        this.translateAndRotate(modelMatrix, this.attachedTo.pose);
    }

    public static void modelPartTransformation(class_630 part, class_4587 modelMatrix) {
        part.method_22703(modelMatrix);
    }

    public void updateEntityTransformation(VerletSimulation simulation, class_1309 entity, class_3879 model, float tickDelta) {
        class_922 renderer = (class_922)class_310.method_1551().method_1561().method_3953((class_1297)entity);
        try {
            this.updateEntityTransformation(simulation, entity, (class_10042)renderer.method_62425((class_1297)entity, tickDelta), model, tickDelta);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateEntityTransformation(VerletSimulation simulation, class_1309 entity, class_10042 state, class_3879 model, float tickDelta) {
        class_4587 modelMatrix = new class_4587();
        class_922 renderer = (class_922)class_310.method_1551().method_1561().method_3953((class_1297)entity);
        try {
            class_2350 direction;
            double px = class_3532.method_16436((double)tickDelta, (double)entity.field_6038, (double)entity.method_23317());
            double py = class_3532.method_16436((double)tickDelta, (double)entity.field_5971, (double)entity.method_23318());
            double pz = class_3532.method_16436((double)tickDelta, (double)entity.field_5989, (double)entity.method_23321());
            if (simulation.getOffset() != null) {
                px -= simulation.getOffset().x;
                py -= simulation.getOffset().y;
                pz -= simulation.getOffset().z;
            } else {
                px = 0.0;
                py = 0.0;
                pz = 0.0;
            }
            class_243 positionOffset = renderer.method_23169((class_10017)state);
            modelMatrix.method_22904(positionOffset.field_1352 + px, positionOffset.field_1351 + py, positionOffset.field_1350 + pz);
            float g = class_3532.method_17821((float)tickDelta, (float)entity.field_6259, (float)entity.field_6241);
            float yaw = ModelPartConstraint.solveBodyRot(entity, g, tickDelta);
            if (entity.method_18376() == class_4050.field_18078 && (direction = entity.method_18401()) != null) {
                float eyeHeight = entity.method_18381(class_4050.field_18076) - 0.1f;
                modelMatrix.method_22904((double)((float)(-direction.method_10148()) * eyeHeight), 0.0, (double)((float)(-direction.method_10165()) * eyeHeight));
            }
            elytraFix.set((Matrix4fc)modelMatrix.method_23760().method_23761());
            renderer.method_4058(state, modelMatrix, yaw, tickDelta);
            if (!modelMatrix.method_23760().method_23761().isFinite()) {
                modelMatrix.method_23760().method_23761().set((Matrix4dc)elytraFix);
            }
            modelMatrix.method_22905(-1.0f, -1.0f, 1.0f);
            modelMatrix.method_22905(0.9375f, 0.9375f, 0.9375f);
            modelMatrix.method_22904(0.0, (double)-1.501f, 0.0);
            if (model != null) {
                float bodyRot = class_3532.method_17821((float)tickDelta, (float)entity.field_6220, (float)entity.field_6283);
                float headRot = class_3532.method_17821((float)tickDelta, (float)entity.field_6259, (float)entity.field_6241);
                float headBodyDiff = headRot - bodyRot;
                if (entity.method_5765() && entity.method_5854() instanceof class_1309) {
                    class_1309 vehicle = (class_1309)entity.method_5854();
                    bodyRot = class_3532.method_17821((float)tickDelta, (float)vehicle.field_6220, (float)vehicle.field_6283);
                    headBodyDiff = headRot - bodyRot;
                    float diffWrapped = class_3532.method_15393((float)headBodyDiff);
                    if (diffWrapped < -85.0f) {
                        diffWrapped = -85.0f;
                    }
                    if (diffWrapped >= 85.0f) {
                        diffWrapped = 85.0f;
                    }
                    bodyRot = headRot - diffWrapped;
                    if (diffWrapped * diffWrapped > 2500.0f) {
                        bodyRot += diffWrapped * 0.2f;
                    }
                    headBodyDiff = headRot - bodyRot;
                }
                float xRot = class_3532.method_16439((float)tickDelta, (float)entity.field_6004, (float)entity.method_36455());
                if (renderer.method_38563(entity)) {
                    xRot *= -1.0f;
                    headBodyDiff *= -1.0f;
                }
                float bob = (float)entity.field_6012 + tickDelta;
                float animationSpeed = 0.0f;
                float animationPosition = 0.0f;
                if (!entity.method_5765() && entity.method_5805()) {
                    animationSpeed = entity.field_42108.method_48570(tickDelta);
                    animationPosition = entity.field_42108.method_48572(tickDelta);
                    if (entity.method_6109()) {
                        animationPosition *= 3.0f;
                    }
                    if (animationSpeed > 1.0f) {
                        animationSpeed = 1.0f;
                    }
                }
                if (model instanceof class_583) {
                    class_583 entityModel = (class_583)model;
                    entityModel.method_2819((Object)state);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entityTransformation.set((Matrix4fc)modelMatrix.method_23760().method_23761());
    }

    public static float solveBodyRot(class_1309 livingEntity, float f, float g) {
        class_1297 class_12972 = livingEntity.method_5854();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity2 = (class_1309)class_12972;
            float h = class_3532.method_17821((float)g, (float)livingEntity2.field_6220, (float)livingEntity2.field_6283);
            float i = 85.0f;
            float j = class_3532.method_15363((float)class_3532.method_15393((float)(f - h)), (float)-85.0f, (float)85.0f);
            h = f - j;
            if (Math.abs(j) > 50.0f) {
                h += j * 0.2f;
            }
            return h;
        }
        return class_3532.method_17821((float)g, (float)livingEntity.field_6220, (float)livingEntity.field_6283);
    }

    public static void entityTransformation(class_4587 modelMatrix, class_1309 entity, float tickDelta) {
        class_922 renderer = (class_922)class_310.method_1551().method_1561().method_3953((class_1297)entity);
        try {
            class_2350 direction;
            class_10042 state = (class_10042)renderer.method_62425((class_1297)entity, tickDelta);
            class_243 positionOffset = renderer.method_23169((class_10017)state);
            modelMatrix.method_22904(positionOffset.field_1352, positionOffset.field_1351, positionOffset.field_1350);
            float g = class_3532.method_17821((float)tickDelta, (float)entity.field_6259, (float)entity.field_6241);
            float yaw = ModelPartConstraint.solveBodyRot(entity, g, tickDelta);
            if (entity.method_18376() == class_4050.field_18078 && (direction = entity.method_18401()) != null) {
                float eyeHeight = entity.method_18381(class_4050.field_18076) - 0.1f;
                modelMatrix.method_22904((double)((float)(-direction.method_10148()) * eyeHeight), 0.0, (double)((float)(-direction.method_10165()) * eyeHeight));
            }
            renderer.method_4058(state, modelMatrix, yaw, tickDelta);
            modelMatrix.method_22905(-1.0f, -1.0f, 1.0f);
            modelMatrix.method_22905(0.9375f, 0.9375f, 0.9375f);
            modelMatrix.method_22904(0.0, (double)-1.501f, 0.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doCollisionCheck(double percent, VerletSimulation simulation) {
        for (int i = 0; i < this.modelCubes.size(); ++i) {
            ModelCube modelCube = this.modelCubes.get(i);
            class_630 part = modelCube.part;
            if (part == null || part.field_3663.isEmpty()) continue;
            modelCube.getTransform(percent, this.transform);
            this.transform.invert(this.invTransform);
            float enlarge = 0.075f;
            float minX = modelCube.minX - enlarge;
            float minY = modelCube.minY - enlarge;
            float minZ = modelCube.minZ - enlarge;
            float maxX = modelCube.maxX + enlarge;
            float maxY = modelCube.maxY + enlarge;
            float maxZ = modelCube.maxZ + enlarge;
            List<VerletPoint> points = simulation.getPoints();
            for (int j = 0; j < points.size(); ++j) {
                VerletPoint point = points.get(j);
                if (point.locked) continue;
                this.invTransform.transformPosition(this.invPoint.set((Vector3dc)point.position));
                if (!this.helper.movePointOutOfBox(this.invPoint, minX, minY, minZ, maxX, maxY, maxZ)) continue;
                point.position.set((Vector3dc)this.transform.transformPosition(this.invPoint));
                if (!this.changeInstantly) continue;
                point.prevPosition.set((Vector3dc)point.position);
            }
        }
    }

    public void translateAndRotate(Matrix4d transform, class_5603 pose) {
        transform.translate((double)(pose.comp_2997() / 16.0f), (double)(pose.comp_2998() / 16.0f), (double)(pose.comp_2999() / 16.0f));
        if (pose.comp_3002() != 0.0f) {
            transform.rotate((Quaternionfc)this.tmpQuat.rotationZ(pose.comp_3002()));
        }
        if (pose.comp_3001() != 0.0f) {
            transform.rotate((Quaternionfc)this.tmpQuat.rotationY(pose.comp_3001()));
        }
        if (pose.comp_3000() != 0.0f) {
            transform.rotate((Quaternionfc)this.tmpQuat.rotationX(pose.comp_3000()));
        }
    }

    public void translateAndRotate(Matrix4f transform, class_5603 pose) {
        transform.translate(pose.comp_2997() / 16.0f, pose.comp_2998() / 16.0f, pose.comp_2999() / 16.0f);
        if (pose.comp_3002() != 0.0f) {
            transform.rotate((Quaternionfc)this.tmpQuat.rotationZ(pose.comp_3002()));
        }
        if (pose.comp_3001() != 0.0f) {
            transform.rotate((Quaternionfc)this.tmpQuat.rotationY(pose.comp_3001()));
        }
        if (pose.comp_3000() != 0.0f) {
            transform.rotate((Quaternionfc)this.tmpQuat.rotationX(pose.comp_3000()));
        }
    }

    public ModelCube getAttachedToPart() {
        return this.attachedTo;
    }

    public void setCustomTransformation(CustomTransformation customTransformation) {
        this.customTransformation = customTransformation;
    }

    public Matrix4f getEntityTransformation() {
        return this.entityTransformation;
    }

    public Matrix4d getCurrentPartTransformation(double percent) {
        if (this.changeInstantly) {
            return this.tmpMat.set((Matrix4dc)this.partTransformation);
        }
        return MatrixUtil.slerp(this.oldPartTransformation, this.partTransformation, percent, this.tmpMat);
    }

    public static interface CustomTransformation {
        public void doTransformation(class_4587 var1);
    }
}

