/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.IntBuffer;
import java.util.List;
import net.diebuddies.compat.Iris;
import net.diebuddies.minecraft.DynamicUniformsExtension;
import net.diebuddies.opengl.ArenaBuffer;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.StateTracker;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.snow.ChunkEntity;
import net.diebuddies.physics.snow.IChunk;
import net.diebuddies.physics.snow.SnowWorld;
import net.diebuddies.physics.snow.math.AABB3D;
import net.diebuddies.render.DynamicUniformStorageExtension;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.PBRDrawCall;
import net.diebuddies.render.shader.PhysicsShaderExtension;
import net.minecraft.class_10859;
import net.minecraft.class_10866;
import net.minecraft.class_10868;
import net.minecraft.class_11282;
import net.minecraft.class_12134;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_284;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MemoryStack;

public class SnowRenderer {
    public static final int SNOW_ENTITY_ID = 829925;
    private MainRenderer mainRenderer;
    private List<SnowDrawCall> drawCalls = new ObjectArrayList();
    private Matrix4f transformation = new Matrix4f();
    private Matrix4f currentPose = new Matrix4f();
    private Matrix3f tmp = new Matrix3f();

    public SnowRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(PhysicsWorld physics, class_638 level, Matrix4fStack viewMatrixStack, class_243 view) {
    }

    private void uploadDrawCallTransforms() {
        DynamicUniformsExtension dynamicUniforms = (DynamicUniformsExtension)RenderSystem.getDynamicUniforms();
        ((DynamicUniformStorageExtension)dynamicUniforms.physicsmod$getDynamicUniformStorage()).physicsmod$writeUniforms(this.drawCalls, drawCall -> drawCall.transform, (drawCall, gpuSlice) -> {
            drawCall.transformBuffer = gpuSlice;
        });
    }

    private void executeDrawCalls(RenderPass renderPass, SnowWorld snowWorld, Matrix3f cameraNormal) {
        GlStateManager._activeTexture((int)33984);
        GlStateManager._bindTexture((int)((class_10868)PhysicsMod.whiteTexture.texture()).method_68427());
        GL33C.glBindSampler((int)0, (int)((class_12134)MainRenderer.NEAREST_SAMPLER).method_75285());
        GlStateManager._enableCull();
        GL32C.glVertexAttrib4f((int)Data.COLOR.getAttribute(), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL32C.glVertexAttrib2f((int)Data.TEX_COORD_SHADER.getAttribute(), (float)0.0f, (float)0.0f);
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f);
        } else if (StarterClient.iris) {
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_SHADER.getAttribute(), (float)0.0f, (float)0.0f);
        }
        GL32C.glVertexAttribI2ui((int)Data.OVERLAY.getAttribute(), (int)0, (int)10);
        class_5944 program = ((class_10866)renderPass).field_57868.comp_3802();
        int entityIdLocation = ((PhysicsShaderExtension)program).physicsmod$getUniformLocation("entityId");
        if (entityIdLocation != -1) {
            GL32C.glUniform1i((int)entityIdLocation, (int)829925);
        } else if (StarterClient.iris && Data.ENTITY_ID_SHADER.getAttribute() != -1) {
            GL32C.glVertexAttribI3ui((int)Data.ENTITY_ID_SHADER.getAttribute(), (int)829925, (int)0, (int)0);
        }
        snowWorld.bindForRendering();
        class_284.class_11272 dynamicTransforms = (class_284.class_11272)program.method_34582("DynamicTransforms");
        for (int i = 0; i < this.drawCalls.size(); ++i) {
            SnowDrawCall drawCall = this.drawCalls.get(i);
            drawCall.bindPBRTextures();
            if (dynamicTransforms != null) {
                GpuBufferSlice slice = drawCall.transformBuffer;
                GL32C.glBindBufferRange((int)35345, (int)dynamicTransforms.comp_4150(), (int)((class_10859)slice.buffer()).field_57842, (long)slice.offset(), (long)slice.length());
            }
            if (StarterClient.iris) {
                Iris.setNormalMatrix(renderPass, this.drawCalls.get((int)i).transform.comp_4159(), (Matrix3fc)cameraNormal);
            }
            this.executeDrawCall(this.drawCalls.get(i));
        }
        this.drawCalls.clear();
        renderPass.close();
        StateTracker.unbindVertexArray();
        if (entityIdLocation == -1 && StarterClient.iris && Data.ENTITY_ID_SHADER.getAttribute() != -1) {
            GL32C.glVertexAttribI3ui((int)Data.ENTITY_ID_SHADER.getAttribute(), (int)0, (int)0, (int)0);
        }
    }

    private void executeDrawCall(SnowDrawCall drawCall) {
        MemoryStack stack;
        MultiDrawElementsBaseVertexCommand drawElementsCommand = drawCall.drawElementsCommand;
        MultiDrawArraysCommand drawAraysCommands = drawCall.drawAraysCommands;
        int size = drawElementsCommand.size();
        if (size > 0) {
            stack = MemoryStack.stackPush();
            try {
                IntBuffer counts = stack.mallocInt(size);
                PointerBuffer pointers = stack.mallocPointer(size);
                IntBuffer baseVertices = stack.mallocInt(size);
                for (int i = 0; i < size; ++i) {
                    counts.put(i, drawElementsCommand.getCount(i));
                    pointers.put(i, drawElementsCommand.getPointer(i));
                    baseVertices.put(i, drawElementsCommand.getBaseVertex(i));
                }
                GL32C.glMultiDrawElementsBaseVertex((int)4, (IntBuffer)counts, (int)5125, (PointerBuffer)pointers, (IntBuffer)baseVertices);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
            drawElementsCommand.clear();
        }
        if ((size = drawAraysCommands.size()) > 0) {
            stack = MemoryStack.stackPush();
            try {
                IntBuffer firsts = stack.mallocInt(size);
                IntBuffer counts = stack.mallocInt(size);
                for (int i = 0; i < size; ++i) {
                    firsts.put(i, drawAraysCommands.getFirst(i));
                    counts.put(i, drawAraysCommands.getCount(i));
                }
                GL32C.glMultiDrawArrays((int)4, (IntBuffer)firsts, (IntBuffer)counts);
            }
            finally {
                if (stack != null) {
                    stack.close();
                }
            }
            drawAraysCommands.clear();
        }
    }

    private class_11282.class_11283 setupTransform(Vector3i position, class_243 view, Matrix4f cameraRotation) {
        float scale = 1.0f / (float)IChunk.CHUNK_MULTIPLE;
        this.transformation.setTranslation((float)(((double)(position.x * IChunk.CHUNK_SIZE) + 0.5) * (double)scale - view.field_1352), (float)(((double)(position.y * IChunk.CHUNK_SIZE) + 0.5) * (double)scale - view.field_1351), (float)(((double)(position.z * IChunk.CHUNK_SIZE) + 0.5) * (double)scale - view.field_1350));
        this.transformation.m00(scale);
        this.transformation.m11(scale);
        this.transformation.m22(scale);
        cameraRotation.mul((Matrix4fc)this.transformation, this.currentPose);
        return MainRenderer.createTransformUniform(this.currentPose);
    }

    private void queueSnowDrawCall(SnowWorld snowWorld, class_1937 level, class_243 view, ChunkEntity snow, SnowDrawCall drawCall) {
        AABB3D modelBoundingBox = snow.aabb;
        Vector3d start = modelBoundingBox.start;
        Vector3d end = modelBoundingBox.end;
        if (!this.mainRenderer.frustumInt.testAab((float)(start.x - view.field_1352), (float)(start.y - view.field_1351), (float)(start.z - view.field_1350), (float)(end.x - view.field_1352), (float)(end.y - view.field_1351), (float)(end.z - view.field_1350))) {
            return;
        }
        if (snowWorld.getSnowIndexData() == null) {
            ArenaBuffer.MemorySegment segment = snow.vertexSegment;
            drawCall.drawAraysCommands.add(segment.offset / snowWorld.format.getStride(), segment.size / snowWorld.format.getStride());
        } else {
            ArenaBuffer.MemorySegment vertexSegment = snow.vertexSegment;
            ArenaBuffer.MemorySegment indexSegment = snow.indexSegment;
            int baseVertex = vertexSegment.offset / snowWorld.format.getStride();
            drawCall.drawElementsCommand.add(indexSegment.size / 4, indexSegment.offset, baseVertex);
        }
    }

    private static /* synthetic */ String lambda$render$0() {
        return "Physics Mod Snow";
    }

    private class SnowDrawCall
    extends PBRDrawCall {
        public class_11282.class_11283 transform;
        public GpuBufferSlice transformBuffer;
        public MultiDrawElementsBaseVertexCommand drawElementsCommand;
        public MultiDrawArraysCommand drawAraysCommands;

        private SnowDrawCall(SnowRenderer snowRenderer) {
        }
    }

    private static class MultiDrawElementsBaseVertexCommand {
        public IntList count = new IntArrayList();
        public LongList pointer = new LongArrayList();
        public IntList baseVertex = new IntArrayList();

        public void add(int count, long pointer, int baseVertex) {
            this.count.add(count);
            this.pointer.add(pointer);
            this.baseVertex.add(baseVertex);
        }

        public int getCount(int index) {
            return this.count.getInt(index);
        }

        public long getPointer(int index) {
            return this.pointer.getLong(index);
        }

        public int getBaseVertex(int index) {
            return this.baseVertex.getInt(index);
        }

        public void clear() {
            this.count.clear();
            this.pointer.clear();
            this.baseVertex.clear();
        }

        public int size() {
            return this.count.size();
        }
    }

    private static class MultiDrawArraysCommand {
        public IntList first = new IntArrayList();
        public IntList count = new IntArrayList();

        public void add(int first, int count) {
            this.first.add(first);
            this.count.add(count);
        }

        public int getFirst(int index) {
            return this.first.getInt(index);
        }

        public int getCount(int index) {
            return this.count.getInt(index);
        }

        public void clear() {
            this.first.clear();
            this.count.clear();
        }

        public int size() {
            return this.count.size();
        }
    }
}

