/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.opengl.StateTracker;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.PhysicsRenderable;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.shader.PhysicsShaders;
import net.diebuddies.util.IRigidBodyHolder;
import net.diebuddies.util.PerformanceTracker;
import net.diebuddies.util.SimplePoolBodyHolder;
import net.minecraft.class_10799;
import net.minecraft.class_243;
import net.minecraft.class_638;
import org.joml.Matrix4fStack;
import org.joml.Vector3d;

public class TransparencyRenderer {
    private MainRenderer mainRenderer;
    private List<IRigidBodyHolder> sortedTransparentBodies = new ObjectArrayList();
    private SimplePoolBodyHolder poolBodyHolder = new SimplePoolBodyHolder(200);

    public TransparencyRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(PhysicsWorld physics, class_638 level, Matrix4fStack viewMatrixStack, class_243 view) {
        if (this.sortedTransparentBodies.size() > 0) {
            PerformanceTracker.startNoFlush("transparent_blocks_mobs_particles_rendering");
            boolean useCustomShader = true;
            if (StarterClient.iris && Iris.isExtending()) {
                useCustomShader = false;
            }
            if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
                useCustomShader = false;
            }
            RenderPipeline pipeline = null;
            if (useCustomShader) {
                pipeline = PhysicsShaders.PHYSICS_ENTITY_TRANSPARENT_PIPELINE;
            } else {
                if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
                    Optifine.useEntityShader();
                }
                pipeline = class_10799.field_56906;
            }
            Collections.sort(this.sortedTransparentBodies);
            Vector3d physicsOffset = physics.getOffset();
            double offsetX = physicsOffset.x - view.field_1352;
            double offsetY = physicsOffset.y - view.field_1351;
            double offsetZ = physicsOffset.z - view.field_1350;
            int size = this.sortedTransparentBodies.size();
            for (int i = 0; i < size; ++i) {
                IRigidBody body = this.sortedTransparentBodies.get((int)i).body;
                PhysicsRenderable entity = body.getEntity();
                this.mainRenderer.queueDrawCall(physics, level, viewMatrixStack, view, offsetX, offsetY, offsetZ, body, entity, true);
            }
            this.mainRenderer.uploadDrawCallTransforms();
            RenderPass renderPass = this.mainRenderer.bindProperShader(() -> "Physics Mod Translucent", pipeline);
            this.mainRenderer.setupShader(renderPass);
            physics.bindForRendering();
            this.mainRenderer.executeDrawCalls(renderPass, this.mainRenderer.viewMatrix, physics.format);
            renderPass.close();
            StateTracker.unbindVertexArray();
            PerformanceTracker.end("transparent_blocks_mobs_particles_rendering");
        }
        this.sortedTransparentBodies.clear();
        this.poolBodyHolder.reset();
    }

    public void addTransparentObject(IRigidBody body, double lengthSquared) {
        this.sortedTransparentBodies.add(this.poolBodyHolder.get(body, lengthSquared));
    }

    public static void destroy() {
    }
}

