/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import net.diebuddies.config.ConfigBlocks;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.ParticleSpawner;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.blocks.BlockPhysicsType;
import net.diebuddies.physics.settings.blocks.BlockSetting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import physx.common.PxVec3;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidDynamic;

@Mixin(value={ClientLevel.class})
public class MixinClientLevel {
    @Inject(at={@At(value="HEAD")}, method={"addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"}, cancellable=true)
    private void physicsmod$addParticle(ParticleOptions particleOptions, double x, double y, double z, double vx, double vy, double vz, CallbackInfo info) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        if (ConfigClient.serverBlockPhysicsParticles && particleOptions instanceof BlockParticleOption) {
            BlockParticleOption blockParticle = (BlockParticleOption)particleOptions;
            if (camera.isInitialized() && camera.getPosition().distanceToSqr(x, y, z) < ConfigClient.blockPhysicsRange * ConfigClient.blockPhysicsRange) {
                boolean isLeaf;
                BlockState block = blockParticle.getState();
                boolean isBarrier = block.getBlock() == Blocks.BARRIER;
                boolean bl = isLeaf = block.getBlock() instanceof LeavesBlock || block.is(BlockTags.LEAVES);
                if (isBarrier || isLeaf) {
                    return;
                }
                ParticleSpawner.spawnServerBlockPhysicsParticle(blockParticle.getState(), (Level)((ClientLevel)this), x + (double)(Math.random() * 0.1f) - (double)0.05f, y + (double)(Math.random() * 0.1f) - (double)0.05f, z + (double)(Math.random() * 0.1f) - (double)0.05f, vx, vy, vz);
                info.cancel();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addEntity"})
    private void physicsmod$addEntity(Entity entity, CallbackInfo info) {
        if (entity instanceof FallingBlockEntity) {
            FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
            PhysicsMod mod = PhysicsMod.getInstance((Level)((ClientLevel)this));
            mod.fallingBlocks.add(fallingBlock.getStartPos());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addDestroyBlockEffect"}, cancellable=true)
    private void physicsmod$destroyParticles(BlockPos pos, BlockState state, CallbackInfo info) {
        BlockSetting blockSetting = ConfigBlocks.getBlockSetting(state.getBlock());
        if (blockSetting.getType() == BlockPhysicsType.PARTICLES && !state.isAir()) {
            info.cancel();
        } else if (!ConfigClient.minecraftBlockBreakParticles) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addBreakingBlockEffect"}, cancellable=true)
    private void physicsmod$crackParticles(BlockPos blockPos, Direction direction, CallbackInfo info) {
        ClientLevel level = (ClientLevel)this;
        BlockState blockState = level.getBlockState(blockPos);
        if (ConfigClient.crackPhysicsParticles && blockState.getRenderShape() != RenderShape.INVISIBLE && blockState.shouldSpawnTerrainParticles()) {
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            int blockX = blockPos.getX();
            int blockY = blockPos.getY();
            int blockZ = blockPos.getZ();
            if (camera.isInitialized() && camera.getPosition().distanceToSqr((double)blockX, (double)blockY, (double)blockZ) < ConfigClient.blockPhysicsRange * ConfigClient.blockPhysicsRange) {
                float offset = 0.1f;
                AABB aabb = blockState.getShape((BlockGetter)level, blockPos).bounds();
                double posX = (double)blockX + level.random.nextDouble() * (aabb.maxX - aabb.minX - (double)(offset * 2.0f)) + (double)offset + aabb.minX;
                double posY = (double)blockY + level.random.nextDouble() * (aabb.maxY - aabb.minY - (double)(offset * 2.0f)) + (double)offset + aabb.minY;
                double posZ = (double)blockZ + level.random.nextDouble() * (aabb.maxZ - aabb.minZ - (double)(offset * 2.0f)) + (double)offset + aabb.minZ;
                if (direction == Direction.DOWN) {
                    posY = (double)blockY + aabb.minY - (double)offset;
                }
                if (direction == Direction.UP) {
                    posY = (double)blockY + aabb.maxY + (double)offset;
                }
                if (direction == Direction.NORTH) {
                    posZ = (double)blockZ + aabb.minZ - (double)offset;
                }
                if (direction == Direction.SOUTH) {
                    posZ = (double)blockZ + aabb.maxZ + (double)offset;
                }
                if (direction == Direction.WEST) {
                    posX = (double)blockX + aabb.minX - (double)offset;
                }
                if (direction == Direction.EAST) {
                    posX = (double)blockX + aabb.maxX + (double)offset;
                }
                Vec3i normal = direction.getUnitVec3i();
                TextureAtlasSprite sprite = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(blockState);
                PhysicsMod mod = PhysicsMod.getInstance((Level)level);
                PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.PARTICLE, null);
                entity.getTransformation().translation(posX, posY, posZ).scale((double)(Math.random() * 0.06f + 0.04f));
                Model model = entity.models.get(0);
                model.texture = sprite;
                model.textureID = Minecraft.getInstance().getTextureManager().getTexture(sprite.atlasLocation()).getTextureView();
                entity.backfaceCulling = true;
                model.mesh = PhysicsMod.brokenBlock.get(0);
                int color = Minecraft.getInstance().getBlockColors().getColor(blockState, (BlockAndTintGetter)level, blockPos, 0);
                if (color == -1) {
                    color = -1;
                }
                entity.setColor(color);
                if (blockState.getBlock() == Blocks.CAULDRON || blockState.getBlock() == Blocks.GRASS_BLOCK) {
                    entity.setColor(-1);
                }
                IRigidBody body = mod.physicsWorld.addBlockParticle(entity);
                mod.physicsWorld.queue(() -> {
                    PxRigidActor patt0$temp = body.getRigidBody();
                    if (patt0$temp instanceof PxRigidDynamic) {
                        PxRigidDynamic rigidBody = (PxRigidDynamic)patt0$temp;
                        float strength = 2.0f;
                        Vector3f speed = new Vector3f((float)normal.getX() * 0.3f, (float)normal.getY() * 0.3f, (float)normal.getZ() * 0.3f);
                        speed.x += (Math.random() - 0.5f) * 0.3f;
                        speed.y += (Math.random() - 0.5f) * 0.3f;
                        speed.z += (Math.random() - 0.5f) * 0.3f;
                        speed.normalize();
                        try (MemoryStack mem = MemoryStack.stackPush();){
                            PxVec3 velocity = PxVec3.createAt(mem, MemoryStack::nmalloc, speed.x * strength, speed.y * strength, speed.z * strength);
                            rigidBody.setLinearVelocity(velocity);
                        }
                    }
                });
                float uo = Math.random() * 3.0f;
                float vo = Math.random() * 3.0f;
                Vector4f customUVs = new Vector4f(sprite.getU(uo / 4.0f), sprite.getU((uo + 1.0f) / 4.0f), sprite.getV(vo / 4.0f), sprite.getV((vo + 1.0f) / 4.0f));
                float xScale = customUVs.y - customUVs.x;
                float yScale = customUVs.w - customUVs.z;
                model.textureMatrix = new Matrix4f().translate(customUVs.x, customUVs.z, 0.0f).scale(xScale, yScale, 0.0f);
                info.cancel();
            }
        }
    }
}

