/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.ParticleSpawner;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class MixinClientPacketListener {
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    @Final
    private ClientLevel level;

    @Inject(at={@At(value="HEAD")}, method={"handleExplosion"})
    private void physicsmod$handleExplosion(ClientboundExplodePacket explosionPacket, CallbackInfo info) {
        if (RenderSystem.isOnRenderThread()) {
            Explosion explosion = new Explosion();
            explosion.strength = 5.0f;
            explosion.position = new Vector3d(explosionPacket.center().x, explosionPacket.center().y, explosionPacket.center().z);
            PhysicsMod mod = PhysicsMod.getInstance((Level)this.level);
            mod.explosions.add(explosion);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleRemoveEntities"})
    private void physicsmod$handleRemoveEntities(ClientboundRemoveEntitiesPacket packet, CallbackInfo info) {
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)((ClientPacketListener)this), (PacketProcessor)Minecraft.getInstance().packetProcessor());
        for (int i = 0; i < packet.getEntityIds().size(); ++i) {
            int j = packet.getEntityIds().getInt(i);
            Entity entity = this.level.getEntity(j);
            if (entity == null || !ConfigClient.pvpServerCompatibility && !(entity instanceof EnderDragon) && !(entity instanceof Creeper) || !(entity.position().distanceTo(Minecraft.getInstance().player.position()) < 40.0) || !(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            PhysicsMod.blockifyEntity(entity.level(), livingEntity);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"handleRespawn"})
    private void physicsmod$handleRespawn(ClientboundRespawnPacket packet, CallbackInfo info) {
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)((ClientPacketListener)this), (PacketProcessor)Minecraft.getInstance().packetProcessor());
        for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
            mod.getPhysicsWorld().destroy();
        }
        PhysicsMod.getInstances().clear();
    }

    @Inject(at={@At(value="HEAD")}, method={"handleTeleportEntity"})
    private void physicsmod$handleTeleportEntity(ClientboundTeleportEntityPacket packet, CallbackInfo info) {
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)((ClientPacketListener)this), (PacketProcessor)Minecraft.getInstance().packetProcessor());
        Entity entity = this.level.getEntity(packet.id());
        if (entity == Minecraft.getInstance().player && !entity.isPassenger()) {
            this.physicsmod$shouldDestroyWorldsDueToTeleport(entity, packet.change(), packet.relatives());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleMovePlayer"})
    private void physicsmod$handleTeleportEntity(ClientboundPlayerPositionPacket packet, CallbackInfo info) {
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)((ClientPacketListener)this), (PacketProcessor)Minecraft.getInstance().packetProcessor());
        LocalPlayer player = Minecraft.getInstance().player;
        if (!player.isPassenger()) {
            this.physicsmod$shouldDestroyWorldsDueToTeleport((Entity)player, packet.change(), packet.relatives());
        }
    }

    @Unique
    private void physicsmod$shouldDestroyWorldsDueToTeleport(Entity entity, PositionMoveRotation positionMoveRotation, Set<Relative> set) {
        boolean moved64Blocks;
        PositionMoveRotation positionMoveRotation2 = PositionMoveRotation.of((Entity)entity);
        PositionMoveRotation positionMoveRotation3 = PositionMoveRotation.calculateAbsolute((PositionMoveRotation)positionMoveRotation2, (PositionMoveRotation)positionMoveRotation, set);
        boolean bl = moved64Blocks = positionMoveRotation2.position().distanceToSqr(positionMoveRotation3.position()) > 4096.0;
        if (moved64Blocks) {
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                mod.getPhysicsWorld().destroy();
            }
            PhysicsMod.getInstances().clear();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleParticleEvent"}, cancellable=true)
    private void physicsmod$handleParticleEvent(ClientboundLevelParticlesPacket packet, CallbackInfo info) {
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)((ClientPacketListener)this), (PacketProcessor)Minecraft.getInstance().packetProcessor());
        try {
            ParticleOptions particleOptions;
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            if (ConfigClient.serverBlockPhysicsParticles && (particleOptions = packet.getParticle()) instanceof BlockParticleOption) {
                BlockParticleOption blockParticles = (BlockParticleOption)particleOptions;
                if (camera.isInitialized() && camera.getPosition().distanceToSqr(packet.getX(), packet.getY(), packet.getZ()) < ConfigClient.blockPhysicsRange * ConfigClient.blockPhysicsRange) {
                    BlockState state = blockParticles.getState();
                    if (packet.getCount() == 0) {
                        double vx = packet.getMaxSpeed() * packet.getXDist();
                        double vy = packet.getMaxSpeed() * packet.getYDist();
                        double vz = packet.getMaxSpeed() * packet.getZDist();
                        ParticleSpawner.spawnServerBlockPhysicsParticle(state, (Level)this.level, packet.getX() + (double)(Math.random() * 0.1f) - (double)0.05f, packet.getY() + (double)(Math.random() * 0.1f) - (double)0.05f, packet.getZ() + (double)(Math.random() * 0.1f) - (double)0.05f, vx, vy, vz);
                    } else {
                        for (int i = 0; i < java.lang.Math.max(packet.getCount() / 3, 1); ++i) {
                            double x = this.random.nextGaussian() * (double)packet.getXDist() + (double)(Math.random() * 0.1f) - (double)0.05f;
                            double y = this.random.nextGaussian() * (double)packet.getYDist() + (double)(Math.random() * 0.1f) - (double)0.05f;
                            double z = this.random.nextGaussian() * (double)packet.getZDist() + (double)(Math.random() * 0.1f) - (double)0.05f;
                            double vx = this.random.nextGaussian() * (double)packet.getMaxSpeed();
                            double vy = this.random.nextGaussian() * (double)packet.getMaxSpeed();
                            double vz = this.random.nextGaussian() * (double)packet.getMaxSpeed();
                            ParticleSpawner.spawnServerBlockPhysicsParticle(state, (Level)this.level, packet.getX() + x, packet.getY() + y, packet.getZ() + z, vx, vy, vz);
                        }
                    }
                    info.cancel();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"handleBlockEntityData"})
    private void physicsmod$handleBlockEntityData(ClientboundBlockEntityDataPacket packet, CallbackInfo info) {
        PacketUtils.ensureRunningOnSameThread((Packet)packet, (PacketListener)((ClientPacketListener)this), (PacketProcessor)Minecraft.getInstance().packetProcessor());
        BlockPos blockPos = packet.getPos();
        PhysicsMod.getInstance((Level)this.level).blockUpdates.add(blockPos);
    }

    @Inject(at={@At(value="HEAD")}, method={"handleLogin"})
    private void physicsmod$handleLogin(ClientboundLoginPacket packet, CallbackInfo info) {
        boolean changed = false;
        for (ResourceKey entry : packet.levels()) {
            changed |= ConfigClient.addGravityBuoyancyEntry(entry.location());
        }
        if (changed) {
            ConfigClient.save();
        }
    }
}

