/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.ocean.OceanWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.physics.PxArticulationLink;
import physx.physics.PxForceModeEnum;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBody;
import physx.physics.PxRigidDynamic;

public class BasicRigidBody
extends IRigidBody {
    private BlockState blockState;
    private Vector3d fluidVelocity;
    private float fluidHeight;
    private boolean inWater;
    private boolean wasSleeping = false;
    private boolean isSleeping = false;
    private boolean changedTransformation = false;
    private boolean gravityBefore = true;
    private Vector3f changedTranslation = new Vector3f();
    private Quaternionf changedRotation = new Quaternionf();
    private static final BlockPos.MutableBlockPos tmpPos = new BlockPos.MutableBlockPos();
    private BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();

    public BasicRigidBody() {
        this.fluidVelocity = new Vector3d();
    }

    @Override
    public void updateTransformations(PhysicsWorld physics, double diff) {
        super.updateTransformations(physics, diff);
        if (this.changedTransformation) {
            this.entity.oldPosition.set((Vector3fc)this.entity.position);
            this.entity.oldRotation.set((Quaternionfc)this.entity.rotation);
            double yPos = (double)this.changedTranslation.y + physics.getOffset().y;
            if (yPos < (double)(physics.getWorld().getMinY() - 10)) {
                this.entity.startDespawnAnimation(physics.getWorld());
            }
            this.entity.position.set((Vector3fc)this.changedTranslation);
            this.entity.rotation.set((Quaternionfc)this.changedRotation);
        }
        this.changedTransformation = false;
    }

    @Override
    public void updatePhysics(PhysicsWorld physics, double diff, boolean blocksChanged) {
        PxRigidActor posX2;
        boolean isInsideWater;
        super.updatePhysics(physics, diff, blocksChanged);
        this.isSleeping = false;
        PxRigidActor pxRigidActor = this.rigidBody;
        if (pxRigidActor instanceof PxRigidDynamic) {
            PxRigidDynamic dynamicBody = (PxRigidDynamic)pxRigidActor;
            this.isSleeping = dynamicBody.isSleeping();
        }
        Vector3d waveForce = null;
        if (!this.wasSleeping || !this.isSleeping) {
            this.changedTransformation = true;
            this.entity.oldPosition.set((Vector3fc)this.entity.position);
            this.entity.oldRotation.set((Quaternionfc)this.entity.rotation);
            PxTransform transform = this.rigidBody.getGlobalPose();
            float rotX = MemoryUtil.memGetFloat((long)transform.getAddress());
            float rotY = MemoryUtil.memGetFloat((long)(transform.getAddress() + 4L));
            float rotZ = MemoryUtil.memGetFloat((long)(transform.getAddress() + 8L));
            float rotW = MemoryUtil.memGetFloat((long)(transform.getAddress() + 12L));
            float posX2 = MemoryUtil.memGetFloat((long)(transform.getAddress() + 16L));
            float posY = MemoryUtil.memGetFloat((long)(transform.getAddress() + 20L));
            float posZ = MemoryUtil.memGetFloat((long)(transform.getAddress() + 24L));
            Vector3d offset = physics.getOffset();
            if (ConfigClient.areOceanPhysicsEnabled() && !this.isKinematicOrFrozen()) {
                OceanWorld oceanWorld = physics.getOceanWorld();
                double worldX = (double)posX2 + offset.x;
                double worldY = (double)posY + offset.y;
                double worldZ = (double)posZ + offset.z;
                waveForce = oceanWorld.calculateWaveForce(worldX, worldY, worldZ);
            }
            this.changedTranslation.set(posX2, posY, posZ);
            this.changedRotation.set(rotX, rotY, rotZ, rotW).normalize();
            this.loadChunkPhysics(posX2, posY, posZ);
            tmpPos.set((double)posX2 + offset.x, (double)posY + offset.y, (double)posZ + offset.z);
            if (this.blockState == null || !tmpPos.equals((Object)this.blockPos) || blocksChanged) {
                this.blockPos.set((Vec3i)tmpPos);
                this.blockState = physics.getWorld().getBlockState((BlockPos)this.blockPos);
                if (!(this.blockState.getFluidState().getType() instanceof EmptyFluid)) {
                    this.fluidHeight = this.blockState.getFluidState().getOwnHeight();
                    if (this.blockState.getFluidState().getType().isSame(physics.getWorld().getFluidState((BlockPos)tmpPos.set((Vec3i)this.blockPos).move(0, 1, 0)).getType())) {
                        this.fluidHeight = 1.0f;
                    }
                    Vec3 fv = this.blockState.getFluidState().getFlow((BlockGetter)physics.getWorld(), (BlockPos)this.blockPos);
                    this.fluidVelocity.set(fv.x(), fv.y(), fv.z());
                    boolean bubble = false;
                    if (this.blockState.getBlock() == Blocks.BUBBLE_COLUMN) {
                        bubble = true;
                        boolean drag = (Boolean)this.blockState.getValue((Property)BubbleColumnBlock.DRAG_DOWN);
                        this.fluidVelocity.y = drag ? -2.0 : 8.0;
                    }
                    this.fluidVelocity.y = bubble ? this.fluidVelocity.y : java.lang.Math.max(this.fluidVelocity.y, 0.0);
                } else {
                    this.fluidHeight = -1.0f;
                    this.fluidVelocity.set(0.0);
                }
            }
        }
        this.wasSleeping = this.isSleeping;
        float height = this.getFluidHeight();
        boolean oceanWaveForce = waveForce != null && waveForce.y >= 0.0;
        boolean waterBlockForce = height >= 0.0f && ((double)this.getEntity().position.y + physics.getOffset().y) % 1.0 < (double)height;
        boolean bl = isInsideWater = oceanWaveForce || waterBlockForce && (waveForce == null || waveForce.y >= 0.0);
        if (isInsideWater && (posX2 = this.getRigidBody()) instanceof PxRigidBody) {
            PxRigidBody rigidBody = (PxRigidBody)posX2;
            if (!this.inWater) {
                float vy;
                this.inWater = true;
                this.gravityBefore = this.hasGravity();
                this.setGravity(false);
                if (ConfigClient.areOceanPhysicsEnabled() && !this.isKinematicOrFrozen() && (ConfigClient.oceanRipples || ConfigClient.oceanParticles) && (double)java.lang.Math.abs(vy = rigidBody.getLinearVelocity().getY()) > 4.52) {
                    Vector3d offset = physics.getOffset();
                    double worldX = (double)this.entity.position.x + offset.x;
                    double worldY = (double)this.entity.position.y + offset.y;
                    double worldZ = (double)this.entity.position.z + offset.z;
                    double objectSize = this.entity.getBoundingSphereRadius();
                    if (ConfigClient.oceanRipples) {
                        double speed = Math.remapClamp(objectSize, 0.1, 2.0, 0.0325, 0.0625);
                        int amount = (int)Math.remapClamp(objectSize, 0.1, 2.0, 140.0, 240.0);
                        int lifetime = (int)Math.remapClamp(objectSize, 0.1, 2.0, 60.0, 80.0);
                        float scale = (float)Math.remapClamp(objectSize, 0.1, 2.0, 0.15, 0.65);
                        OceanWorld oceanWorld = physics.getOceanWorld();
                        oceanWorld.spawnRipple(amount, lifetime, scale, worldX, worldY, worldZ, speed);
                    }
                    if (objectSize > 0.4) {
                        int splashamount = (int)Math.remapClamp(objectSize, 0.4, 2.0, 30.0, 75.0);
                        double intensity = Math.remapClamp(objectSize, 0.4, 2.0, 0.25, 0.7);
                        float volume = (float)intensity * ConfigClient.oceanSplashVolume;
                        float pitch = Math.random() * 0.4f + 0.7f;
                        Level level = physics.getLevel();
                        level.playLocalSound(worldX, worldY, worldZ, WeatherEffects.SPLASH_SOUND_EVENT, SoundSource.AMBIENT, volume, pitch, true);
                        if (ConfigClient.oceanParticles) {
                            OceanWorld.createWaterSplash(level, worldX, worldY, worldZ, 0.0, 0.0, 0.0, 0.25, intensity, splashamount);
                        }
                    }
                }
            }
            float mass = this.getMass();
            float flowStrength = 4.6f;
            this.setAngularDamping(2.355f);
            this.setLinearDamping(2.355f);
            if (!this.isKinematicOrFrozen()) {
                try (MemoryStack mem = MemoryStack.stackPush();){
                    Vector3d direction = this.getFluidVelocity();
                    Vector3f buoyancy = physics.getDynamicsWorld().getBuoyancy();
                    if (rigidBody instanceof PxArticulationLink) {
                        PxVec3 v = rigidBody.getLinearVelocity();
                        PxVec3 a = rigidBody.getAngularVelocity();
                        float damping = 0.885f;
                        float aDamping = 0.885f;
                        float vx = MemoryUtil.memGetFloat((long)v.getAddress());
                        float vy = MemoryUtil.memGetFloat((long)(v.getAddress() + 4L));
                        float vz = MemoryUtil.memGetFloat((long)(v.getAddress() + 8L));
                        float ax = MemoryUtil.memGetFloat((long)a.getAddress());
                        float ay = MemoryUtil.memGetFloat((long)(a.getAddress() + 4L));
                        float az = MemoryUtil.memGetFloat((long)(a.getAddress() + 8L));
                        PxVec3 flowForce = PxVec3.createAt(mem, MemoryStack::nmalloc, -vx * (1.0f - damping), -vy * (1.0f - damping), -vz * (1.0f - damping));
                        rigidBody.addForce(flowForce, PxForceModeEnum.eVELOCITY_CHANGE);
                        PxVec3 angularForce = PxVec3.createAt(mem, MemoryStack::nmalloc, -ax * (1.0f - aDamping), -ay * (1.0f - aDamping), -az * (1.0f - aDamping));
                        rigidBody.addTorque(angularForce, PxForceModeEnum.eVELOCITY_CHANGE);
                    }
                    float forceX = buoyancy.x + (float)direction.x * flowStrength;
                    float forceY = buoyancy.y + (float)direction.y * flowStrength;
                    float forceZ = buoyancy.z + (float)direction.z * flowStrength;
                    if (waveForce != null) {
                        forceX = (float)((double)forceX + ((double)buoyancy.x * waveForce.y + -waveForce.x * 3.0));
                        forceY = (float)((double)forceY + (double)buoyancy.y * waveForce.y);
                        forceZ = (float)((double)forceZ + ((double)buoyancy.z * waveForce.y + -waveForce.z * 3.0));
                    }
                    PxVec3 counterForce = PxVec3.createAt(mem, MemoryStack::nmalloc, forceX * mass, forceY * mass, forceZ * mass);
                    rigidBody.addForce(counterForce, PxForceModeEnum.eFORCE);
                }
            }
        } else {
            if (this.inWater) {
                this.setGravity(this.gravityBefore);
                this.inWater = false;
            }
            this.setAngularDamping(0.0f);
            this.setLinearDamping(0.0f);
        }
    }

    @Override
    public boolean hasTransformationChanged() {
        if (this.wasSleeping && this.isSleeping) {
            return true;
        }
        return super.hasTransformationChanged();
    }

    public boolean isInWater() {
        return this.inWater;
    }

    public float getFluidHeight() {
        return this.fluidHeight;
    }

    public Vector3d getFluidVelocity() {
        return this.fluidVelocity;
    }
}

