/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render.shader;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class PhysicsShaders {
    private static final VertexFormatElement SMOKE_LIGHT = new VertexFormatElement(6, 0, VertexFormatElement.Type.BYTE, VertexFormatElement.Usage.POSITION, 4);
    private static final VertexFormatElement SMOKE_POS = new VertexFormatElement(7, 0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.POSITION, 4);
    private static final VertexFormatElement SMOKE_POS_NEW = new VertexFormatElement(8, 0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.POSITION, 4);
    private static final VertexFormat SMOKE_FORMAT = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).add("UV1", VertexFormatElement.UV1).add("UV2", VertexFormatElement.UV2).add("Normal", VertexFormatElement.NORMAL).add("physics_light", SMOKE_LIGHT).add("physics_offset", SMOKE_POS).add("physics_offsetNew", SMOKE_POS_NEW).padding(1).build();
    public static final RenderPipeline PHYSICS_ENTITY_PIPELINE = RenderPipelines.register((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withVertexShader(ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"core/solid_physics")).withFragmentShader(ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"core/solid_physics")).withLocation("pipeline/physics_entity").withShaderDefine("ALPHA_CUTOUT", 0.1f).withShaderDefine("NO_OVERLAY").withCull(false).withVertexFormat(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.TRIANGLES).build());
    public static final RenderPipeline PHYSICS_SMOKE_PIPELINE = RenderPipelines.register((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withVertexShader(ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"core/smoke")).withFragmentShader(ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"core/smoke")).withLocation("pipeline/physics_smoke").withShaderDefine("ALPHA_CUTOUT", 0.1f).withShaderDefine("NO_OVERLAY").withCull(false).withVertexFormat(SMOKE_FORMAT, VertexFormat.Mode.TRIANGLES).build());
    public static final RenderPipeline PHYSICS_ENTITY_TRANSPARENT_PIPELINE = RenderPipelines.register((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withVertexShader(ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"core/transparent_physics")).withFragmentShader(ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"core/transparent_physics")).withLocation("pipeline/physics_entity_transparent").withBlend(BlendFunction.TRANSLUCENT).withCull(false).withVertexFormat(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.TRIANGLES).build());
    public static final RenderPipeline PHYSICS_OCEAN_PIPELINE = RenderPipelines.register((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.TERRAIN_SNIPPET}).withVertexShader(ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"core/ocean")).withFragmentShader(ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"core/ocean")).withLocation("pipeline/physics_ocean").withBlend(BlendFunction.TRANSLUCENT).build());
    public static final RenderPipeline PHYSICS_LIQUID_PIPELINE = RenderPipelines.register((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.TERRAIN_SNIPPET}).withVertexShader(ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"core/liquid_composite")).withFragmentShader(ResourceLocation.fromNamespaceAndPath((String)"physicsmod", (String)"core/liquid_composite")).withLocation("pipeline/physics_liquid").withBlend(BlendFunction.TRANSLUCENT).build());
    private static final RenderPipeline PHYSICS_ENTITY = RenderPipelines.register((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withLocation("pipeline/physics_cloth").withShaderDefine("ALPHA_CUTOUT", 0.1f).withShaderDefine("NO_OVERLAY").withCull(false).withVertexFormat(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.TRIANGLES).build());
    private static final RenderPipeline PHYSICS_BANNER = RenderPipelines.register((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.ENTITY_SNIPPET}).withLocation("pipeline/physics_banner").withShaderDefine("NO_OVERLAY").withBlend(BlendFunction.TRANSLUCENT).withCull(false).withVertexFormat(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.TRIANGLES).build());
    public static final Function<GpuTextureView, RenderType> PHYSICS_CLOTH_RENDER_IRIS = Util.memoize(image -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new CustomTextureShard((GpuTextureView)image)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).setLayeringState(RenderType.VIEW_OFFSET_Z_LAYERING).createCompositeState(true);
        return RenderType.create((String)"armor_cutout_no_cull", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)RenderPipelines.ARMOR_CUTOUT_NO_CULL, (RenderType.CompositeState)compositeState);
    });
    public static final Function<GpuTextureView, RenderType> PHYSICS_CLOTH_RENDER = Util.memoize(image -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new CustomTextureShard((GpuTextureView)image)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).setLayeringState(RenderType.VIEW_OFFSET_Z_LAYERING).createCompositeState(true);
        return RenderType.create((String)"physics_cloth", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)PHYSICS_ENTITY, (RenderType.CompositeState)compositeState);
    });
    public static final Function<GpuTextureView, RenderType> PHYSICS_BANNER_RENDER = Util.memoize(image -> {
        RenderType.CompositeState compositeState = RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new CustomTextureShard((GpuTextureView)image)).setLightmapState(RenderType.LIGHTMAP).setOverlayState(RenderType.OVERLAY).setLayeringState(RenderType.VIEW_OFFSET_Z_LAYERING).createCompositeState(true);
        return RenderType.create((String)"physics_banner", (int)1536, (boolean)true, (boolean)false, (RenderPipeline)PHYSICS_BANNER, (RenderType.CompositeState)compositeState);
    });

    public static void init() {
    }

    public static class CustomTextureShard
    extends RenderStateShard.EmptyTextureStateShard {
        public CustomTextureShard(GpuTextureView texture) {
            super(() -> RenderSystem.setShaderTexture((int)0, (GpuTextureView)texture), () -> {});
        }
    }
}

