/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;

public class PxOutputStream
extends NativeObject {
    public static final int SIZEOF = PxOutputStream.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxOutputStream() {
    }

    private static native int __sizeOf();

    public static PxOutputStream wrapPointer(long address) {
        return address != 0L ? new PxOutputStream(address) : null;
    }

    public static PxOutputStream arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxOutputStream.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxOutputStream(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        PxOutputStream._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);
}

