#version 150

#moj_import <minecraft:dynamictransforms.glsl>
#moj_import <minecraft:projection.glsl>
#moj_import <minecraft:light.glsl>
#moj_import <minecraft:fog.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV1;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler2;

out float sphericalVertexDistance;
out float cylindricalVertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;
out vec2 texCoord1;
out vec4 normal;

void main() {
	vec4 cameraSpacePos = ModelViewMat * vec4(Position, 1.0);
    gl_Position = ProjMat * cameraSpacePos;

    sphericalVertexDistance = fog_spherical_distance(cameraSpacePos.xyz);
    // this is used for render distance stuff however we are in cameraSpace so no cylindrical calculation will work
    // just ignore it for now and hope minecraft someday implements proper model matrix uploads
    cylindricalVertexDistance = fog_cylindrical_distance(cameraSpacePos.xyz);

    vertexColor = minecraft_mix_light(normalize(Light0_Direction), normalize(Light1_Direction), Normal, Color) * texelFetch(Sampler2, UV2 / 16, 0);
    texCoord0 = (TextureMat * vec4(UV0, 0.0, 1.0)).xy;
    texCoord1 = UV1;
    normal = ProjMat * ModelViewMat * vec4(Normal, 0.0);
}
