/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.liquid;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.LiquidRigidBody;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsRenderable;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.liquid.LiquidController;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.joml.Vector3d;
import org.joml.Vector3f;
import physx.physics.PxRigidDynamic;

public class LiquidBasic
extends Liquid {
    private static final float SPAWN_ANIMATION_TIME = 0.1f;
    public List<LiquidRigidBody> particles = new ObjectArrayList();
    private final class_2338.class_2339 blockPos = new class_2338.class_2339();

    public LiquidBasic(LiquidController controller) {
        super(controller);
    }

    @Override
    public boolean update(PhysicsWorld physicsWorld, double diff) {
        this.removeDead();
        this.controller.update(this, diff);
        return this.particles.isEmpty();
    }

    private void removeDead() {
        for (int i = 0; i < this.particles.size(); ++i) {
            if (!this.particles.get(i).isDestroyed()) continue;
            this.particles.remove(i--);
        }
    }

    @Override
    public int particleCount() {
        return this.particles.size();
    }

    @Override
    public void spawnParticle(double x, double y, double z) {
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.LIQUID, null);
        entity.getTransformation().translation(x, y, z);
        entity.models = null;
        LiquidRigidBody body = this.world.addLiquidsSphere(entity, ConfigClient.liquidParticleSize * 0.5f);
        body.startLifetime = entity.time;
        ((PxRigidDynamic)body.getRigidBody()).setMaxAngularVelocity((float)Math.toRadians(360.0));
        ((PxRigidDynamic)body.getRigidBody()).setLinearDamping(0.0f);
        ((PxRigidDynamic)body.getRigidBody()).setAngularDamping(0.0f);
        ((PxRigidDynamic)body.getRigidBody()).setMaxDepenetrationVelocity(1.0f);
        this.particles.add(body);
    }

    @Override
    public int fillInstances(PhysicsWorld physicsWorld, float[] fluidpos, float[] fluidposnew, byte[] fluidlight, int offset) {
        Vector3d physicsOffset = physicsWorld.getOffset();
        for (int i = 0; i < this.particles.size(); ++i) {
            this.prepareFluidInstances(physicsWorld, physicsWorld.getLevel(), this.particles.get(i), physicsOffset.x, physicsOffset.y, physicsOffset.z, i + offset, fluidpos, fluidposnew, fluidlight);
        }
        return this.particles.size();
    }

    private void prepareFluidInstances(PhysicsWorld physics, class_1937 level, LiquidRigidBody body, double ox, double oy, double oz, int index, float[] fluidpos, float[] fluidposnew, byte[] fluidlight) {
        int dstOffset = index * 4;
        PhysicsRenderable particle = body.getEntity();
        Vector3f position = particle.position;
        Vector3f positionOld = particle.oldPosition;
        float scale = particle.getDespawnScale(physics.getWorld());
        float spawnAnimation = body.startLifetime - particle.time;
        if (spawnAnimation <= 0.1f) {
            scale = spawnAnimation / 0.1f;
        }
        this.blockPos.method_10102((double)position.x + ox, (double)position.y + oy, (double)position.z + oz);
        int brightness = particle.getLight(physics.getWorld(), this.blockPos);
        fluidlight[dstOffset] = (byte)(brightness >> 4 & 0xF | brightness >> 16 & 0xF0);
        fluidpos[dstOffset] = positionOld.x;
        fluidpos[dstOffset + 1] = positionOld.y;
        fluidpos[dstOffset + 2] = positionOld.z;
        fluidpos[dstOffset + 3] = 1.0f;
        fluidposnew[dstOffset] = position.x;
        fluidposnew[dstOffset + 1] = position.y;
        fluidposnew[dstOffset + 2] = position.z;
        fluidposnew[dstOffset + 3] = ConfigClient.liquidParticleSize * 1.2f * scale;
    }

    @Override
    public void destroy(PhysicsWorld world) {
        this.removeDead();
        for (int i = 0; i < this.particles.size(); ++i) {
            IRigidBody particle = this.particles.get(i);
            world.removeBody(particle);
            if (particle.getLastChunk() != Long.MAX_VALUE && !particle.isKinematicOrFrozen()) {
                world.removeLoadedChunkEntity(particle.getLastChunk());
            }
            world.getDynamicsWorld().removeActor(particle.getRigidBody());
            particle.destroy();
        }
        this.particles.clear();
    }
}

