/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.weather;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.resource.GraphicsResourceAllocator;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.minecraft.weather.WindSoundInstance;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private WindSoundInstance windSound;

    @Inject(at={@At(value="TAIL")}, method={"renderLevel"})
    public void renderLevel(GraphicsResourceAllocator graphicsResourceAllocator, DeltaTracker deltaTracker, boolean bl, Camera camera, Matrix4f viewMatrix, Matrix4f projectionMatrix, Matrix4f matrix4f3, GpuBufferSlice gpuBufferSlice, Vector4f vector4f, boolean bl2, CallbackInfo info) {
        WeatherEffects.invalidateLight = false;
    }

    @Inject(at={@At(value="HEAD")}, method={"setLevel"})
    private void physicsmod$stopWind(@Nullable ClientLevel clientLevel, CallbackInfo info) {
        if (this.windSound != null) {
            this.windSound.stopWind();
        }
        if (clientLevel != null) {
            this.windSound = new WindSoundInstance(clientLevel, WeatherEffects.WIND_SOUND_EVENT, SoundSource.WEATHER);
            this.minecraft.getSoundManager().queueTickingSound((TickableSoundInstance)this.windSound);
        }
    }
}

