#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:light.glsl>
#moj_import <physicsmod:liquids.glsl>

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;

uniform vec4 ColorModulator;

in vec2 pass_textureCoords;

out vec4 fragColor;

void main() {
	int lightCoords = int(texture(physics_lightcoords, gl_FragCoord.xy / textureSize(physics_lightcoords, 0)).x);
	ivec2 remappedLightCoords = ivec2(lightCoords & 0xF, (lightCoords >> 4) & 0xF); 
	float physics_fragZ = texture(physics_depth, gl_FragCoord.xy / textureSize(physics_depth, 0)).x;

	physics_normal = physics_getNormalFromDepth();
	if (physics_fragZ == 1.0) discard;

	vec3 eyePos = physics_decodeDepth(gl_FragCoord.xy / textureSize(physics_depth, 0), physics_depth, physics_invProjectionMatrix);
	float vertexDistance = length(eyePos);
	vec2 uv0 = physics_waterCoords(eyePos, physics_normal);

	// VANILLA STYLE
    vec4 color = vec4(0.24705884, 0.46274513, 0.8941177, 1.0) * texture(Sampler0, uv0).xyzw;
    color = minecraft_mix_light(normalize(Light0_Direction), normalize(Light1_Direction), physics_normal, color) * vec4(texelFetch(physics_lightmap, remappedLightCoords, 0).rgb, 1.0);
    fragColor = apply_fog(color, vertexDistance, vertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
}
