/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.diebuddies.physics.Mesh;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderHelper {
    private static Random random = new Random();

    public static void renderMesh(SubmitNodeCollector submitNodeCollector, int seed, float rotation, EntityRenderDispatcher entityRenderDispatcher, ResourceLocation texture, Mesh mesh, PoseStack poseStack, int light, int overlay, boolean shade) {
        Matrix4f transformation = new Matrix4f((Matrix4fc)poseStack.last().pose());
        random.setSeed(seed);
        transformation.rotateX(random.nextFloat() * (float)Math.PI);
        transformation.rotateY(random.nextFloat() * (float)Math.PI);
        transformation.rotateZ(random.nextFloat() * (float)Math.PI + rotation * 0.5f);
        Matrix3f normalMatrix = transformation.normal(new Matrix3f());
        if (!shade) {
            normalMatrix.set((Matrix3fc)poseStack.last().normal());
        }
        submitNodeCollector.submitCustomGeometry(poseStack, RenderType.entitySolid((ResourceLocation)texture), (pose, consumer) -> {
            Vector3f tmpPos = new Vector3f();
            Vector3f tmpNormal = new Vector3f();
            for (int i = 0; i < mesh.indicesQuads.size(); ++i) {
                int index = mesh.indicesQuads.getInt(i);
                Vector3f position = mesh.positions.get(index);
                Vector2f uv = mesh.uvs.get(index);
                Vector3f normal = mesh.normals.get(index);
                position = transformation.transformPosition((Vector3fc)position, tmpPos);
                if (shade) {
                    tmpNormal.set(normal.x, normal.y, normal.z);
                } else {
                    tmpNormal.set(0.0, 1.0, 0.0);
                }
                normalMatrix.transform(tmpNormal);
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (mesh.colors.size() > 0) {
                    int color = mesh.colors.getInt(index);
                    r = (float)(color & 0xFF) / 255.0f;
                    g = (float)(color >> 8 & 0xFF) / 255.0f;
                    b = (float)(color >> 16 & 0xFF) / 255.0f;
                }
                consumer.addVertex(position.x, position.y, position.z).setColor(r, g, b, 1.0f).setUv(uv.x, uv.y).setOverlay(overlay).setLight(light).setNormal(tmpNormal.x, tmpNormal.y, tmpNormal.z);
            }
        });
    }
}

