/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft;

import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.RenderHelper;
import net.diebuddies.minecraft.ThrownItemRenderStatePhysics;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;

public class SnowballItemRenderer<T extends Entity, S extends EntityRenderState>
extends EntityRenderer<T, ThrownItemRenderStatePhysics> {
    private final ItemModelResolver itemModelResolver;
    private final float scale;
    private final boolean fullBright;

    public SnowballItemRenderer(EntityRendererProvider.Context context, float f, boolean bl) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
        this.scale = f;
        this.fullBright = bl;
    }

    public SnowballItemRenderer(EntityRendererProvider.Context context) {
        this(context, 1.0f, false);
    }

    public int getBlockLightLevel(T entity, BlockPos blockPos) {
        return this.fullBright ? 15 : super.getBlockLightLevel(entity, blockPos);
    }

    public void submit(ThrownItemRenderStatePhysics thrownItemRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        int light = thrownItemRenderState.lightCoords;
        if (ConfigClient.snowballModel != 2) {
            RenderHelper.renderMesh(submitNodeCollector, thrownItemRenderState.id, thrownItemRenderState.rotation, this.entityRenderDispatcher, PhysicsMod.SNOWBALL_TEXTURE, PhysicsMod.snowballMesh.get(ConfigClient.snowballModel), poseStack, light, OverlayTexture.NO_OVERLAY, ConfigClient.snowballShade);
        } else {
            poseStack.pushPose();
            poseStack.scale(this.scale, this.scale, this.scale);
            poseStack.mulPose((Quaternionfc)cameraRenderState.orientation);
            thrownItemRenderState.item.submit(poseStack, submitNodeCollector, thrownItemRenderState.lightCoords, OverlayTexture.NO_OVERLAY, thrownItemRenderState.outlineColor);
            poseStack.popPose();
        }
        super.submit((EntityRenderState)thrownItemRenderState, poseStack, submitNodeCollector, cameraRenderState);
    }

    public ThrownItemRenderStatePhysics createRenderState() {
        return new ThrownItemRenderStatePhysics();
    }

    public void extractRenderState(T entity, ThrownItemRenderStatePhysics thrownItemRenderState, float tickDelta) {
        super.extractRenderState(entity, (EntityRenderState)thrownItemRenderState, tickDelta);
        this.itemModelResolver.updateForNonLiving(thrownItemRenderState.item, ((ItemSupplier)entity).getItem(), ItemDisplayContext.GROUND, entity);
        thrownItemRenderState.id = entity.getId();
        thrownItemRenderState.rotation = (float)((Entity)entity).tickCount + tickDelta;
    }
}

