/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.diebuddies.bridge.KeyBindingsRegistry;
import net.diebuddies.compat.Vivecraft;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.math.Vector3i;
import net.diebuddies.opengl.ArenaBuffer;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.StateTracker;
import net.diebuddies.opengl.VAO;
import net.diebuddies.opengl.VertexFormat;
import net.diebuddies.physics.BasicRigidBody;
import net.diebuddies.physics.BoxRigidBody;
import net.diebuddies.physics.ChunkRigidBody;
import net.diebuddies.physics.ConvexRigidBody;
import net.diebuddies.physics.DynamicsWorld;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.GrabHand;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.LiquidRigidBody;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsIndex;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsRenderable;
import net.diebuddies.physics.PhysicsUpdate;
import net.diebuddies.physics.SmokeRigidBody;
import net.diebuddies.physics.SphereRigidBody;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.smoke.InstanceUpdateCallback;
import net.diebuddies.physics.smoke.SmokeDomain;
import net.diebuddies.physics.smoke.SmokeDomainBasic;
import net.diebuddies.physics.smoke.SmokeDomainCuda;
import net.diebuddies.physics.snow.SnowWorld;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.vines.DynamicLoader;
import net.diebuddies.physics.vines.VineHelper;
import net.diebuddies.physics.wind.WeatherDomain;
import net.diebuddies.util.DoublyLinkedList;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL32C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import physx.PxTopLevelFunctions;
import physx.common.PxQuat;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.extensions.PxD6AxisEnum;
import physx.extensions.PxD6DriveEnum;
import physx.extensions.PxD6Joint;
import physx.extensions.PxD6JointDrive;
import physx.extensions.PxD6MotionEnum;
import physx.extensions.PxJoint;
import physx.particles.PxPBDMaterial;
import physx.particles.PxPBDParticleSystem;
import physx.particles.PxParticlePhaseFlagEnum;
import physx.particles.PxParticlePhaseFlags;
import physx.physics.PxActor;
import physx.physics.PxFilterData;
import physx.physics.PxHitFlagEnum;
import physx.physics.PxHitFlags;
import physx.physics.PxQueryFilterData;
import physx.physics.PxQueryFlagEnum;
import physx.physics.PxQueryFlags;
import physx.physics.PxRaycastHit;
import physx.physics.PxRaycastResult;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxRigidDynamic;

public class PhysicsWorld
implements PhysicsUpdate {
    public static final byte TERRAIN = 1;
    public static final byte DYNAMIC_OBJECT = 2;
    public static final byte KINEMATIC_MOB = 4;
    public static final byte ANCHOR = 8;
    public static final byte PARTICLES = 16;
    public static final byte DYNAMIC_BLOCKS_NO_COLLISION = 32;
    public static final byte COLLIDE_NOTHING = 0;
    public static final byte COLLIDE_ALL = 23;
    public static final byte COLLIDE_ALL_MINUS_ENTITIES = 19;
    public static final byte COLLIDE_ALL_MINUS_PARTICLES = 7;
    public static final byte COLLIDE_ALL_MINUS_DYANMIC_OBJECTS = 21;
    private static final float FIXED_TIME_STEP = 0.025f;
    public static final int CHUNK_SIZE = 4;
    public static final int CHUNK_SIZE_ONE_BITS = 3;
    public static final int CHUNK_SIZE_NUM_BITS = Integer.bitCount(3);
    public static final int CHUNK_SIZE_RELATIVE_NUM_BITS = Integer.bitCount(3);
    private static final double LIQUID_REMOVAL_DISTANCE = 128.0;
    private static final double LIQUID_REMOVAL_DISTANCE_SQUARED = 16384.0;
    public static final int FREEZE_UPDATE_RAGDOLLS_EVERY_X_TICKS = 20;
    private static final int PLAYER_GRAB_ID = Integer.MIN_VALUE;
    public float fluidParticleSize = 0.1f;
    private List<DynamicRagdoll> freezeRagdolls = new ObjectArrayList();
    private Comparator<DynamicRagdoll> freezeComparator = new Comparator<DynamicRagdoll>(this){

        @Override
        public int compare(DynamicRagdoll o1, DynamicRagdoll o2) {
            return Double.compare(o1.distanceToCamera, o2.distanceToCamera);
        }
    };
    private int ragdollFreezeRate = 20;
    private DynamicsWorld dynamicsWorld;
    private SnowWorld snowWorld;
    private OceanWorld oceanWorld;
    private SmokeDomain smokeDomain;
    private WeatherDomain weatherDomain;
    private PxPBDParticleSystem fluidSystem;
    private PxPBDMaterial fluidMat;
    private int fluidPhase;
    private List<Liquid> liquids;
    private InstanceUpdateCallback liquidInstanceUpdateCallback;
    private DoublyLinkedList<IRigidBody> bodies;
    private DoublyLinkedList<Ragdoll> ragdolls;
    private Set<PhysicsRenderable> queueForModelCreation;
    private Map<PxJoint, Tuple<IRigidBody, IRigidBody>> jointParents;
    private List<VerletSimulation> verletSimulations;
    private Level level;
    private Map<PxActor, IRigidBody> bodyLinks;
    private LongSet loadedChunks;
    private Long2IntOpenHashMap loadedChunkEntities;
    private Long2ObjectMap<ChunkRigidBody> chunkBodies;
    private Int2ObjectMap<IRigidBody> worldEntities = new Int2ObjectOpenHashMap();
    private IntSet lastEntityUpdates = new IntOpenHashSet();
    private IntSet tmpSet = new IntOpenHashSet();
    private double renderPercent;
    private List<Explosion> explosions = new ObjectArrayList();
    private LongSet chunkUpdates = new LongLinkedOpenHashSet();
    private Vector3d offset;
    private long lastSeen;
    private boolean blocksChanged;
    private boolean loadedChunkCheck = false;
    private boolean unloadedChunkCheck = false;
    private Vivecraft vivecraft;
    private ArenaBuffer modelVertexData;
    public VertexFormat format;
    public int modelVAO = -1;
    private Vector3d center = new Vector3d();
    private GrabHand grabHand = new GrabHand();

    public PhysicsWorld(Level level) {
        this.smokeDomain = ConfigClient.cudaSmoke() ? new SmokeDomainCuda(this) : new SmokeDomainBasic(this);
        this.dynamicsWorld = new DynamicsWorld(this, level, 0.025f);
        this.snowWorld = new SnowWorld(level);
        this.oceanWorld = new OceanWorld(this, level);
        this.weatherDomain = new WeatherDomain(this);
        this.jointParents = new Object2ObjectOpenHashMap();
        this.level = level;
        this.ragdolls = new DoublyLinkedList();
        this.liquids = new ObjectArrayList();
        this.bodies = new DoublyLinkedList();
        this.queueForModelCreation = new ObjectLinkedOpenHashSet();
        this.bodyLinks = new Object2ObjectOpenHashMap();
        this.loadedChunks = new LongLinkedOpenHashSet();
        this.loadedChunkEntities = new Long2IntOpenHashMap();
        this.loadedChunkEntities.defaultReturnValue(0);
        this.chunkBodies = new Long2ObjectOpenHashMap();
        this.verletSimulations = new ObjectArrayList();
        this.offset = new Vector3d();
        this.lastSeen = System.nanoTime();
        this.fluidParticleSize = ConfigClient.cudaLiquidsParticleSize;
    }

    public void createFluidSystem() {
        try (MemoryStack mem = MemoryStack.stackPush();){
            float restOffset;
            this.fluidSystem = StarterClient.physics.createPBDParticleSystem(StarterClient.cudaManager, 96);
            float solidRestOffset = restOffset = this.fluidParticleSize;
            float fluidRestOffset = restOffset * 0.6f;
            this.fluidSystem.setRestOffset(restOffset);
            this.fluidSystem.setContactOffset(restOffset + 0.01f);
            this.fluidSystem.setParticleContactOffset(fluidRestOffset / 0.6f);
            this.fluidSystem.setSolidRestOffset(solidRestOffset);
            this.fluidSystem.setFluidRestOffset(fluidRestOffset);
            this.fluidSystem.enableCCD(false);
            this.fluidSystem.setMaxVelocity(solidRestOffset * 60.0f);
            PxFilterData tmpFilterData = PxFilterData.createAt(mem, MemoryStack::nmalloc, 2, 23, 0, 0);
            this.fluidSystem.setSimulationFilterData(tmpFilterData);
            this.addParticleSystem(this.fluidSystem);
            PxParticlePhaseFlags flags = PxParticlePhaseFlags.createAt(mem, MemoryStack::nmalloc, 0);
            flags.raise(PxParticlePhaseFlagEnum.eParticlePhaseFluid);
            flags.raise(PxParticlePhaseFlagEnum.eParticlePhaseSelfCollide);
            this.fluidMat = StarterClient.physics.createPBDMaterial(0.0f, 0.02f, 0.02f, 0.001f, 8.0f, 0.04f, 0.05f, 0.02f, 0.1f, 1.0f, 1.0f);
            this.fluidPhase = this.fluidSystem.createPhase(this.fluidMat, flags);
        }
    }

    public ArenaBuffer getModelVertexData() {
        if (this.modelVertexData == null) {
            this.createGLObjects();
        }
        return this.modelVertexData;
    }

    public int getGPUMemoryUsage() {
        if (this.modelVertexData == null) {
            return 0;
        }
        return this.modelVertexData.getTotalSize();
    }

    private void createGLObjects() {
        this.modelVAO = GL32C.glGenVertexArrays();
        this.format = StarterClient.iris ? new VertexFormat(Data.POSITION, Data.COLOR, Data.TEX_COORD_SHADER, Data.NORMAL, Data.TANGENT_SHADER, Data.MID_TEX_COORD_SHADER) : (StarterClient.optifabric ? new VertexFormat(Data.POSITION, Data.COLOR, Data.TEX_COORD_SHADER, Data.NORMAL, Data.TANGENT_OPTIFINE, Data.MID_TEX_COORD_OPTIFINE) : new VertexFormat(Data.POSITION, Data.COLOR, Data.TEX_COORD_SHADER, Data.NORMAL));
        this.modelVertexData = new ArenaBuffer(262144 * this.format.getStride());
        StateTracker.bindVertexArray(this.modelVAO);
    }

    public void bindForRendering() {
        if (this.modelVAO == -1) {
            this.createGLObjects();
        }
        StateTracker.bindVertexArray(this.modelVAO);
        this.modelVertexData.bind();
        this.format.bindAttributeFormat();
    }

    public void update(double diff) {
        this.snowWorld.update(diff);
        this.oceanWorld.update(diff);
        this.dynamicsWorld.update(this, diff);
        this.renderPercent = this.dynamicsWorld.getTime() / (double)this.dynamicsWorld.getFixedTimeStep();
        this.chunkUpdates.clear();
    }

    @Override
    public void physicsUpdate(double diff) {
        this.checkChunksToUnload();
        this.updateMinecraftEntities(diff);
        PerformanceTracker.start("physics_tick_smoke");
        this.smokeDomain.update(diff);
        PerformanceTracker.end("physics_tick_smoke");
        PerformanceTracker.start("physics_tick");
        this.weatherDomain.update(diff);
        for (IRigidBody body : this.bodies) {
            if (body.isKinematicOrFrozen() || body.isDestroyed()) continue;
            body.updatePhysics(this, diff, this.blocksChanged);
        }
        this.updatePhysicsObjects(diff);
        this.blocksChanged = false;
        this.checkLoadedChunks();
        this.emptyFluidSystem();
        PerformanceTracker.end("physics_tick");
    }

    private void updatePhysicsObjects(double diff) {
        Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Iterator<IRigidBody> it = this.bodies.iterator();
        while (it.hasNext()) {
            IRigidBody body = it.next();
            if (body.isDestroyed()) {
                it.remove();
                continue;
            }
            if (body.isKinematicOrFrozen()) continue;
            body.updateTransformations(this, diff);
            PhysicsRenderable entity = body.getEntity();
            if (entity.type != PhysicsEntity.Type.VINE) {
                entity.time = (float)((double)entity.time - diff);
            }
            if (body.separateController || !((double)entity.time <= 0.0)) continue;
            this.dynamicsWorld.removeActor(body.getRigidBody());
            body.destroy();
            if (body.getLastChunk() != Long.MAX_VALUE && !body.isKinematicOrFrozen()) {
                this.removeLoadedChunkEntity(body.getLastChunk());
            }
            entity.spawnDeathAnimation(this, true);
            this.bodyLinks.remove(body.getRigidBody());
            it.remove();
        }
        if (this.ragdollFreezeRate <= 0) {
            this.freezeUpdate();
            this.ragdollFreezeRate = 20;
        }
        --this.ragdollFreezeRate;
        Iterator<Liquid> itL = this.liquids.iterator();
        while (itL.hasNext()) {
            Liquid liquid = itL.next();
            if (liquid.update(this, this.dynamicsWorld.getFixedTimeStep())) {
                liquid.destroy(this);
                itL.remove();
                continue;
            }
            if (!(cameraPos.distanceToSqr((double)liquid.blockPos.getX(), (double)liquid.blockPos.getY(), (double)liquid.blockPos.getZ()) > 16384.0)) continue;
            liquid.destroy(this);
            itL.remove();
        }
        if (this.liquidInstanceUpdateCallback != null) {
            this.liquidInstanceUpdateCallback.instanceUpdate();
        }
        Iterator<Explosion> itE = this.explosions.iterator();
        while (itE.hasNext()) {
            Explosion explosion = itE.next();
            if (explosion.tickDelay == 0) {
                this.executeExplosion(explosion);
                itE.remove();
            }
            --explosion.tickDelay;
        }
        Iterator<Ragdoll> itR = this.ragdolls.iterator();
        int ragdollSize = this.ragdolls.size();
        int mobRagdollCount = 0;
        for (int i = 0; i < ragdollSize; ++i) {
            Ragdoll ragdoll = itR.next();
            if (ragdoll.isKinematic()) continue;
            boolean destroyRagdoll = true;
            boolean isDespawning = false;
            List<Ragdoll.LinkedBody> bodies = ragdoll.btBodies;
            int size = bodies.size();
            for (int j = 0; j < size; ++j) {
                Ragdoll.LinkedBody body = bodies.get(j);
                PhysicsRenderable entity = body.rigid().getEntity();
                isDespawning |= entity.isDespawning();
                if ((double)entity.time >= 0.0) {
                    destroyRagdoll = false;
                    break;
                }
                entity.spawnDeathAnimation(this, j == 0);
            }
            if (destroyRagdoll) {
                itR.remove();
                ragdoll.remove(this);
                ragdoll.destroy();
                continue;
            }
            if (ragdoll instanceof DynamicRagdoll || isDespawning) continue;
            ++mobRagdollCount;
        }
        if (mobRagdollCount > ConfigClient.mobRagdollLimit) {
            int amountToRemove = mobRagdollCount - ConfigClient.mobRagdollLimit;
            itR = this.ragdolls.iterator();
            for (int i = 0; i < amountToRemove; ++i) {
                Ragdoll ragdoll = itR.next();
                if (ragdoll instanceof DynamicRagdoll) {
                    --i;
                    continue;
                }
                List<Ragdoll.LinkedBody> bodies = ragdoll.btBodies;
                int size = bodies.size();
                for (int j = 0; j < size; ++j) {
                    IRigidBody body = bodies.get(j).rigid();
                    PhysicsRenderable entity = body.getEntity();
                    entity.startDespawnAnimation(this.level);
                }
            }
        }
    }

    private void updateMinecraftEntities(double diff) {
        if (!(this.level instanceof ClientLevel)) {
            return;
        }
        PerformanceTracker.start("physics_tick_entities");
        ClientLevel clientLevel = (ClientLevel)this.level;
        this.tmpSet.clear();
        LocalPlayer player = Minecraft.getInstance().player;
        for (Entity entity : clientLevel.entitiesForRendering()) {
            IRigidBody ibody;
            Object body;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            AABB boundingBox = living.getBoundingBox();
            try {
                if (boundingBox == null || boundingBox.hasNaN() || living.isSpectator()) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            double width = boundingBox.maxX - boundingBox.minX;
            double height = boundingBox.maxY - boundingBox.minY;
            double depth = boundingBox.maxZ - boundingBox.minZ;
            if (width <= 0.0 || height <= 0.0 || depth <= 0.0) continue;
            this.center.set(boundingBox.maxX + boundingBox.minX, boundingBox.maxY + boundingBox.minY, boundingBox.maxZ + boundingBox.minZ).mul(0.5);
            if (!this.lastEntityUpdates.contains(living.getId())) {
                PhysicsEntity physicsEntity = new PhysicsEntity(PhysicsEntity.Type.MOB, null);
                physicsEntity.physicsGroup = (byte)4;
                physicsEntity.physicsMask = (byte)7;
                physicsEntity.getTransformation().translate((Vector3dc)this.center);
                body = null;
                body = entity instanceof AbstractClientPlayer ? BoxRigidBody.createPlayer(physicsEntity, (float)width, (float)height, (float)depth, true) : BoxRigidBody.create(physicsEntity, (float)width, (float)height, (float)depth, 0.0f, 0.0f, 0.0f, true);
                ((IRigidBody)body).setKinematic(true);
                ((IRigidBody)body).setGravity(false);
                this.dynamicsWorld.addActor(((IRigidBody)body).getRigidBody());
                this.worldEntities.put(living.getId(), body);
            }
            if (!(ibody = (IRigidBody)this.worldEntities.get(living.getId())).isDestroyed()) {
                body = (PxRigidDynamic)ibody.getRigidBody();
                try (MemoryStack mem = MemoryStack.stackPush();){
                    ((PxRigidDynamic)body).setKinematicTarget(PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)(this.center.x - this.offset.x), (float)(this.center.y - this.offset.y), (float)(this.center.z - this.offset.z)), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f)));
                }
            }
            this.tmpSet.add(living.getId());
        }
        if (StarterClient.vivecraft) {
            if (this.vivecraft == null) {
                this.vivecraft = new Vivecraft();
            }
            this.vivecraft.performVrHandsSupport(this, this.tmpSet, this.lastEntityUpdates, this.worldEntities);
        }
        if (!((KeyMapping)KeyBindingsRegistry.GRAB_PHYSICS.get()).isUnbound()) {
            this.addGrabBody(this, this.tmpSet, this.lastEntityUpdates, this.worldEntities);
            IRigidBody grabBody = (IRigidBody)this.worldEntities.get(Integer.MIN_VALUE);
            if (grabBody != null && !grabBody.isDestroyed()) {
                this.grabObject(grabBody);
            }
        }
        this.lastEntityUpdates.removeAll((IntCollection)this.tmpSet);
        IntIterator it = this.lastEntityUpdates.iterator();
        while (it.hasNext()) {
            int id = it.nextInt();
            IRigidBody body = (IRigidBody)this.worldEntities.remove(id);
            this.dynamicsWorld.removeActor(body.getRigidBody());
            body.destroy();
        }
        IntSet tmp = this.lastEntityUpdates;
        this.lastEntityUpdates = this.tmpSet;
        this.tmpSet = tmp;
        PerformanceTracker.end("physics_tick_entities");
    }

    public void addGrabBody(PhysicsWorld physicsWorld, IntSet active, IntSet activeLastFrame, Int2ObjectMap<IRigidBody> worldEntities) {
        IRigidBody ibody;
        Object body;
        Vector3d offset = physicsWorld.getOffset();
        double width = 0.2;
        double height = 0.2;
        double depth = 0.2;
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 translation = camera.getPosition();
        Vector3f lookDir = new Vector3f((Vector3fc)camera.getLookVector()).normalize();
        Vector3f upDir = new Vector3f((Vector3fc)camera.getUpVector()).normalize();
        Quaternionf rotation = new Quaternionf().lookAlong((Vector3fc)lookDir, (Vector3fc)upDir).invert();
        if (!activeLastFrame.contains(Integer.MIN_VALUE)) {
            PhysicsEntity physicsEntity = new PhysicsEntity(PhysicsEntity.Type.MOB, null);
            physicsEntity.physicsGroup = (byte)4;
            physicsEntity.physicsMask = (byte)7;
            physicsEntity.getTransformation().translationRotate(translation.x, translation.y, translation.z, (double)rotation.x, (double)rotation.y, (double)rotation.z, (double)rotation.w);
            body = null;
            body = BoxRigidBody.create(physicsEntity, (float)width, (float)height, (float)depth, 0.0f, 0.0f, 0.0f, true);
            ((IRigidBody)body).setKinematic(true);
            ((IRigidBody)body).setGravity(false);
            physicsWorld.getDynamicsWorld().addActor(((IRigidBody)body).getRigidBody());
            worldEntities.put(Integer.MIN_VALUE, body);
        }
        if (!(ibody = (IRigidBody)worldEntities.get(Integer.MIN_VALUE)).isDestroyed()) {
            body = (PxRigidDynamic)ibody.getRigidBody();
            try (MemoryStack mem = MemoryStack.stackPush();){
                ((PxRigidDynamic)body).setKinematicTarget(PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, (float)(translation.x - offset.x), (float)(translation.y - offset.y), (float)(translation.z - offset.z)), PxQuat.createAt(mem, MemoryStack::nmalloc, rotation.x, rotation.y, rotation.z, rotation.w)));
            }
        }
        active.add(Integer.MIN_VALUE);
    }

    public void grabObject(IRigidBody handBody) {
        boolean triggered = ((KeyMapping)KeyBindingsRegistry.GRAB_PHYSICS.get()).isDown();
        if (triggered && !this.grabHand.isPreviousTriggered()) {
            this.getDynamicsWorld().getScene().sceneQueriesUpdate();
            this.getDynamicsWorld().getScene().fetchQueries(true);
            if (this.grabHand.getJoint() != null) {
                this.grabHand.getJoint().release();
                this.grabHand.setJoint(null);
            }
            try (MemoryStack mem = MemoryStack.stackPush();){
                Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
                Vec3 pos = camera.getPosition();
                Vector3f dir = new Vector3f((Vector3fc)camera.getLookVector()).normalize();
                Vector3d offset = this.getOffset();
                PxVec3 origin = PxVec3.createAt(mem, MemoryStack::nmalloc, (float)(pos.x - offset.x), (float)(pos.y - offset.y), (float)(pos.z - offset.z));
                PxVec3 unitDir = PxVec3.createAt(mem, MemoryStack::nmalloc, dir.x, dir.y, dir.z);
                float distance = 5.0f;
                float closestTerrainHit = Float.MAX_VALUE;
                PxRaycastResult terrainResult = new PxRaycastResult();
                PxHitFlags terrainHitFlags = PxHitFlags.createAt(mem, MemoryStack::nmalloc, (byte)PxHitFlagEnum.eDEFAULT.value);
                PxQueryFlags terrainQueryFlags = PxQueryFlags.createAt(mem, MemoryStack::nmalloc, (byte)(PxQueryFlagEnum.eSTATIC.value | PxQueryFlagEnum.eANY_HIT.value));
                PxQueryFilterData terrainQueryFilter = PxQueryFilterData.createAt(mem, MemoryStack::nmalloc, terrainQueryFlags);
                if (this.getDynamicsWorld().getScene().raycast(origin, unitDir, distance, terrainResult, terrainHitFlags, terrainQueryFilter)) {
                    for (int i = 0; i < terrainResult.getNbAnyHits(); ++i) {
                        PxRaycastHit hit = terrainResult.getAnyHit(i);
                        float curDistance = hit.getDistance();
                        if (!(curDistance < closestTerrainHit)) continue;
                        closestTerrainHit = curDistance;
                    }
                }
                PxRaycastResult result = new PxRaycastResult();
                PxHitFlags hitFlags = PxHitFlags.createAt(mem, MemoryStack::nmalloc, (byte)PxHitFlagEnum.eDEFAULT.value);
                PxQueryFlags queryFlags = PxQueryFlags.createAt(mem, MemoryStack::nmalloc, (byte)(PxQueryFlagEnum.eDYNAMIC.value | PxQueryFlagEnum.eNO_BLOCK.value));
                PxQueryFilterData queryFilter = PxQueryFilterData.createAt(mem, MemoryStack::nmalloc, queryFlags);
                if (this.getDynamicsWorld().getScene().raycast(origin, unitDir, distance, result, hitFlags, queryFilter)) {
                    float closest = Float.MAX_VALUE;
                    PxRigidDynamic closestActor = null;
                    PxVec3 closestPos = null;
                    for (int i = 0; i < result.getNbAnyHits(); ++i) {
                        float curDistance;
                        PxRaycastHit hit = result.getAnyHit(i);
                        PxRigidDynamic dynamic = PxRigidDynamic.wrapPointer(hit.getActor().getAddress());
                        if (dynamic.getRigidBodyFlags().isSet(PxRigidBodyFlagEnum.eKINEMATIC) || !((curDistance = hit.getDistance()) < closest) || !(curDistance < closestTerrainHit)) continue;
                        closest = curDistance;
                        closestActor = dynamic;
                        closestPos = hit.getPosition();
                    }
                    if (closestActor != null) {
                        this.grabHand.setJoint(this.createGrabJoint(handBody.getRigidBody(), closestActor, closestPos));
                    }
                }
                result.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!triggered && this.grabHand.isPreviousTriggered() && this.grabHand.getJoint() != null) {
            this.grabHand.getJoint().release();
            this.grabHand.setJoint(null);
        }
        this.grabHand.setPreviousTriggered(triggered);
    }

    private void freezeUpdate() {
        Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        this.freezeRagdolls.clear();
        for (Ragdoll r : this.ragdolls) {
            r.updatePhysics(this);
            if (!(r instanceof DynamicRagdoll)) continue;
            DynamicRagdoll dynamicRagdoll = (DynamicRagdoll)r;
            if (dynamicRagdoll.aabb == null || dynamicRagdoll.initFreeze) continue;
            dynamicRagdoll.updateCameraDistance(cameraPos);
            this.freezeRagdolls.add(dynamicRagdoll);
        }
        Collections.sort(this.freezeRagdolls, this.freezeComparator);
        for (int i = 0; i < this.freezeRagdolls.size(); ++i) {
            DynamicRagdoll ragdoll = this.freezeRagdolls.get(i);
            if (i < ConfigClient.maxLoadedDynamicBlocks) {
                if (ragdoll.isFrozen()) {
                    ragdoll.wakeUp();
                }
                ragdoll.setFrozen(false);
                continue;
            }
            ragdoll.setFrozen(true);
        }
    }

    private void checkLoadedChunks() {
        if (!this.loadedChunkCheck) {
            return;
        }
        for (Long2IntMap.Entry entry : this.loadedChunkEntities.long2IntEntrySet()) {
            boolean wasLoaded;
            long chunk = entry.getLongKey();
            int amount = entry.getIntValue();
            if (amount == 0 || this.loadedChunks.contains(chunk) || !(wasLoaded = this.loadChunk(chunk))) continue;
            this.loadedChunks.add(chunk);
        }
        this.loadedChunkCheck = false;
    }

    private void checkChunksToUnload() {
        if (!this.unloadedChunkCheck) {
            return;
        }
        LongIterator it = this.loadedChunks.iterator();
        while (it.hasNext()) {
            long chunk = it.nextLong();
            if (this.loadedChunkEntities.get(chunk) > 0) continue;
            this.unloadChunk(chunk);
            it.remove();
        }
        this.unloadedChunkCheck = false;
    }

    public int loadedChunksAmount() {
        return this.loadedChunks.size();
    }

    public void addLoadedChunkEntity(int chunkX, int chunkY, int chunkZ) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.increaseLoadedChunkCounter(PhysicsIndex.pack(chunkX + x, chunkY + y, chunkZ + z));
                }
            }
        }
    }

    public void addLoadedChunkEntity(Vector3i chunk) {
        this.addLoadedChunkEntity(chunk.x, chunk.y, chunk.z);
    }

    public void addLoadedChunkEntity(long chunkIndex) {
        this.addLoadedChunkEntity(PhysicsIndex.unpackX(chunkIndex), PhysicsIndex.unpackY(chunkIndex), PhysicsIndex.unpackZ(chunkIndex));
    }

    public void increaseLoadedChunkCounter(long loaded) {
        this.loadedChunkEntities.addTo(loaded, 1);
        this.loadedChunkCheck = true;
        this.unloadedChunkCheck = true;
    }

    public void removeLoadedChunkEntity(int chunkX, int chunkY, int chunkZ) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    this.decreaseLoadedChunkCounter(PhysicsIndex.pack(chunkX + x, chunkY + y, chunkZ + z));
                }
            }
        }
    }

    public void removeLoadedChunkEntity(Vector3i chunk) {
        this.removeLoadedChunkEntity(chunk.x, chunk.y, chunk.z);
    }

    public void removeLoadedChunkEntity(long chunkIndex) {
        this.removeLoadedChunkEntity(PhysicsIndex.unpackX(chunkIndex), PhysicsIndex.unpackY(chunkIndex), PhysicsIndex.unpackZ(chunkIndex));
    }

    public void decreaseLoadedChunkCounter(long chunk) {
        int count = this.loadedChunkEntities.addTo(chunk, -1);
        if (count == 1) {
            this.loadedChunkEntities.remove(chunk);
        }
        this.loadedChunkCheck = true;
        this.unloadedChunkCheck = true;
    }

    private void unloadChunk(long chunkIndex) {
        ChunkRigidBody chunkBody = (ChunkRigidBody)this.chunkBodies.remove(chunkIndex);
        if (chunkBody != null) {
            this.dynamicsWorld.removeActor(chunkBody.getActor());
            chunkBody.destroy();
        }
    }

    public void blockUpdate(BlockPos pos) {
        this.blocksChanged = true;
        BlockState state = this.level.getBlockState(pos);
        this.weatherDomain.blockUpdate(pos);
        for (int i = 0; i < this.liquids.size(); ++i) {
            this.liquids.get(i).blockUpdate(this, pos, state);
        }
        Ragdoll changed = null;
        for (Ragdoll ragdoll : this.ragdolls) {
            if (!ragdoll.blockUpdate(this, pos, state)) continue;
            changed = ragdoll;
            break;
        }
        this.updateDynamicBlockState(changed, pos, state);
        int cx = pos.getX() >> CHUNK_SIZE_NUM_BITS;
        int cy = pos.getY() >> CHUNK_SIZE_NUM_BITS;
        int cz = pos.getZ() >> CHUNK_SIZE_NUM_BITS;
        int ax = pos.getX() & 3;
        int ay = pos.getY() & 3;
        int az = pos.getZ() & 3;
        this.updateChunk(cx, cy, cz);
        if (ax == 0) {
            this.updateChunk(cx - 1, cy, cz);
        }
        if (ay == 0) {
            this.updateChunk(cx, cy - 1, cz);
        }
        if (az == 0) {
            this.updateChunk(cx, cy, cz - 1);
        }
        if (ax == 3) {
            this.updateChunk(cx + 1, cy, cz);
        }
        if (ay == 3) {
            this.updateChunk(cx, cy + 1, cz);
        }
        if (az == 3) {
            this.updateChunk(cx, cy, cz + 1);
        }
    }

    private void updateDynamicBlockState(Ragdoll changed, BlockPos pos, BlockState state) {
    }

    private void updateChunk(int cx, int cy, int cz) {
        long chunkPos = PhysicsIndex.pack(cx, cy, cz);
        if (this.chunkUpdates.contains(chunkPos)) {
            return;
        }
        this.chunkUpdates.add(chunkPos);
        if (this.loadedChunks.contains(chunkPos)) {
            this.unloadChunk(chunkPos);
            this.loadChunk(chunkPos);
        }
    }

    private boolean loadChunk(long chunkIndex) {
        int chunkPosX = PhysicsIndex.unpackX(chunkIndex);
        int chunkPosY = PhysicsIndex.unpackY(chunkIndex);
        int chunkPosZ = PhysicsIndex.unpackZ(chunkIndex);
        if (chunkPosY < this.level.getMinY() || chunkPosY >= this.level.getMaxY() >> CHUNK_SIZE_NUM_BITS) {
            return true;
        }
        int chunkX = chunkPosX >> CHUNK_SIZE_RELATIVE_NUM_BITS;
        int chunkZ = chunkPosZ >> CHUNK_SIZE_RELATIVE_NUM_BITS;
        if (this.level.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false) == null) {
            return false;
        }
        ChunkRigidBody chunkBody = null;
        int cWorldX = chunkPosX * 4;
        int cWorldY = chunkPosY * 4;
        int cWorldZ = chunkPosZ * 4;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    BlockPos pos = new BlockPos(cWorldX + x, cWorldY + y, cWorldZ + z);
                    BlockState state = this.level.getBlockState(pos);
                    VoxelShape voxelShape = state.getCollisionShape((BlockGetter)this.level, pos);
                    if (voxelShape.isEmpty() || VineHelper.getSetting(state) != null || !this.areNeighboursEmpty(this.level, pos)) continue;
                    boolean fullBlock = Block.isShapeFullBlock((VoxelShape)voxelShape);
                    for (AABB aabb : voxelShape.toAabbs()) {
                        double width = aabb.maxX - aabb.minX;
                        double height = aabb.maxY - aabb.minY;
                        double depth = aabb.maxZ - aabb.minZ;
                        if (chunkBody == null) {
                            chunkBody = new ChunkRigidBody((double)cWorldX - this.offset.x, (double)cWorldY - this.offset.y, (double)cWorldZ - this.offset.z);
                        }
                        if (fullBlock) {
                            chunkBody.attachFullBlock(x, y, z);
                            continue;
                        }
                        chunkBody.attachBox((float)((double)x + aabb.minX + width / 2.0), (float)((double)y + aabb.minY + height / 2.0), (float)((double)z + aabb.minZ + depth / 2.0), (float)width, (float)height, (float)depth);
                    }
                }
            }
        }
        if (chunkBody != null) {
            chunkBody.compileChunk();
            this.chunkBodies.put(chunkIndex, (Object)chunkBody);
            this.dynamicsWorld.addActor(chunkBody.getActor());
        }
        return true;
    }

    private boolean areNeighboursEmpty(Level level, BlockPos pos) {
        return pos.getY() >= level.getMaxY() || pos.getY() <= level.getMinY() || pos.getY() < level.getMaxY() - 1 && this.isTranslucent(level, pos.above()) || pos.getY() > level.getMinY() && this.isTranslucent(level, pos.below()) || this.isTranslucent(level, pos.north()) || this.isTranslucent(level, pos.east()) || this.isTranslucent(level, pos.south()) || this.isTranslucent(level, pos.west());
    }

    private boolean isTranslucent(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return !Block.isShapeFullBlock((VoxelShape)state.getShape((BlockGetter)level, pos)) || state.getCollisionShape((BlockGetter)level, pos).isEmpty();
    }

    private void emptyFluidSystem() {
        if (this.liquids.isEmpty() && this.fluidSystem != null) {
            this.removeParticleSystem(this.fluidSystem);
            this.fluidSystem.release();
            this.fluidMat.release();
            this.fluidSystem = null;
            this.fluidMat = null;
        }
    }

    public void addBlockParticle(List<Mesh> brokenBlock, PhysicsEntity particle, @Nullable List<Mesh> brokenPhysicsBlock, @Nullable List<IRigidBody> result, boolean enforcePhysicsBoxes) {
        if (particle.noVolume) {
            return;
        }
        this.adjustOffset(particle.getTransformation());
        for (int i = 0; i < brokenBlock.size(); ++i) {
            Mesh mesh = brokenBlock.get(i);
            PhysicsEntity broken = new PhysicsEntity(particle.type, particle.info);
            broken.models.get((int)0).texture = particle.models.get((int)0).texture;
            broken.models.get((int)0).textureID = particle.models.get((int)0).textureID;
            broken.setColor(particle.getBGRA());
            broken.backfaceCulling = particle.backfaceCulling;
            broken.shade = particle.shade;
            if (particle.rescale == null) {
                broken.models.get((int)0).mesh = mesh;
                if (brokenPhysicsBlock != null) {
                    broken.models.get((int)0).physicsMesh = brokenPhysicsBlock.get(i);
                }
            } else {
                broken.models.get((int)0).mesh = this.scale(mesh, particle.rescale.start, particle.rescale.end);
                if (brokenPhysicsBlock != null) {
                    broken.models.get((int)0).physicsMesh = this.scalePositionOnly(brokenPhysicsBlock.get(i), particle.rescale.start, particle.rescale.end);
                    broken.models.get((int)0).physicsMesh.offset = new Vector3f((Vector3fc)broken.models.get((int)0).mesh.offset);
                }
            }
            broken.getTransformation().set((Matrix4dc)particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate((Vector3fc)broken.models.get((int)0).mesh.offset);
            broken.time = PhysicsWorld.calculateLifetime(particle);
            BasicRigidBody body = null;
            body = enforcePhysicsBoxes ? BoxRigidBody.create(broken, true) : ConvexRigidBody.create(broken, true);
            this.addBody(body);
            if (result != null) {
                result.add(body);
            }
            this.dynamicsWorld.addActor(body.getRigidBody());
            body.applyRandomSpawnForces();
        }
    }

    public void addBlockParticle(List<Mesh> brokenBlock, PhysicsEntity particle, List<IRigidBody> result) {
        this.addBlockParticle(brokenBlock, particle, null, result, false);
    }

    public void addBlockParticle(List<Mesh> brokenBlock, @Nullable List<Mesh> brokenPhysicsBlock, PhysicsEntity particle) {
        this.addBlockParticle(brokenBlock, particle, brokenPhysicsBlock, null, false);
    }

    public static float calculateLifetime(PhysicsEntity particle) {
        double time = 0.0;
        switch (particle.type) {
            case MOB: {
                time = particle.lifetime + Math.random() * particle.lifetimeVariance;
                break;
            }
            case BLOCK: {
                time = particle.lifetime + Math.random() * particle.lifetimeVariance;
                break;
            }
            case VINE: {
                time = ConfigClient.particleLifetimeVines + (double)Math.random() * ConfigClient.particleLifetimeVarianceVines;
                break;
            }
            case ITEM: {
                time = ConfigClient.particleLifetimeItems + (double)Math.random() * ConfigClient.particleLifetimeVarianceItems;
                break;
            }
            case PARTICLE: {
                time = ConfigClient.particleLifetimeParticles + (double)Math.random() * ConfigClient.particleLifetimeVarianceParticles;
                break;
            }
            case LIQUID: {
                time = ConfigClient.particleLifetimeLiquids + (double)Math.random() * ConfigClient.particleLifetimeVarianceLiquids;
                break;
            }
            case SMOKE: {
                time = ConfigClient.particleLifetimeSmoke + (double)Math.random() * ConfigClient.particleLifetimeVarianceSmoke;
                break;
            }
            default: {
                time = 4.0 + (double)Math.random() * 3.0;
            }
        }
        return (float)java.lang.Math.max(particle.getDespawnSpeed(), time);
    }

    private Mesh scale(Mesh mesh, Vector3f min, Vector3f max) {
        Mesh scaled = new Mesh();
        List<Integer> sides = mesh.calculateFaceDirections();
        int count = 0;
        for (int i = 0; i < mesh.indices.size(); ++i) {
            int index = mesh.indices.getInt(i);
            Vector3f pos = mesh.positions.get(index);
            Vector2f uv = new Vector2f((Vector2fc)mesh.uvs.get(index));
            Vector3f normal = mesh.normals.get(index);
            Integer side = sides.get(index);
            double posX = Math.clamp(Math.remapClamp((double)(pos.x + mesh.offset.x), -0.5, 0.5, (double)min.x, (double)max.x), 0.0, 1.0);
            double posY = Math.clamp(Math.remapClamp((double)(pos.y + mesh.offset.y), -0.5, 0.5, (double)min.y, (double)max.y), 0.0, 1.0);
            double posZ = Math.clamp(Math.remapClamp((double)(pos.z + mesh.offset.z), -0.5, 0.5, (double)min.z, (double)max.z), 0.0, 1.0);
            if (side == 4 || side == 5) {
                uv.set(posX, posZ);
            } else if (side == 1 || side == 3) {
                uv.set(1.0 - posZ, 1.0 - posY);
            } else if (side == 0 || side == 2) {
                uv.set(posX, 1.0 - posY);
            }
            if (mesh.colors.size() > 0) {
                scaled.colors.add(mesh.colors.getInt(index));
            }
            scaled.indices.add(count);
            scaled.uvs.add(uv);
            scaled.normals.add(new Vector3f((Vector3fc)normal));
            scaled.positions.add(new Vector3f(Math.remap(pos.x + 0.5f + mesh.offset.x, 0.0f, 1.0f, min.x, max.x) - 0.5f, Math.remap(pos.y + 0.5f + mesh.offset.y, 0.0f, 1.0f, min.y, max.y) - 0.5f, Math.remap(pos.z + 0.5f + mesh.offset.z, 0.0f, 1.0f, min.z, max.z) - 0.5f));
            ++count;
        }
        if (mesh.tangents != null && (StarterClient.iris || StarterClient.optifabric)) {
            scaled.calculatePBRData(false);
        }
        scaled.calculateOffset(false);
        return scaled;
    }

    private Mesh scalePositionOnly(Mesh mesh, Vector3f min, Vector3f max) {
        Mesh scaled = new Mesh();
        for (int i = 0; i < mesh.indices.size(); ++i) {
            int index = mesh.indices.getInt(i);
            Vector3f pos = mesh.positions.get(index);
            scaled.positions.add(new Vector3f(Math.remap(pos.x + 0.5f + mesh.offset.x, 0.0f, 1.0f, min.x, max.x) - 0.5f, Math.remap(pos.y + 0.5f + mesh.offset.y, 0.0f, 1.0f, min.y, max.y) - 0.5f, Math.remap(pos.z + 0.5f + mesh.offset.z, 0.0f, 1.0f, min.z, max.z) - 0.5f));
        }
        return scaled;
    }

    public void addRagdoll(Ragdoll ragdoll) {
        ragdoll.add(this);
        this.queue(() -> this.ragdolls.add(ragdoll));
    }

    public void removeRagdoll(Ragdoll ragdoll) {
        this.queue(() -> {
            this.ragdolls.remove(ragdoll);
            this.queue(() -> {
                ragdoll.remove(this);
                ragdoll.destroy();
            });
        });
    }

    public void addLiquid(Liquid liquid) {
        this.queue(() -> {
            liquid.add(this);
            this.liquids.add(liquid);
        });
    }

    public void removeLiquid(Liquid liquid) {
        this.queue(() -> {
            this.liquids.remove(liquid);
            liquid.destroy(this);
        });
    }

    public void clearLiquids() {
        this.queue(() -> {
            for (Liquid liquid : this.liquids) {
                liquid.destroy(this);
            }
            this.liquids.clear();
        });
    }

    public IRigidBody addBlockParticle(PhysicsEntity particle, PxRigidActor actor) {
        this.adjustOffset(particle.getTransformation());
        particle.getTransformation().set((Matrix4dc)particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate((Vector3fc)particle.models.get((int)0).mesh.offset);
        particle.time = PhysicsWorld.calculateLifetime(particle);
        BasicRigidBody body = null;
        body = particle.models.get((int)0).mesh == PhysicsMod.brokenBlock.get(0) && actor == null ? BoxRigidBody.create(particle, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, !particle.staticPhysics) : ConvexRigidBody.create(particle, actor, !particle.staticPhysics);
        this.addBody(body);
        if (actor == null) {
            this.dynamicsWorld.addActor(body.getRigidBody());
        }
        return body;
    }

    public IRigidBody addPhysicsSphere(PhysicsEntity particle, float radius) {
        this.prepareParticle(particle);
        SphereRigidBody body = SphereRigidBody.create(particle, radius, true, StarterClient.throwableMaterial);
        this.addBody(body);
        this.dynamicsWorld.addActor(body.getRigidBody());
        return body;
    }

    public LiquidRigidBody addLiquidsSphere(PhysicsEntity particle, float radius) {
        this.prepareParticle(particle);
        LiquidRigidBody body = LiquidRigidBody.create(particle, radius, StarterClient.throwableMaterial);
        this.addBody(body);
        this.dynamicsWorld.addActor(body.getRigidBody());
        return body;
    }

    public SmokeRigidBody addSmokeSphere(PhysicsEntity particle, float radius) {
        this.prepareParticle(particle);
        SmokeRigidBody body = SmokeRigidBody.createSmoke(particle, radius);
        this.addBody(body);
        this.dynamicsWorld.addActor(body.getRigidBody());
        return body;
    }

    private void prepareParticle(PhysicsEntity particle) {
        this.adjustOffset(particle.getTransformation());
        particle.getTransformation().set((Matrix4dc)particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z);
        if (particle.models != null) {
            particle.getTransformation().translate((Vector3fc)particle.models.get((int)0).mesh.offset);
        }
        particle.time = PhysicsWorld.calculateLifetime(particle);
    }

    public IRigidBody addBlockParticle(PhysicsEntity particle) {
        for (PhysicsEntity child : particle.children) {
            this.addBlockParticle(child, null);
        }
        return this.addBlockParticle(particle, null);
    }

    private IRigidBody addSingleBlockParticleBox(PhysicsEntity particle) {
        this.adjustOffset(particle.getTransformation());
        particle.getTransformation().set((Matrix4dc)particle.getTransformation()).translateLocal(-this.offset.x, -this.offset.y, -this.offset.z).translate((Vector3fc)particle.models.get((int)0).mesh.offset);
        particle.time = PhysicsWorld.calculateLifetime(particle);
        BoxRigidBody body = BoxRigidBody.createFromConvexWithOffset(particle, true);
        this.addBody(body);
        this.dynamicsWorld.addActor(body.getRigidBody());
        return body;
    }

    public IRigidBody addBlockParticleBox(PhysicsEntity particle) {
        for (PhysicsEntity child : particle.children) {
            this.addSingleBlockParticleBox(child);
        }
        return this.addSingleBlockParticleBox(particle);
    }

    public DoublyLinkedList<IRigidBody> getBodies() {
        return this.bodies;
    }

    public void addBody(IRigidBody body) {
        this.queueForModelCreation.add(body.getEntity());
        this.bodies.add(body);
        body.setPhysicsWorld(this);
        this.bodyLinks.put(body.getRigidBody(), body);
    }

    public void removeBody(IRigidBody body) {
        this.bodies.remove(body);
        this.queueForModelCreation.remove(body.getEntity());
        this.bodyLinks.remove(body.getRigidBody());
    }

    public IRigidBody getBody(PxActor actor) {
        return this.bodyLinks.get(actor);
    }

    public Long2ObjectMap<ChunkRigidBody> getChunkBodies() {
        return this.chunkBodies;
    }

    public double getRenderPercent() {
        return this.renderPercent;
    }

    public Set<PhysicsRenderable> getQueueForModelCreation() {
        return this.queueForModelCreation;
    }

    public void applyExplosion(Explosion explosion) {
        this.explosions.add(explosion);
    }

    public Vector3d getOffset() {
        return this.offset;
    }

    public void executeExplosion(Explosion explosion) {
        Vector3d tmp = new Vector3d();
        double explosionStrengthSquared = (double)explosion.strength * 2.0 * ((double)explosion.strength * 2.0);
        this.queue(() -> {
            for (IRigidBody body : this.bodies) {
                double distanceSquared = explosion.position.distanceSquared((Vector3dc)tmp.set((Vector3fc)body.getEntity().position).add((Vector3dc)this.offset));
                if (!(distanceSquared <= explosionStrengthSquared)) continue;
                double distance = java.lang.Math.sqrt(distanceSquared);
                Vector3d direction = tmp.set((Vector3fc)body.getEntity().position).add((Vector3dc)this.offset).sub((Vector3dc)explosion.position).normalize();
                direction.y += 2.0;
                direction.normalize();
                double realStrength = (1.0 - Math.clamp(distance / ((double)explosion.strength * 2.0), 0.0, 1.0)) * 15.0;
                PxRigidActor patt0$temp = body.getRigidBody();
                if (!(patt0$temp instanceof PxRigidDynamic)) continue;
                PxRigidDynamic rigidBody = (PxRigidDynamic)patt0$temp;
                rigidBody.wakeUp();
                PxVec3 v = rigidBody.getLinearVelocity();
                float vx = MemoryUtil.memGetFloat((long)v.getAddress());
                float vy = MemoryUtil.memGetFloat((long)(v.getAddress() + 4L));
                float vz = MemoryUtil.memGetFloat((long)(v.getAddress() + 8L));
                v.setX(vx + (float)(direction.x * realStrength));
                v.setY(vy + (float)(direction.y * realStrength));
                v.setZ(vz + (float)(direction.z * realStrength));
                rigidBody.setLinearVelocity(v);
            }
        });
    }

    public void updateLastSeen() {
        this.lastSeen = System.nanoTime();
    }

    public boolean isActive() {
        return System.nanoTime() - this.lastSeen <= 5000000000L;
    }

    public Level getWorld() {
        return this.level;
    }

    public DynamicsWorld getDynamicsWorld() {
        return this.dynamicsWorld;
    }

    public DoublyLinkedList<Ragdoll> getRagdolls() {
        return this.ragdolls;
    }

    public void addVerletSimulation(int index, VerletSimulation simulation) {
        this.verletSimulations.add(index, simulation);
    }

    public void addVerletSimulation(VerletSimulation simulation) {
        this.verletSimulations.add(simulation);
    }

    public void removeVerletSimulation(VerletSimulation simulation) {
        this.verletSimulations.remove(simulation);
    }

    public List<VerletSimulation> getVerletSimulations() {
        return this.verletSimulations;
    }

    public List<Liquid> getLiquids() {
        return this.liquids;
    }

    public SnowWorld getSnowWorld() {
        return this.snowWorld;
    }

    public void setSnowWorld(SnowWorld snowWorld) {
        this.snowWorld = snowWorld;
    }

    public OceanWorld getOceanWorld() {
        return this.oceanWorld;
    }

    public void setOceanWorld(OceanWorld oceanWorld) {
        this.oceanWorld = oceanWorld;
    }

    public SmokeDomain getSmokeDomain() {
        return this.smokeDomain;
    }

    public Level getLevel() {
        return this.level;
    }

    public WeatherDomain getWeatherDomain() {
        return this.weatherDomain;
    }

    public void addJointParents(PxJoint joint, Tuple<IRigidBody, IRigidBody> tuple) {
        this.jointParents.put(joint, tuple);
    }

    public void removeJointParents(PxJoint joint) {
        this.jointParents.remove(joint);
    }

    public Tuple<IRigidBody, IRigidBody> getJointParents(PxJoint joint) {
        return this.jointParents.get(joint);
    }

    public void queue(Runnable runnable) {
        this.dynamicsWorld.queue(runnable);
    }

    public void removeParticleSystem(PxPBDParticleSystem particleSystem) {
        this.dynamicsWorld.removeActor(particleSystem);
    }

    public void addParticleSystem(PxPBDParticleSystem particleSystem) {
        this.dynamicsWorld.addActor(particleSystem);
    }

    public PxPBDParticleSystem getFluidSystem() {
        if (this.fluidSystem == null) {
            this.createFluidSystem();
        }
        return this.fluidSystem;
    }

    public int getFluidPhase() {
        if (this.fluidSystem == null) {
            this.createFluidSystem();
        }
        return this.fluidPhase;
    }

    public void adjustOffset(double posX, double posY, double posZ) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0 && this.fluidSystem == null && this.smokeDomain.particleCount() == 0) {
            this.offset.set(posX, posY, posZ);
        }
    }

    public void adjustOffset(Matrix4d transformation) {
        if (this.bodies.size() == 0 && this.chunkBodies.size() == 0 && this.fluidSystem == null && this.smokeDomain.particleCount() == 0) {
            transformation.getTranslation(this.offset);
        }
    }

    public PxJoint createGrabJoint(PxRigidActor controller, PxRigidActor target, PxVec3 hitPoint) {
        Matrix4f localFrameController = this.convertTransform(controller.getGlobalPose()).invert().translate(hitPoint.getX(), hitPoint.getY(), hitPoint.getZ());
        Matrix4f localFrameTarget = this.convertTransform(target.getGlobalPose()).invert().translate(hitPoint.getX(), hitPoint.getY(), hitPoint.getZ());
        PxD6Joint joint = null;
        try (MemoryStack mem = MemoryStack.stackPush();){
            joint = PxTopLevelFunctions.D6JointCreate(StarterClient.physics, controller, this.convertTransform(localFrameController, mem), target, this.convertTransform(localFrameTarget, mem));
            joint.setMotion(PxD6AxisEnum.eX, PxD6MotionEnum.eLIMITED);
            joint.setMotion(PxD6AxisEnum.eY, PxD6MotionEnum.eLIMITED);
            joint.setMotion(PxD6AxisEnum.eZ, PxD6MotionEnum.eLIMITED);
            joint.setMotion(PxD6AxisEnum.eTWIST, PxD6MotionEnum.eLIMITED);
            joint.setMotion(PxD6AxisEnum.eSWING1, PxD6MotionEnum.eLIMITED);
            joint.setMotion(PxD6AxisEnum.eSWING2, PxD6MotionEnum.eLIMITED);
            PxD6JointDrive drive = new PxD6JointDrive(100.0f, 20.0f, 2.0f);
            joint.setDrive(PxD6DriveEnum.eX, drive);
            joint.setDrive(PxD6DriveEnum.eY, drive);
            joint.setDrive(PxD6DriveEnum.eZ, drive);
            joint.setDrive(PxD6DriveEnum.eTWIST, drive);
            joint.setDrive(PxD6DriveEnum.eSWING, drive);
            joint.setDrivePosition(PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f), PxQuat.createAt(mem, MemoryStack::nmalloc, 0.0f, 0.0f, 0.0f, 1.0f)));
            drive.destroy();
        }
        return joint;
    }

    private Matrix4f convertTransform(PxTransform transform) {
        float rotX = MemoryUtil.memGetFloat((long)transform.getAddress());
        float rotY = MemoryUtil.memGetFloat((long)(transform.getAddress() + 4L));
        float rotZ = MemoryUtil.memGetFloat((long)(transform.getAddress() + 8L));
        float rotW = MemoryUtil.memGetFloat((long)(transform.getAddress() + 12L));
        float posX = MemoryUtil.memGetFloat((long)(transform.getAddress() + 16L));
        float posY = MemoryUtil.memGetFloat((long)(transform.getAddress() + 20L));
        float posZ = MemoryUtil.memGetFloat((long)(transform.getAddress() + 24L));
        return new Matrix4f().translationRotate(posX, posY, posZ, rotX, rotY, rotZ, rotW);
    }

    private PxTransform convertTransform(Matrix4f matrix, MemoryStack mem) {
        Vector3f translation = matrix.getTranslation(new Vector3f());
        Quaternionf rotation = matrix.getUnnormalizedRotation(new Quaternionf());
        return PxTransform.createAt(mem, MemoryStack::nmalloc, PxVec3.createAt(mem, MemoryStack::nmalloc, translation.x, translation.y, translation.z), PxQuat.createAt(mem, MemoryStack::nmalloc, rotation.x, rotation.y, rotation.z, rotation.w));
    }

    public InstanceUpdateCallback getLiquidInstanceUpdateCallback() {
        return this.liquidInstanceUpdateCallback;
    }

    public void setLiquidInstanceUpdateCallback(InstanceUpdateCallback liquidInstanceUpdateCallback) {
        this.liquidInstanceUpdateCallback = liquidInstanceUpdateCallback;
    }

    public void destroy() {
        VAO.storePreviouslyBoundState();
        this.dynamicsWorld.finish();
        if (this.level instanceof ClientLevel) {
            ((DynamicLoader)((ClientLevel)this.level).getChunkSource()).setPhysicsMod(null);
        }
        this.snowWorld.destroy();
        this.oceanWorld.destroy();
        if (this.vivecraft != null) {
            this.vivecraft.destroy();
        }
        if (this.grabHand.getJoint() != null) {
            this.grabHand.getJoint().release();
            this.grabHand.setJoint(null);
        }
        for (IRigidBody body : this.bodies) {
            if (body.separateController) continue;
            this.dynamicsWorld.removeActor(body.getRigidBody());
            body.destroy();
        }
        for (IRigidBody body : this.worldEntities.values()) {
            this.dynamicsWorld.removeActor(body.getRigidBody());
            body.destroy();
        }
        for (Ragdoll ragdoll : this.ragdolls) {
            ragdoll.remove(this);
            ragdoll.destroy();
        }
        for (Liquid liquid : this.liquids) {
            liquid.destroy(this);
        }
        if (this.fluidSystem != null) {
            this.removeParticleSystem(this.fluidSystem);
            this.fluidSystem.release();
            this.fluidMat.release();
        }
        this.smokeDomain.destroy();
        for (Long2ObjectMap.Entry entry : this.chunkBodies.long2ObjectEntrySet()) {
            ChunkRigidBody body = (ChunkRigidBody)entry.getValue();
            this.dynamicsWorld.removeActor(body.getActor());
            body.destroy();
        }
        if (this.modelVertexData != null) {
            this.modelVertexData.destroy();
        }
        if (this.modelVAO != -1) {
            GL32C.glDeleteVertexArrays((int)this.modelVAO);
        }
        for (VerletSimulation simulation : this.getVerletSimulations()) {
            simulation.destroyed = true;
        }
        this.getVerletSimulations().clear();
        this.dynamicsWorld.destroy();
        this.ragdolls.clear();
        this.chunkBodies.clear();
        this.loadedChunks.clear();
        this.bodies.clear();
        this.bodyLinks.clear();
        VAO.restorePreviouslyBoundState();
    }

    private static /* synthetic */ int lambda$updateDynamicBlockState$1(BlockPos a, BlockPos b) {
        return -Integer.compare(a.getY(), b.getY());
    }

    private static /* synthetic */ int lambda$updateDynamicBlockState$0(BlockPos a, BlockPos b) {
        return Integer.compare(a.getY(), b.getY());
    }
}

