/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.ux;

import net.diebuddies.math.Math;
import net.diebuddies.mixins.guiphysics.MixinAbstractWidgetAccessor;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.diebuddies.physics.settings.ux.BaseColors;
import net.diebuddies.physics.settings.ux.TextAlignment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;

public class ButtonRenderer
extends Animator {
    private TextAlignment alignment;
    private boolean renderTooltips = true;
    private ChatFormatting chatFormatting;
    private ResourceLocation image;

    public ButtonRenderer(TextAlignment alignment, ChatFormatting chatFormatting) {
        this.chatFormatting = chatFormatting;
        this.alignment = alignment;
    }

    public ButtonRenderer(TextAlignment alignment) {
        this(alignment, null);
    }

    public ButtonRenderer() {
        this(TextAlignment.CENTER);
    }

    @Override
    public boolean render(Animatable animatable, GuiGraphics guiGraphics, int mouseX, int mouseY, float renderPercent, float delta) {
        boolean hovered;
        boolean bl = hovered = animatable.isInside(mouseX, mouseY) && guiGraphics.containsPointInScissor(mouseX, mouseY);
        if (animatable instanceof MixinAbstractWidgetAccessor) {
            MixinAbstractWidgetAccessor accessor = (MixinAbstractWidgetAccessor)((Object)animatable);
            boolean wasHovered = accessor.getIsHovered();
            accessor.setIsHovered(hovered);
            if (!wasHovered && hovered) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.WOODEN_PRESSURE_PLATE_CLICK_OFF, (float)(Math.random() * 0.2f + 0.9f)));
            }
        }
        int color = BaseColors.BACKGROUND_COLOR;
        float x = animatable.getAnimX();
        float y = animatable.getAnimY();
        float width = animatable.getAnimWidth();
        float height = animatable.getAnimHeight();
        float depth = animatable.getAnimDepth();
        AbstractButton button = (AbstractButton)animatable;
        if (!button.active) {
            color = BaseColors.INACTIVE_COLOR;
        }
        ButtonRenderer.drawRect(guiGraphics, x, y, width, height, depth, color);
        if (this.image != null) {
            ButtonRenderer.drawRect(guiGraphics, this.image, (float)((int)x), (float)((int)y), (float)((int)width), (float)((int)height), 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, ARGB.colorFromFloat((float)animatable.getAnimAlpha(), (float)animatable.getAnimRed(), (float)animatable.getAnimGreen(), (float)animatable.getAnimBlue()));
        }
        FormattedCharSequence formattedCharSequence = (this.chatFormatting == null ? button.getMessage() : button.getMessage().copy().withStyle(this.chatFormatting)).getVisualOrderText();
        Font font = Minecraft.getInstance().font;
        float xText = x + 7.0f;
        if (this.alignment == TextAlignment.CENTER) {
            xText = x + width * 0.5f - (float)font.width(formattedCharSequence) * 0.5f;
        } else if (this.alignment == TextAlignment.RIGHT) {
            xText = x + width - (float)font.width(formattedCharSequence) - 7.0f;
        }
        ButtonRenderer.drawText(guiGraphics, font, formattedCharSequence, Math.fastRound(xText), Math.fastRound(y + (height - 8.0f) / 2.0f));
        if (this.renderTooltips && animatable instanceof MixinAbstractWidgetAccessor) {
            AbstractWidget widget;
            MixinAbstractWidgetAccessor invoker = (MixinAbstractWidgetAccessor)((Object)animatable);
            if (animatable instanceof AbstractWidget && (widget = (AbstractWidget)animatable).isHoveredOrFocused()) {
                invoker.getTooltipHolder().refreshTooltipForNextRenderPass(guiGraphics, mouseX, mouseY, widget.isHovered(), widget.isFocused(), widget.getRectangle());
            }
        }
        return true;
    }

    public ButtonRenderer setRenderTooltips(boolean renderTooltips) {
        this.renderTooltips = renderTooltips;
        return this;
    }

    public boolean isRenderingTooltips() {
        return this.renderTooltips;
    }

    public ResourceLocation getImage() {
        return this.image;
    }

    public ButtonRenderer setImage(ResourceLocation image) {
        this.image = image;
        return this;
    }
}

