/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.smoke;

import it.unimi.dsi.fastutil.longs.LongSet;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.smoke.InstanceUpdateCallback;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public abstract class SmokeDomain {
    public PhysicsWorld world;
    public InstanceUpdateCallback instanceUpdateCallback;

    public SmokeDomain(PhysicsWorld world) {
        this.world = world;
    }

    public static boolean isInOpenAir(Level level, int x, int y, int z) {
        return y >= level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
    }

    public abstract void spawnParticle(double var1, double var3, double var5, float var7);

    public abstract void executeExplosion(Explosion var1);

    public abstract int particleCount();

    public abstract int fillInstances(Vec3 var1, float[] var2, float[] var3, byte[] var4);

    public abstract void clearParticles();

    public abstract void destroy();

    public void invalidateBrightness(LongSet updatedLightBlocks) {
    }

    public void update(double diff) {
        if (this.instanceUpdateCallback != null) {
            this.instanceUpdateCallback.instanceUpdate();
        }
    }

    public void setInstanceUpdateCallback(InstanceUpdateCallback instanceUpdateCallback) {
        this.instanceUpdateCallback = instanceUpdateCallback;
    }

    public InstanceUpdateCallback getInstanceUpdateCallback() {
        return this.instanceUpdateCallback;
    }

    public PhysicsWorld getWorld() {
        return this.world;
    }
}

