/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import net.diebuddies.compat.ValkyrienSkies;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.ocean.OceanWorld;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class MixinEntity
implements EntityOcean {
    @Unique
    private double physicsOffset;
    @Unique
    private double physicsOldOffset;
    @Unique
    private double physicsRoll;
    @Unique
    private double physicsOldRoll;
    @Unique
    private double physicsPitch;
    @Unique
    private double physicsOldPitch;
    @Unique
    private double velocityY;
    @Unique
    private double velocityRoll;
    @Unique
    private double velocityPitch;
    @Unique
    private boolean wasInAir;
    @Unique
    private double rippleTime;
    @Unique
    private boolean wasEyeUnderwater;

    @Inject(at={@At(value="HEAD")}, method={"doWaterSplashEffect"})
    private void physicsmod$doOceanRippleEffect(CallbackInfo info) {
        Entity entity = (Entity)this;
    }

    @Unique
    private void spawnSplashRipple(Entity entity) {
        Vec3 deltaMovement = entity.getDeltaMovement();
        double vy = java.lang.Math.abs(deltaMovement.y);
        if (vy < 0.1) {
            return;
        }
        double speed = Math.remapClamp(vy, 0.1, 2.0, 0.0425, 0.0625);
        int amount = (int)Math.remapClamp(vy, 0.1, 2.0, 120.0, 240.0);
        int lifetime = (int)Math.remapClamp(vy, 0.1, 2.0, 70.0, 80.0);
        float scale = (float)Math.remapClamp(vy, 0.1, 2.0, 0.2, 0.65);
        OceanWorld oceanWorld = PhysicsMod.getInstance(entity.level()).getPhysicsWorld().getOceanWorld();
        oceanWorld.spawnRipple(amount, lifetime, scale, entity.getX(), entity.getY() + this.getPhysicsYOffset(), entity.getZ(), speed);
    }

    @Unique
    private void spawnSplashParticles(Entity entity) {
        Vec3 deltaMovement = entity.getDeltaMovement();
        double vy = java.lang.Math.abs(deltaMovement.y);
        if (vy < 0.25) {
            return;
        }
        int splashamount = (int)Math.remapClamp(vy, 0.1, 2.0, 10.0, 75.0);
        double intensity = Math.remapClamp(vy, 0.1, 2.0, 0.075, 0.5);
        float volume = (float)intensity * ConfigClient.oceanSplashVolume;
        float pitch = Math.random() * 0.4f + 0.7f;
        Level level = entity.level();
        level.playLocalSound(entity.getX(), entity.getY() + this.getPhysicsYOffset(), entity.getZ(), WeatherEffects.SPLASH_SOUND_EVENT, SoundSource.AMBIENT, volume, pitch, true);
        if (ConfigClient.oceanParticles) {
            OceanWorld.createWaterSplash(level, entity.getX(), entity.getY() + this.getPhysicsYOffset(), entity.getZ(), 0.0, 0.0, 0.0, 0.25, intensity, splashamount);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void physicsmod$spawnMovementRippleEffect(CallbackInfo info) {
        Entity entity = (Entity)this;
    }

    @Unique
    private boolean isCausingSplash(Entity entity) {
        boolean isEyeUnderwater = entity.isEyeInFluid(FluidTags.WATER);
        boolean result = !isEyeUnderwater && this.wasEyeUnderwater;
        this.wasEyeUnderwater = isEyeUnderwater;
        return result;
    }

    @Unique
    private boolean isCausingRipples(Entity entity) {
        boolean isOnSurface = true;
        if (!ConfigClient.oceanStickyEntities && entity instanceof Boat) {
            isOnSurface = !((EntityOcean)entity).isInPhysicsAir();
        }
        return isOnSurface && !entity.isSpectator() && entity.isInWater() && (entity.level().getBlockState(entity.blockPosition().above()).isAir() || entity instanceof AbstractClientPlayer && entity.level().getBlockState(entity.blockPosition().above().above()).isAir());
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void physicsmod$updateOceanTransformations(CallbackInfo info) {
        Entity entity = (Entity)this;
    }

    @Inject(at={@At(value="HEAD")}, method={"pick"}, cancellable=true)
    private void physicsmod$modifyBlockPickingForOceanTransformations(double range, float renderPercent, boolean bl, CallbackInfoReturnable<HitResult> info) {
        Entity entity = (Entity)this;
    }

    @Override
    public double getPhysicsYOffset(float renderPercent) {
        if (PhysicsMod.stopOceanDisplacement) {
            return 0.0;
        }
        return Mth.lerp((double)renderPercent, (double)this.getPhysicsOldYOffset(), (double)this.getPhysicsYOffset());
    }

    @Override
    public double getPhysicsPitch(float renderPercent) {
        if (PhysicsMod.stopOceanDisplacement) {
            return 0.0;
        }
        return Mth.lerp((double)renderPercent, (double)this.getPhysicsOldPitch(), (double)this.getPhysicsPitch());
    }

    @Override
    public double getPhysicsRoll(float renderPercent) {
        if (PhysicsMod.stopOceanDisplacement) {
            return 0.0;
        }
        return Mth.lerp((double)renderPercent, (double)this.getPhysicsOldRoll(), (double)this.getPhysicsRoll());
    }

    @Override
    public double getPhysicsYOffset() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.getVehicle();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsYOffset();
        }
        return this.physicsOffset;
    }

    @Override
    public double getPhysicsOldYOffset() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.getVehicle();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsOldYOffset();
        }
        return this.physicsOldOffset;
    }

    @Override
    public double getPhysicsPitch() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.getVehicle();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsPitch();
        }
        return this.physicsPitch;
    }

    @Override
    public double getPhysicsOldPitch() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.getVehicle();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsOldPitch();
        }
        return this.physicsOldPitch;
    }

    @Override
    public double getPhysicsRoll() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.getVehicle();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsRoll();
        }
        return this.physicsRoll;
    }

    @Override
    public double getPhysicsOldRoll() {
        Entity entity = (Entity)this;
        EntityOcean vehicle = (EntityOcean)entity.getVehicle();
        if (StarterClient.valkyrienSkies && vehicle == null) {
            vehicle = ValkyrienSkies.hasShipMount(entity);
        }
        if (vehicle != null) {
            return vehicle.getPhysicsOldRoll();
        }
        return this.physicsOldRoll;
    }

    @Override
    public boolean isInPhysicsAir() {
        return this.wasInAir;
    }
}

