/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render.shader;

import com.mojang.blaze3d.opengl.GlStateManager;
import net.diebuddies.opengl.FBO;
import net.diebuddies.opengl.Texture;
import net.diebuddies.opengl.VAO;
import net.diebuddies.render.shader.GaussianDepthBlurShader;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class GaussianDepthBlurEffect {
    private GaussianDepthBlurShader shader;
    private FBO firstBlur;
    private FBO image;
    private Vector2f vertical = new Vector2f(0.0f, 1.0f);
    private Vector2f horizontal = new Vector2f(1.0f, 0.0f);

    public GaussianDepthBlurEffect() {
        this.shader = new GaussianDepthBlurShader();
    }

    public void render(Matrix4f projectionMatrix, float blurWorldDistance, VAO emptyVAO) {
        GlStateManager._disableDepthTest();
        this.firstBlur.bind();
        float m22 = projectionMatrix.m22();
        float m32 = projectionMatrix.m32();
        float near = m32 / (m22 - 1.0f);
        float far = m32 / (m22 + 1.0f);
        this.shader.bind();
        this.shader.uploadTexelSize(new Vector2f(1.0f / (float)this.image.getTexture().getWidth(), 1.0f / (float)this.image.getTexture().getWidth()));
        this.shader.uploadOffset(this.vertical);
        this.shader.uploadImage(this.image.getTexture().getID());
        this.shader.setUniform1(this.shader.getUniformLocation("near"), near);
        this.shader.setUniform1(this.shader.getUniformLocation("far"), far);
        this.shader.setUniform1(this.shader.getUniformLocation("p00"), projectionMatrix.m00());
        this.shader.setUniform1(this.shader.getUniformLocation("blurWorldDistance"), blurWorldDistance);
        emptyVAO.renderEmptyTriangle();
        this.image.bind();
        this.shader.uploadOffset(this.horizontal);
        this.shader.uploadImage(this.firstBlur.getTexture().getID());
        emptyVAO.renderEmptyTriangle();
        GlStateManager._enableDepthTest();
    }

    public void setImage(FBO image) {
        if (this.firstBlur == null || this.firstBlur.getTexture().getWidth() != image.getTexture().getWidth() || this.firstBlur.getTexture().getHeight() != image.getTexture().getHeight()) {
            if (this.firstBlur != null) {
                this.firstBlur.destroy();
            }
            this.firstBlur = new FBO();
            this.firstBlur.attachColorBuffer(Texture.createTexture(image.getTexture().getWidth(), image.getTexture().getHeight(), 33326, 6403, 5126));
        }
        this.image = image;
    }

    public void destroy() {
        this.shader.destroy();
        if (this.firstBlur != null) {
            this.firstBlur.destroy();
        }
    }

    public void resize(int width, int height) {
    }
}

