/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.minecraft;

import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.RenderHelper;
import net.diebuddies.minecraft.ThrownItemRenderStatePhysics;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;

public class EnderpearItemRenderer<T extends Entity, S extends EntityRenderState>
extends EntityRenderer<T, ThrownItemRenderStatePhysics> {
    private final ItemModelResolver itemModelResolver;
    private final float scale;
    private final boolean fullBright;

    public EnderpearItemRenderer(EntityRendererProvider.Context context, float f, boolean bl) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
        this.scale = f;
        this.fullBright = bl;
    }

    public EnderpearItemRenderer(EntityRendererProvider.Context context) {
        this(context, 1.0f, false);
    }

    public int getBlockLightLevel(T entity, BlockPos blockPos) {
        return this.fullBright ? 15 : super.getBlockLightLevel(entity, blockPos);
    }

    public void render(ThrownItemRenderStatePhysics thrownItemRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        if (ConfigClient.enderpearlModel != 2) {
            RenderHelper.renderMesh(multiBufferSource, thrownItemRenderState.id, thrownItemRenderState.rotation, this.entityRenderDispatcher, PhysicsMod.ENDERPEARL_TEXTURE, PhysicsMod.enderpearlMesh.get(ConfigClient.enderpearlModel), poseStack, light, OverlayTexture.NO_OVERLAY, ConfigClient.enderpearlShade);
        } else {
            poseStack.pushPose();
            poseStack.scale(this.scale, this.scale, this.scale);
            poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
            thrownItemRenderState.item.render(poseStack, multiBufferSource, light, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        super.render((EntityRenderState)thrownItemRenderState, poseStack, multiBufferSource, light);
    }

    public ThrownItemRenderStatePhysics createRenderState() {
        return new ThrownItemRenderStatePhysics();
    }

    public void extractRenderState(T entity, ThrownItemRenderStatePhysics thrownItemRenderState, float tickDelta) {
        super.extractRenderState(entity, (EntityRenderState)thrownItemRenderState, tickDelta);
        this.itemModelResolver.updateForNonLiving(thrownItemRenderState.item, ((ItemSupplier)entity).getItem(), ItemDisplayContext.GROUND, entity);
        thrownItemRenderState.id = entity.getId();
        thrownItemRenderState.rotation = (float)((Entity)entity).tickCount + tickDelta;
    }
}

