/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.diebuddies.physics.PlayerRenderStateExtended;
import net.diebuddies.physics.settings.cloth.ClothConstants;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class MixinLivingEntityRenderer<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>>
extends EntityRenderer<T, S>
implements RenderLayerParent<S, M> {
    @Shadow
    @Final
    protected List<RenderLayer> layers;

    protected MixinLivingEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void physicsmod$addPhysicsClothLayer(EntityRendererProvider.Context context, M entityModel, float shadowRadius, CallbackInfo info) {
        CapeLayer capeLayer = null;
        for (int i = 0; i < this.layers.size(); ++i) {
            CapeLayer layer;
            RenderLayer renderLayer = this.layers.get(i);
            if (!(renderLayer instanceof CapeLayer)) continue;
            capeLayer = layer = (CapeLayer)renderLayer;
        }
        if (capeLayer != null) {
            this.layers.remove(capeLayer);
            this.layers.add((RenderLayer)capeLayer);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;setupAnim(Lnet/minecraft/client/renderer/entity/state/EntityRenderState;)V", shift=At.Shift.AFTER)})
    private void physicsmod$hideModelParts(LivingEntityRenderState livingEntityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, CallbackInfo info) {
        if (livingEntityRenderState instanceof PlayerRenderStateExtended) {
            PlayerRenderStateExtended extended = (PlayerRenderStateExtended)livingEntityRenderState;
            ClothConstants.hideProperParts((Model)this.getModel(), extended.physicsmod$getClothRenderState().hiddenModelParts);
        }
    }
}

