/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.sodium;

import com.mojang.blaze3d.vertex.PoseStack;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.client.render.immediate.model.EntityRenderer;
import net.caffeinemc.mods.sodium.client.render.immediate.model.ModelCuboid;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.model.geom.ModelPart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={EntityRenderer.class})
public class MixinEntityRenderer {
    @Unique
    private static ModelPart sodiumPart;

    @Inject(at={@At(value="HEAD")}, method={"renderCuboids"}, remap=false)
    private static void physicsmod$renderCuboids(PoseStack.Pose matrices, VertexBufferWriter writer, ModelCuboid[] cuboids, int light, int overlay, int color, CallbackInfo info) {
        PhysicsMod mod = PhysicsMod.getCurrentInstance();
        if (mod != null && mod.blockify && sodiumPart != null) {
            PhysicsMod.createParticlesFromCuboids(matrices, mod.localPivotMatrix, MixinEntityRenderer.sodiumPart.cubes, mod.cubifyEntity, mod.cubifyEntityRenderer, mod.blockifyFeature, overlay, (float)ColorABGR.unpackRed((int)color) / 255.0f, (float)ColorABGR.unpackGreen((int)color) / 255.0f, (float)ColorABGR.unpackBlue((int)color) / 255.0f);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"render"}, remap=false)
    private static void physicsmod$renderHead(PoseStack matrixStack, VertexBufferWriter writer, ModelPart part, int light, int overlay, int color, CallbackInfo info) {
        PhysicsMod mod = PhysicsMod.getCurrentInstance();
        if (mod != null && mod.blockify && part.visible) {
            sodiumPart = part;
            mod.localPivotMatrix.pushPose();
            part.translateAndRotate(mod.localPivotMatrix);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"render"}, remap=false)
    private static void physicsmod$renderTail(PoseStack matrixStack, VertexBufferWriter writer, ModelPart part, int light, int overlay, int color, CallbackInfo info) {
        PhysicsMod mod = PhysicsMod.getCurrentInstance();
        if (mod != null && mod.blockify && part.visible) {
            mod.localPivotMatrix.popPose();
            sodiumPart = null;
        }
    }
}

