/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.gui;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.physics.settings.gui.GuiPhysicsCustomRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.MultiBufferSource;

public class GuiPhysicsCustomRenderer
extends PictureInPictureRenderer<GuiPhysicsCustomRenderState> {
    public GuiPhysicsCustomRenderer(MultiBufferSource.BufferSource bufferSource) {
        super(bufferSource);
    }

    public Class<GuiPhysicsCustomRenderState> getRenderStateClass() {
        return GuiPhysicsCustomRenderState.class;
    }

    protected void renderToTexture(GuiPhysicsCustomRenderState guiEntityRenderState, PoseStack poseStack) {
    }

    public void prepare(GuiPhysicsCustomRenderState pictureInPictureRenderState, GuiRenderState guiRenderState, int guiScale) {
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer((float)window.getWidth() / (float)window.getGuiScale(), (float)window.getHeight() / (float)window.getGuiScale()), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        pictureInPictureRenderState.renderable().render();
    }

    public final void prepareCustomTexturesAndProjection(int width, int height) {
        if (this.texture != null && (this.texture.getWidth(0) != width || this.texture.getHeight(0) != height)) {
            this.texture.close();
            this.texture = null;
            this.textureView.close();
            this.textureView = null;
            this.depthTexture.close();
            this.depthTexture = null;
            this.depthTextureView.close();
            this.depthTextureView = null;
        }
        if (this.texture == null) {
            GpuDevice gpuDevice = RenderSystem.getDevice();
            this.texture = gpuDevice.createTexture(() -> "UI " + this.getTextureLabel() + " texture", 12, TextureFormat.RGBA8, width, height, 1, 1);
            this.textureView = gpuDevice.createTextureView(this.texture);
            this.texture.setTextureFilter(FilterMode.NEAREST, false);
            this.depthTexture = gpuDevice.createTexture(() -> "UI " + this.getTextureLabel() + " depth texture", 8, TextureFormat.DEPTH32, width, height, 1, 1);
            this.depthTextureView = gpuDevice.createTextureView(this.depthTexture);
            gpuDevice.createCommandEncoder().clearColorAndDepthTextures(this.texture, 0, this.depthTexture, 1.0);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer((float)width, (float)height), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
    }

    protected float getTranslateY(int i, int j) {
        return (float)i / 2.0f;
    }

    protected String getTextureLabel() {
        return "physics mod entity";
    }

    public static interface GuiRenderable {
        public void render();
    }
}

