/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.ux;

import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import net.diebuddies.opengl.ResourceManager;
import net.diebuddies.opengl.Texture;
import net.diebuddies.physics.liquid.SimpleTextureDimension;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class ImageElement
extends AbstractWidget {
    private ResourceManager resourceManager;
    private float textureWidth;
    private float textureHeight;
    private float textureAspectRatio;
    private Texture texture;
    private ResourceLocation imageLocation;
    private boolean keepAspectRatio;
    private boolean slide;
    private float time;
    public boolean destroyAfterRender;

    public ImageElement(ResourceLocation imageLocation, float x, float y, float width, float height, boolean keepAspectRatio) {
        super((int)x, (int)y, (int)width, (int)height, null);
        this.imageLocation = imageLocation;
        this.keepAspectRatio = keepAspectRatio;
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        AbstractTexture abstractTexture = textureManager.getTexture(imageLocation);
        abstractTexture.setFilter(true, true);
        if (abstractTexture instanceof SimpleTextureDimension) {
            SimpleTextureDimension textureDimension = (SimpleTextureDimension)abstractTexture;
            this.textureWidth = textureDimension.getWidth();
            this.textureHeight = textureDimension.getHeight();
        } else {
            this.textureWidth = width;
            this.textureHeight = height;
        }
        this.textureAspectRatio = this.textureWidth / this.textureHeight;
    }

    public ImageElement(ResourceManager resourceManager, ResourceLocation imageLocation, float x, float y, float width, float height, boolean keepAspectRatio) {
        super((int)x, (int)y, (int)width, (int)height, null);
        this.resourceManager = resourceManager;
        this.imageLocation = imageLocation;
        this.keepAspectRatio = keepAspectRatio;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Runnable destruction;
        this.time += delta / 20.0f;
        Animatable ths = (Animatable)((Object)this);
        float umin = 0.0f;
        float umax = 1.0f;
        float vmin = 0.0f;
        float vmax = 1.0f;
        if (this.keepAspectRatio) {
            float panelAspectRatio = ths.getAnimWidth() / ths.getAnimHeight();
            if (this.textureAspectRatio < panelAspectRatio) {
                multiplier = panelAspectRatio / this.textureAspectRatio;
                half = (1.0f - (vmax /= multiplier)) * 0.5f;
                vmax += half;
                vmin += half;
            } else {
                multiplier = panelAspectRatio / this.textureAspectRatio;
                half = (1.0f - (umax *= multiplier)) * 0.5f;
                umax += half;
                umin += half;
            }
        }
        float x = ths.getAnimX();
        float y = ths.getAnimY();
        float width = ths.getAnimWidth();
        float height = ths.getAnimHeight();
        float depth = ths.getAnimDepth();
        GpuTextureView wrapper = null;
        if (this.resourceManager != null) {
            wrapper = RenderSystem.getDevice().createTextureView((GpuTexture)new GlTexture(4, "", TextureFormat.RGBA8, this.texture.getWidth(), this.texture.getHeight(), 1, 1, this.texture.getID()));
        } else {
            TextureManager textureManager = Minecraft.getInstance().getTextureManager();
            AbstractTexture abstractTexture = textureManager.getTexture(this.getImageLocation());
            wrapper = abstractTexture.getTextureView();
        }
        wrapper.texture().setTextureFilter(FilterMode.LINEAR, FilterMode.LINEAR, false);
        int color = ARGB.colorFromFloat((float)ths.getAnimAlpha(), (float)ths.getAnimRed(), (float)ths.getAnimGreen(), (float)ths.getAnimBlue());
        Runnable runnable = destruction = this.destroyAfterRender ? () -> this.destroyLoadedTexture() : () -> {};
        if (this.slide) {
            double curveFunction = Math.pow(Math.cos(Math.pow(Math.sin((double)this.time * 0.7), 3.0)), 10.0);
            double perc = (curveFunction - 0.0021202) / 0.9978798;
            Animator.drawRect(guiGraphics, wrapper, x, y, width * (float)perc, height, depth, umin, umax * (float)perc, vmin, vmax, color, destruction);
        } else {
            Animator.drawRect(guiGraphics, wrapper, x, y, width, height, depth, umin, umax, vmin, vmax, color, destruction);
        }
        this.destroyAfterRender = false;
    }

    public ResourceLocation getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(ResourceLocation imageLocation) {
        this.imageLocation = imageLocation;
    }

    public void updateWidgetNarration(NarrationElementOutput var1) {
    }

    public void destroyLoadedTexture() {
        if (this.resourceManager != null) {
            this.resourceManager.destroyTexture(this.imageLocation);
            this.texture = null;
        }
    }

    public boolean loadImage() {
        if (this.resourceManager == null) {
            return true;
        }
        if (this.texture == null) {
            this.texture = this.resourceManager.getTexture(this.imageLocation, false, Texture.FILTER_LOAD_GUI_TEXTURE);
            return false;
        }
        this.resourceManager.update();
        if (this.texture.getID() == -1) {
            return false;
        }
        this.textureWidth = this.texture.getWidth();
        this.textureHeight = this.texture.getHeight();
        this.textureAspectRatio = this.textureWidth / this.textureHeight;
        return true;
    }

    public ImageElement enableSlide() {
        this.slide = true;
        return this;
    }
}

