/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.GlRenderPipeline;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.opengl.Uniform;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.minecraft.DynamicUniformsExtension;
import net.diebuddies.mixins.ocean.MixinLightTextureAccessor;
import net.diebuddies.opengl.ArenaBuffer;
import net.diebuddies.opengl.Data;
import net.diebuddies.opengl.Texture;
import net.diebuddies.opengl.VertexFormat;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.OceanMesh;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.ocean.ProxyOceanLayer;
import net.diebuddies.physics.snow.math.AABB3D;
import net.diebuddies.render.DynamicUniformStorageExtension;
import net.diebuddies.render.GlStateManagerPhysics;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.render.OceanRippleRenderer;
import net.diebuddies.render.shader.PhysicsShaderExtension;
import net.diebuddies.render.shader.PhysicsShaders;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL32C;

public class OceanRenderer {
    private MainRenderer mainRenderer;
    private OceanRippleRenderer rippleRenderer;
    private List<OceanDrawCall> drawCalls = new ObjectArrayList();
    private List<OceanDrawCall> rippleDrawCalls = new ObjectArrayList();
    private Matrix4f transformation = new Matrix4f();
    private Matrix4f currentPose = new Matrix4f();
    private Matrix3f tmp = new Matrix3f();
    private int rippleActiveTexture = 0;
    private int foamActiveTexture = 26;
    private int lightmapActiveTexture = 27;
    private int activeTexture = 0;

    public OceanRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
        this.rippleRenderer = new OceanRippleRenderer(mainRenderer);
    }

    public void render(PhysicsWorld physics, ClientLevel level, Matrix4fStack matrixStackIn, Vec3 view) {
    }

    private void sendDrawCalls(OceanWorld oceanWorld, GpuTextureView waterTexture, Matrix3f normalMatrix, @Nullable ProxyOceanLayer layer, List<OceanDrawCall> drawCalls) {
        if (drawCalls.size() == 0) {
            return;
        }
        this.uploadDrawCallTransforms(drawCalls);
        RenderPass renderPass = this.bindOceanShader();
        this.setupOceanRendering(renderPass, waterTexture, oceanWorld, layer);
        this.executeDrawCalls(renderPass, oceanWorld.format, normalMatrix, drawCalls);
        renderPass.close();
    }

    private void setupOceanRendering(RenderPass renderPass, GpuTextureView waterTexture, OceanWorld oceanWorld, @Nullable ProxyOceanLayer layer) {
        GlRenderPass glRenderPass = (GlRenderPass)renderPass;
        PhysicsShaderExtension program = (PhysicsShaderExtension)glRenderPass.pipeline.program();
        if (StarterClient.iris && Iris.isExtending()) {
            midCoord = oceanWorld.getWaterMidCoord();
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_TERRAIN_SHADER.getAttribute(), (float)midCoord.x, (float)midCoord.y);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_TERRAIN_SHADER.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            mcEntityLocation = 5;
            GL32C.glVertexAttrib4f((int)mcEntityLocation, (float)Iris.getMaterialID(Blocks.WATER.defaultBlockState()), (float)1.0f, (float)-1.0f, (float)-1.0f);
        } else if (StarterClient.optifabric) {
            midCoord = oceanWorld.getWaterMidCoord();
            GL32C.glVertexAttrib2f((int)Data.MID_TEX_COORD_OPTIFINE.getAttribute(), (float)midCoord.x, (float)midCoord.y);
            GL32C.glVertexAttrib4f((int)Data.TANGENT_OPTIFINE.getAttribute(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            mcEntityLocation = Optifine.isUsingShadersNoInternal() ? 11 : -1;
            if (mcEntityLocation != -1) {
                GL32C.glVertexAttrib4f((int)mcEntityLocation, (float)Optifine.getMaterialID(Blocks.WATER.defaultBlockState()), (float)Optifine.getRenderType(Blocks.WATER.defaultBlockState()), (float)-1.0f, (float)-1.0f);
            }
        }
        int physicsGameTimeLocation = program.physicsmod$getUniformLocation("physics_gameTime");
        int globalGameTimeLocation = program.physicsmod$getUniformLocation("physics_globalTime");
        int physicsIterationsNormalLocation = program.physicsmod$getUniformLocation("physics_iterationsNormal");
        int physicsOceanHeightLocation = program.physicsmod$getUniformLocation("physics_oceanHeight");
        int oceanWaveHorizontalScaleLocation = program.physicsmod$getUniformLocation("physics_oceanWaveHorizontalScale");
        int rippleLocation = program.physicsmod$getUniformLocation("physics_ripples");
        int foamLocation = program.physicsmod$getUniformLocation("physics_foam");
        int lightmapLocation = program.physicsmod$getUniformLocation("physics_lightmap");
        int rippleRangeLocation = program.physicsmod$getUniformLocation("physics_rippleRange");
        int foamAmountLocation = program.physicsmod$getUniformLocation("physics_foamAmount");
        int foamOpacityLocation = program.physicsmod$getUniformLocation("physics_foamOpacity");
        int wavinessLocation = program.physicsmod$getUniformLocation("physics_waviness");
        if (physicsGameTimeLocation != -1) {
            GL32C.glUniform1f((int)physicsGameTimeLocation, (float)oceanWorld.getOceanTime());
        }
        if (globalGameTimeLocation != -1) {
            GL32C.glUniform1f((int)globalGameTimeLocation, (float)oceanWorld.getGlobalTime());
        }
        if (physicsIterationsNormalLocation != -1) {
            GL32C.glUniform1i((int)physicsIterationsNormalLocation, (int)(13 + (int)(ConfigClient.oceanDetail * 35.0f)));
        }
        if (physicsOceanHeightLocation != -1) {
            GL32C.glUniform1f((int)physicsOceanHeightLocation, (float)oceanWorld.getOceanHeight());
        }
        if (oceanWaveHorizontalScaleLocation != -1) {
            GL32C.glUniform1f((int)oceanWaveHorizontalScaleLocation, (float)ConfigClient.oceanHorizontalWaveScale);
        }
        if (rippleLocation != -1) {
            GL32C.glUniform1i((int)rippleLocation, (int)this.rippleActiveTexture);
        }
        if (foamLocation != -1) {
            GL32C.glUniform1i((int)foamLocation, (int)this.foamActiveTexture);
        }
        if (lightmapLocation != -1) {
            GL32C.glUniform1i((int)lightmapLocation, (int)this.lightmapActiveTexture);
        }
        if (rippleRangeLocation != -1) {
            GL32C.glUniform1f((int)rippleRangeLocation, (float)((float)this.rippleRenderer.getRippleRange()));
        }
        if (foamAmountLocation != -1) {
            GL32C.glUniform1f((int)foamAmountLocation, (float)ConfigClient.oceanFoamAmount);
        }
        if (foamOpacityLocation != -1) {
            GL32C.glUniform1f((int)foamOpacityLocation, (float)ConfigClient.oceanFoamOpacity);
        }
        if (wavinessLocation != -1) {
            GL32C.glUniform1i((int)wavinessLocation, (int)this.activeTexture);
        }
        GlStateManager._activeTexture((int)33984);
        GlStateManager._bindTexture((int)((GlTexture)waterTexture.texture()).glId());
        if (foamLocation != -1) {
            int foamTextureID = ((GlTexture)PhysicsMod.foamTexture.texture()).glId();
            GlStateManager._activeTexture((int)(33984 + this.foamActiveTexture));
            GlStateManagerPhysics._bindTexture(32879, foamTextureID);
        }
        if (lightmapLocation != -1) {
            Minecraft mc = Minecraft.getInstance();
            int lightmapTextureID = ((GlTexture)((MixinLightTextureAccessor)mc.gameRenderer.lightTexture()).getTarget()).glId();
            GlStateManager._activeTexture((int)(33984 + this.lightmapActiveTexture));
            GlStateManager._bindTexture((int)lightmapTextureID);
        }
        this.bindRippleTexture(layer);
        oceanWorld.bindForRendering();
    }

    private void bindRippleTexture(ProxyOceanLayer layer) {
        int rippleTextureID = this.rippleRenderer.getRippleTexture(layer);
        GlStateManager._activeTexture((int)(33984 + this.rippleActiveTexture));
        GlStateManager._bindTexture((int)rippleTextureID);
        GlStateManager._activeTexture((int)(33984 + this.activeTexture));
    }

    private RenderPass bindOceanShader() {
        RenderPipeline renderPipeline = RenderPipelines.TRANSLUCENT;
        GlRenderPipeline customPipeline = null;
        if (StarterClient.iris && Iris.isExtending()) {
            if (Iris.isShadowPass()) {
                if (Iris.getOceanShadowProgram() != null) {
                    customPipeline = new GlRenderPipeline(renderPipeline, Iris.getOceanShadowProgram());
                } else {
                    renderPipeline = RenderPipelines.SOLID;
                }
            } else if (Iris.getOceanProgram() != null) {
                customPipeline = new GlRenderPipeline(renderPipeline, Iris.getOceanProgram());
            } else {
                renderPipeline = RenderPipelines.TRANSLUCENT;
            }
        } else if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            renderPipeline = PhysicsShaders.PHYSICS_OCEAN_PIPELINE;
        }
        RenderPass renderPass = this.mainRenderer.bindProperShader(() -> "Physics Mod Ocean", renderPipeline, customPipeline);
        GlRenderPass glRenderPass = (GlRenderPass)renderPass;
        glRenderPass.encoder.trySetup(glRenderPass, Collections.emptyList());
        return renderPass;
    }

    private boolean isVisible(OceanWorld oceanWorld, OceanMesh oceanMesh, Vec3 view) {
        AABB3D modelBoundingBox = oceanMesh.aabb;
        Vector3d start = modelBoundingBox.start;
        Vector3d end = modelBoundingBox.end;
        float halfHeight = Math.max(0.5f, oceanWorld.getOceanHeight() * 0.5f * oceanMesh.maxInfluence);
        return this.mainRenderer.frustumInt.testAab((float)(start.x - view.x), (float)(start.y - view.y - (double)halfHeight), (float)(start.z - view.z), (float)(end.x - view.x), (float)(end.y - view.y + (double)halfHeight), (float)(end.z - view.z));
    }

    public void queueOceanDrawCall(Matrix4f cameraRotationMatrix, Vec3 view, OceanMesh oceanMesh, List<OceanDrawCall> drawCalls) {
        Matrix4d oceanTransformation = oceanMesh.transformation;
        this.transformation.m00((float)oceanTransformation.m00());
        this.transformation.m11((float)oceanTransformation.m11());
        this.transformation.m22((float)oceanTransformation.m22());
        this.transformation.m30((float)(oceanTransformation.m30() - view.x));
        this.transformation.m31((float)(oceanTransformation.m31() - view.y));
        this.transformation.m32((float)(oceanTransformation.m32() - view.z));
        cameraRotationMatrix.mul((Matrix4fc)this.transformation, this.currentPose);
        OceanDrawCall drawCall = new OceanDrawCall(this);
        drawCall.transform = MainRenderer.createTransformUniform(this.currentPose);
        drawCall.texture = oceanMesh.texture;
        drawCall.modelOffsetX = (float)(oceanTransformation.m30() - view.x);
        drawCall.modelOffsetY = (float)(oceanTransformation.m31() - view.y);
        drawCall.modelOffsetZ = (float)(oceanTransformation.m32() - view.z);
        drawCall.offsetX = oceanMesh.offsetX;
        drawCall.offsetZ = oceanMesh.offsetZ;
        drawCall.textureOffsetX = oceanMesh.textureOffsetX;
        drawCall.textureOffsetZ = oceanMesh.textureOffsetZ;
        drawCall.vertexSegment = oceanMesh.vertexSegment;
        drawCall.indexSegment = oceanMesh.indexSegment;
        drawCalls.add(drawCall);
    }

    private void uploadDrawCallTransforms(List<OceanDrawCall> drawCalls) {
        DynamicUniformsExtension dynamicUniforms = (DynamicUniformsExtension)RenderSystem.getDynamicUniforms();
        ((DynamicUniformStorageExtension)dynamicUniforms.physicsmod$getDynamicUniformStorage()).physicsmod$writeUniforms(drawCalls, drawCall -> drawCall.transform, (drawCall, gpuSlice) -> {
            drawCall.transformBuffer = gpuSlice;
        });
    }

    public void executeDrawCalls(RenderPass renderPass, VertexFormat format, Matrix3f normalMatrix, List<OceanDrawCall> drawCalls) {
        GlRenderPass glRenderPass = (GlRenderPass)renderPass;
        GlProgram program = glRenderPass.pipeline.program();
        Uniform.Ubo dynamicTransforms = (Uniform.Ubo)program.getUniform("DynamicTransforms");
        int size = drawCalls.size();
        int waveOffsetLocation = ((PhysicsShaderExtension)program).physicsmod$getUniformLocation("physics_waveOffset");
        int textureOffsetLocation = ((PhysicsShaderExtension)program).physicsmod$getUniformLocation("physics_textureOffset");
        int modelOffsetLocation = ((PhysicsShaderExtension)program).physicsmod$getUniformLocation("physics_modelOffset");
        if (StarterClient.optifabric) {
            GL32C.glVertexAttrib3f((int)Data.NORMAL.getAttribute(), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL32C.glVertexAttrib3f((int)Data.NORMAL_SHADER.getAttribute(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager._disableCull();
        for (int i = 0; i < size; ++i) {
            OceanDrawCall drawCall = drawCalls.get(i);
            int glID = drawCall.texture.getID();
            GlStateManager._activeTexture((int)(33984 + this.activeTexture));
            GlStateManager._bindTexture((int)glID);
            if (dynamicTransforms != null) {
                GpuBufferSlice slice = drawCall.transformBuffer;
                GL32C.glBindBufferRange((int)35345, (int)dynamicTransforms.blockBinding(), (int)((GlBuffer)slice.buffer()).handle, (long)slice.offset(), (long)slice.length());
            }
            if (StarterClient.iris) {
                Iris.setNormalMatrix(renderPass, drawCall.transform.modelView(), (Matrix3fc)normalMatrix);
            }
            if (modelOffsetLocation != -1) {
                GL32C.glUniform3f((int)modelOffsetLocation, (float)drawCall.modelOffsetX, (float)drawCall.modelOffsetY, (float)drawCall.modelOffsetZ);
            }
            if (waveOffsetLocation != -1) {
                GL32C.glUniform2f((int)waveOffsetLocation, (float)drawCall.offsetX, (float)drawCall.offsetZ);
            }
            if (textureOffsetLocation != -1) {
                GL32C.glUniform2i((int)textureOffsetLocation, (int)drawCall.textureOffsetX, (int)drawCall.textureOffsetZ);
            }
            ArenaBuffer.MemorySegment vertexSegment = drawCall.vertexSegment;
            ArenaBuffer.MemorySegment indexSegment = drawCall.indexSegment;
            int baseVertex = vertexSegment.offset / format.getStride();
            GL32C.glDrawElementsBaseVertex((int)4, (int)(indexSegment.size / 2), (int)5123, (long)indexSegment.offset, (int)baseVertex);
        }
        drawCalls.clear();
    }

    public static void destroy() {
        OceanRippleRenderer.destroy();
    }

    private class OceanDrawCall {
        public DynamicUniforms.Transform transform;
        public GpuBufferSlice transformBuffer;
        public Texture texture;
        public float modelOffsetX;
        public float modelOffsetY;
        public float modelOffsetZ;
        public int offsetX;
        public int offsetZ;
        public int textureOffsetX;
        public int textureOffsetZ;
        public ArenaBuffer.MemorySegment vertexSegment;
        public ArenaBuffer.MemorySegment indexSegment;

        private OceanDrawCall(OceanRenderer oceanRenderer) {
        }
    }
}

