/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.item.ItemAusweis;
import de.sarocesch.minewacheroleplaymod.item.ItemAusweisw;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.PacketOpenAusweisGui;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandAusweis
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandAusweis(ElementsMinewacheRolePlayMod instance) {
        super(instance, 10001);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new Handler());
    }

    public static class Handler
    extends CommandBase {
        public String func_71517_b() {
            return "ausweis";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/ausweis";
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, "minewachemod.command.ausweis");
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (!(sender instanceof EntityPlayerMP)) {
                throw new CommandException("Only players can use this command", new Object[0]);
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if (args.length == 0) {
                NetworkHandler.INSTANCE.sendTo((IMessage)new PacketOpenAusweisGui(), player);
                return;
            }
            if (args.length != 6) {
                throw new CommandException("Usage: /ausweis <vorname> <nachname> <geburtsdatum> <gr\u00f6\u00dfe> <geschlecht> <id-nummer>", new Object[0]);
            }
            String firstName = args[0];
            String lastName = args[1];
            String date = args[2];
            String height = args[3];
            String sex = args[4];
            String idNumber = args[5];
            if (!firstName.matches("[a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df-]+") || !lastName.matches("[a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df-]+")) {
                throw new CommandException("Ung\u00fcltige Namen. Nur Buchstaben erlaubt.", new Object[0]);
            }
            if (!date.matches("\\d{2}\\.\\d{2}\\.\\d{4}")) {
                throw new CommandException("Ung\u00fcltiges Datum. Format TT.MM.JJJJ", new Object[0]);
            }
            String string = "w".equalsIgnoreCase(sex) ? "w" : (sex = "m".equalsIgnoreCase(sex) ? "m" : "");
            if (sex.isEmpty()) {
                throw new CommandException("Ung\u00fcltiges Geschlecht. Verwende m oder w.", new Object[0]);
            }
            String normalizedHeight = height.trim().replace(',', '.');
            ItemStack ausweis = new ItemStack("w".equalsIgnoreCase(sex) ? ItemAusweisw.block : ItemAusweis.block);
            NBTTagCompound nbt = new NBTTagCompound();
            List<String> lore = Arrays.asList(firstName, lastName, date, normalizedHeight, sex, idNumber);
            nbt.func_74778_a("AusweisData", String.join((CharSequence)",", lore));
            ausweis.func_77982_d(nbt);
            if (!player.func_191521_c(ausweis)) {
                player.func_71019_a(ausweis, false);
            }
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            String[][] examples = new String[][]{{"Max", "Mustermann", "01.01.1990", "1.80", "m", "12345"}, {"Anna", "Schneider", "15.07.1995", "1.68", "w", "98765"}, {"Lukas", "M\u00fcller", "23.03.1988", "1.82", "m", "45678"}};
            int idx = (args.length == 0 ? 0 : Math.max(0, Math.min(examples.length - 1, args.length - 1))) % examples.length;
            String[] ex = examples[idx];
            switch (args.length) {
                case 0: {
                    return Collections.singletonList("ausweis");
                }
                case 1: {
                    return Collections.singletonList(ex[0]);
                }
                case 2: {
                    return Collections.singletonList(ex[1]);
                }
                case 3: {
                    return Arrays.asList(ex[2], "05.05.1993", "28.12.2001");
                }
                case 4: {
                    return Arrays.asList(ex[3], "1.75", "1.70");
                }
                case 5: {
                    return Arrays.asList("m", "w");
                }
                case 6: {
                    return Arrays.asList(ex[5], "10001", "77777");
                }
            }
            return Collections.emptyList();
        }

        public boolean func_82358_a(String[] args, int index) {
            return false;
        }
    }
}

