/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.GameType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandGmforceV
extends ElementsMinewacheRolePlayMod.ModElement {
    private static final Map<String, GameType> playerForcedGameModes = new HashMap<String, GameType>();

    public CommandGmforceV(ElementsMinewacheRolePlayMod instance) {
        super(instance, 380);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            this.enforceGameModeRestriction(player);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            this.enforceGameModeRestriction(player);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            this.enforceGameModeRestriction(player);
        }
    }

    private void enforceGameModeRestriction(EntityPlayerMP player) {
        GameType forcedGameMode = playerForcedGameModes.get(player.func_70005_c_());
        if (forcedGameMode != null && player.field_71134_c.func_73081_b() != forcedGameMode) {
            player.func_71033_a(forcedGameMode);
            LangNetworkHandler.sendTranslationMessage((ICommandSender)player, "message.forced_mode", Dateiverwaltung.warning, forcedGameMode.func_77149_b());
        }
    }

    public static class CommandHandler
    implements ICommand {
        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, this.func_71517_b());
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            if (args.length == 2) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"survival", "creative", "adventure", "spectator"});
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        public String func_71517_b() {
            return "gmforcev";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/gmforcev <playername> <gamemode>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            GameType gameMode;
            if (args.length < 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + I18n.func_74838_a((String)"message.usage")));
                return;
            }
            String playerName = args[0];
            String gameModeString = args[1];
            switch (gameModeString.toLowerCase()) {
                case "survival": {
                    gameMode = GameType.SURVIVAL;
                    break;
                }
                case "creative": {
                    gameMode = GameType.CREATIVE;
                    break;
                }
                case "adventure": {
                    gameMode = GameType.ADVENTURE;
                    break;
                }
                case "spectator": {
                    gameMode = GameType.SPECTATOR;
                    break;
                }
                default: {
                    LangNetworkHandler.sendTranslationMessage(sender, "message.invalid_gamemode", Dateiverwaltung.error, gameModeString);
                    return;
                }
            }
            EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
            if (player == null) {
                LangNetworkHandler.sendTranslationMessage(sender, "message.player_not_found", Dateiverwaltung.error, playerName);
                return;
            }
            if (playerForcedGameModes.containsKey(playerName)) {
                playerForcedGameModes.remove(playerName);
                LangNetworkHandler.sendTranslationMessage(sender, "message.no_longer_forced", Dateiverwaltung.sucess, playerName);
                LangNetworkHandler.sendTranslationMessage((ICommandSender)player, "message.you_can_change", Dateiverwaltung.sucess, new Object[0]);
                server.func_71187_D().func_71556_a((ICommandSender)server, "cpm setskin -r " + playerName);
            } else {
                playerForcedGameModes.put(playerName, gameMode);
                LangNetworkHandler.sendTranslationMessage(sender, "message.now_forced", Dateiverwaltung.sucess, playerName, gameMode.func_77149_b());
                LangNetworkHandler.sendTranslationMessage((ICommandSender)player, "message.your_mode", Dateiverwaltung.sucess, gameMode.func_77149_b());
                player.func_71033_a(gameMode);
                server.func_71187_D().func_71556_a((ICommandSender)server, "cpm setskin -f " + playerName + " UwsBAQMKAAEBAAgCCQEAAAAAADA=");
            }
        }
    }
}

