/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import com.mojang.authlib.GameProfile;
import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandTpoffline
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandTpoffline(ElementsMinewacheRolePlayMod instance) {
        super(instance, 289);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    extends CommandBase {
        private static final String COMMAND_NAME = "tpoffline";
        private static final int PERMISSION_LEVEL = 2;

        public String func_71517_b() {
            return COMMAND_NAME;
        }

        public String func_71518_a(ICommandSender sender) {
            return new TextComponentTranslation("command.tpoffline.usage", new Object[0]).func_150254_d();
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, COMMAND_NAME);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 1) {
                throw new CommandException("commands.tpoffline.usage", new Object[0]);
            }
            String playerName = args[0];
            PlayerProfileCache profileCache = server.func_152358_ax();
            GameProfile profile = profileCache.func_152655_a(playerName);
            if (profile == null) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.tpoffline.player_not_found", Dateiverwaltung.warning, playerName);
                return;
            }
            UUID playerUUID = profile.getId();
            NBTTagCompound playerData = this.getPlayerData(server, playerUUID);
            if (playerData == null) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.tpoffline.no_data", Dateiverwaltung.warning, playerName);
                return;
            }
            NBTTagList posList = playerData.func_150295_c("Pos", 6);
            if (posList == null || posList.func_74745_c() < 3) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.tpoffline.invalid_pos_data", Dateiverwaltung.warning, playerName);
                return;
            }
            double posX = posList.func_150309_d(0);
            double posY = posList.func_150309_d(1);
            double posZ = posList.func_150309_d(2);
            if (sender instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                player.func_70634_a(posX, posY, posZ);
                LangNetworkHandler.sendTranslationMessage((ICommandSender)player, "command.tpoffline.success", Dateiverwaltung.standard, playerName);
            }
        }

        private NBTTagCompound getPlayerData(MinecraftServer server, UUID uuid) {
            try {
                File playerDir = new File(server.func_71218_a(0).func_72860_G().func_75765_b(), "playerdata");
                File playerFile = new File(playerDir, uuid.toString() + ".dat");
                if (playerFile.exists() && playerFile.isFile()) {
                    FileInputStream fis = new FileInputStream(playerFile);
                    NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)fis);
                    fis.close();
                    return compound;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                ArrayList names = new ArrayList();
                PlayerProfileCache profileCache = server.func_152358_ax();
                Collections.addAll(names, profileCache.func_152654_a());
                return CommandHandler.func_175762_a((String[])args, names);
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }
    }
}

