/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListIPBans;
import net.minecraft.server.management.UserListIPBansEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandUnbanIP
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandUnbanIP(ElementsMinewacheRolePlayMod instance) {
        super(instance, 287);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new UnbanIPCommandHandler());
    }

    public static class UnbanIPCommandHandler
    implements ICommand {
        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, this.func_71517_b());
        }

        public List<String> func_71514_a() {
            return Collections.singletonList("unbanip");
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        public String func_71517_b() {
            return "unbanip";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/unbanip <IP-Adresse>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 1) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.unbanip.usage", Dateiverwaltung.error, new Object[0]);
                throw new CommandException("commands.unbanip.usage", new Object[0]);
            }
            String target = args[0];
            UserListIPBans ipBans = server.func_184103_al().func_72363_f();
            String ip = null;
            if (target.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) {
                ip = target;
            } else {
                EntityPlayerMP player = server.func_184103_al().func_152612_a(target);
                if (player != null) {
                    ip = player.func_71114_r();
                }
            }
            if (ip == null) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.unbanip.ip_not_found", Dateiverwaltung.error, target);
                throw new CommandException("commands.unbanip.ip_not_found", new Object[]{target});
            }
            InetSocketAddress socketAddress = new InetSocketAddress(ip, 0);
            UserListIPBansEntry entry = ipBans.func_152709_b((SocketAddress)socketAddress);
            if (entry != null) {
                try {
                    File bannedFile = new File(server.func_71209_f("banned-ips.json").getAbsolutePath());
                    JsonArray bannedList = new JsonParser().parse((Reader)new FileReader(bannedFile)).getAsJsonArray();
                    for (int i = 0; i < bannedList.size(); ++i) {
                        JsonObject jsonObject = bannedList.get(i).getAsJsonObject();
                        if (!jsonObject.get("ip").getAsString().equals(ip)) continue;
                        bannedList.remove(i);
                        LangNetworkHandler.sendTranslationMessage(sender, "command.unbanip.success", Dateiverwaltung.standard, ip);
                        break;
                    }
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    try (FileWriter writer = new FileWriter(bannedFile);){
                        gson.toJson((JsonElement)bannedList, (Appendable)writer);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LangNetworkHandler.sendTranslationMessage(sender, "command.unbanip.error", Dateiverwaltung.error, ip);
                }
            } else {
                LangNetworkHandler.sendTranslationMessage(sender, "command.unbanip.ip_not_banned", Dateiverwaltung.error, ip);
            }
        }
    }
}

