/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandUnbreakable
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandUnbreakable(ElementsMinewacheRolePlayMod instance) {
        super(instance, 292);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    implements ICommand {
        @Nullable
        public static List<String> getListOfStringsMatchingLastWord(String[] args, String ... possibilities) {
            String lastWord = args[args.length - 1];
            ArrayList<String> matches = new ArrayList<String>();
            for (String possibility : possibilities) {
                if (!CommandHandler.doesStringStartWith(lastWord, possibility)) continue;
                matches.add(possibility);
            }
            return matches;
        }

        private static boolean doesStringStartWith(String base, String start) {
            return start.regionMatches(true, 0, base, 0, base.length());
        }

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_71514_a() {
            return Collections.singletonList("unbreakable");
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        public String func_71517_b() {
            return "unbreakable";
        }

        public String func_71518_a(ICommandSender sender) {
            return new TextComponentTranslation("command.unbreakable.usage", new Object[0]).func_150254_d();
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            EntityPlayerMP targetPlayer;
            if (args.length == 0) {
                if (!(sender instanceof EntityPlayerMP)) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.unbreakable.not_a_player", Dateiverwaltung.error, new Object[0]);
                    return;
                }
                targetPlayer = (EntityPlayerMP)sender;
            } else {
                targetPlayer = this.getPlayer(server, sender, args[0]);
                if (targetPlayer == null) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.unbreakable.player_not_found", Dateiverwaltung.error, new Object[0]);
                    return;
                }
            }
            ItemStack heldItem = targetPlayer.func_184614_ca();
            if (heldItem != null && !heldItem.func_190926_b()) {
                NBTTagCompound itemTag = heldItem.func_77978_p();
                if (itemTag == null) {
                    itemTag = new NBTTagCompound();
                    heldItem.func_77982_d(itemTag);
                }
                itemTag.func_74757_a("Unbreakable", true);
                LangNetworkHandler.sendTranslationMessage(sender, "command.unbreakable.standard", Dateiverwaltung.standard, targetPlayer.func_70005_c_());
            } else {
                LangNetworkHandler.sendTranslationMessage(sender, "command.unbreakable.no_item", Dateiverwaltung.error, targetPlayer.func_70005_c_());
            }
        }

        private EntityPlayerMP getPlayer(MinecraftServer server, ICommandSender sender, String playerName) {
            return server.func_184103_al().func_152612_a(playerName);
        }
    }
}

