/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.discord;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Activity;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class DiscordBotStart
extends ElementsMinewacheRolePlayMod.ModElement {
    private static final Logger LOGGER = Logger.getLogger(DiscordBotStart.class.getName());
    public static JDA jda;

    public DiscordBotStart(ElementsMinewacheRolePlayMod instance) {
        super(instance, 293);
    }

    @Override
    public void initElements() {
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public void preInit(FMLPreInitializationEvent event) {
        Dateiverwaltung config = new Dateiverwaltung(new ElementsMinewacheRolePlayMod());
        config.preInit(event);
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public void serverLoad(FMLServerStartingEvent event) {
        this.initializeDiscordBot();
    }

    private void initializeDiscordBot() {
        try {
            String token = Dateiverwaltung.botToken;
            if (token == null || token.trim().isEmpty()) {
                LOGGER.warning("Discord bot token is not set in the configuration file. Bot will not start.");
                return;
            }
            LOGGER.info("Starting Discord bot...");
            jda = JDABuilder.createDefault((String)token).setActivity(Activity.playing((String)Dateiverwaltung.discordBotStatus)).build();
            jda.awaitReady();
            LOGGER.info("Discord bot started successfully with status: " + Dateiverwaltung.discordBotStatus);
        }
        catch (LoginException e) {
            LOGGER.log(Level.SEVERE, "Failed to login to Discord. Check bot token.", e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Discord bot initialization was interrupted.", e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected error during Discord bot initialization.", e);
        }
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
    }
}

