/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.phone;

import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CameraCaptureHooks {
    private static volatile boolean suppressHud = false;
    private static volatile boolean suppressHand = false;
    private static volatile int armedFrames = 0;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new CameraCaptureHooks());
    }

    public static void armCleanCaptureForNextFrame() {
        suppressHud = true;
        suppressHand = true;
        armedFrames = 2;
    }

    public static boolean shouldCaptureThisFrame() {
        return armedFrames == 1;
    }

    public static void tickArmed() {
        if (armedFrames > 0) {
            --armedFrames;
        }
    }

    public static void disarm() {
        suppressHud = false;
        suppressHand = false;
        armedFrames = 0;
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (suppressHand && armedFrames > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (!suppressHud || armedFrames <= 0) {
            return;
        }
        event.setCanceled(true);
    }
}

